/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonDesignerTestShapes;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DungeonPlacementDebug
extends DungeonPlacement {
    public static boolean place(ServerLevel world, long x, long z, int debugType, DungeonGenData genData) {
        long entranceChunkX = x / 16L + 8L;
        long entranceChunkZ = z / 16L + 11L;
        if (!DungeonPlacementDebug.isEntranceChunk(entranceChunkX, entranceChunkZ)) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: debug dungeon does not start at " + x + ", " + z);
            return false;
        }
        DimDungeons.logMessageInfo("DIMDUNGEONS START DEBUG STRUCTURE at " + x + ", " + z);
        DungeonDesigner dbl = new DungeonDesigner(world.m_5822_(), entranceChunkX, entranceChunkZ, DungeonDesigner.DungeonType.BASIC, genData.dungeonTheme);
        switch (debugType) {
            case 1: {
                DungeonDesignerTestShapes.MakeTestDungeonOne(dbl);
                break;
            }
            case 2: {
                DungeonDesignerTestShapes.MakeTestDungeonTwo(dbl);
                break;
            }
            case 3: {
                DungeonDesignerTestShapes.MakeTestDungeonThree(dbl);
                break;
            }
            case 4: {
                DungeonDesignerTestShapes.MakeTestDungeonFour(dbl);
                break;
            }
            case 5: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.FOURWAY);
                break;
            }
            case 6: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.THREEWAY);
                break;
            }
            case 7: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.HALLWAY);
                break;
            }
            case 8: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.CORNER);
                break;
            }
            case 9: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.BASIC, DungeonDesigner.RoomType.END);
                break;
            }
            case 10: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.FOURWAY);
                break;
            }
            case 11: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.THREEWAY);
                break;
            }
            case 12: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.HALLWAY);
                break;
            }
            case 13: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.CORNER);
                break;
            }
            case 14: {
                DungeonDesignerTestShapes.MakeTestDungeonDynamic(dbl, DungeonDesigner.DungeonType.ADVANCED, DungeonDesigner.RoomType.END);
                break;
            }
            case 15: {
                DungeonDesignerTestShapes.MakeTestDungeonForTheme(dbl, genData.dungeonTheme);
            }
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                ChunkPos cpos;
                DungeonRoom nextRoom = dbl.finalLayout[i][j];
                if (!nextRoom.hasRoom() || DungeonPlacementDebug.putRoomHere(cpos = new ChunkPos((int)x / 16 + i + 4, (int)z / 16 + j + 4), world, nextRoom, genData)) continue;
                DimDungeons.logMessageError("DIMDUNGEONS ERROR UNABLE TO PLACE STRUCTURE: " + nextRoom.structure);
            }
        }
        return true;
    }

    public static boolean isDungeonChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX > 3L && plotX < 12L && plotZ > 3L && plotZ < 12L;
    }

    public static boolean isEntranceChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX == 8L && plotZ == 11L;
    }

    public static void putTestStructureHere(long x, long z, LevelAccessor world) {
        ChunkPos cpos = new ChunkPos((int)x, (int)z);
        MinecraftServer minecraftserver = ((Level)world).m_142572_();
        StructureManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).m_8875_();
        StructureTemplate template = templatemanager.m_74341_(new ResourceLocation("dimdungeons:basic_template"));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(false);
        placementsettings.m_74381_(placementsettings.m_74409_());
        placementsettings.m_74379_(Rotation.NONE);
        BlockPos position = new BlockPos(cpos.m_45604_(), 50, cpos.m_45605_());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        template.m_74536_((ServerLevelAccessor)world, position, sizeRange, placementsettings, world.m_5822_(), 2);
    }

    public static boolean putRoomHere(ChunkPos cpos, ServerLevel world, DungeonRoom room, DungeonGenData genData) {
        MinecraftServer minecraftserver = world.m_142572_();
        StructureManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).m_8875_();
        StructureTemplate template = templatemanager.m_74341_(new ResourceLocation("dimdungeons:" + room.structure));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(false);
        placementsettings.m_74381_(placementsettings.m_74409_());
        placementsettings.m_74379_(room.rotation);
        BlockPos position = new BlockPos(cpos.m_45604_(), 50, cpos.m_45605_());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        if (template == null) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: Structure does not exist (" + room.structure + ")");
            return false;
        }
        if (room.rotation == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            position = position.m_142082_(0, 0, template.m_163801_().m_123343_() - 1);
        } else if (room.rotation == Rotation.CLOCKWISE_90) {
            placementsettings.m_74379_(Rotation.CLOCKWISE_90);
            position = position.m_142082_(template.m_163801_().m_123341_() - 1, 0, 0);
        } else if (room.rotation == Rotation.CLOCKWISE_180) {
            placementsettings.m_74379_(Rotation.CLOCKWISE_180);
            position = position.m_142082_(template.m_163801_().m_123341_() - 1, 0, template.m_163801_().m_123343_() - 1);
        } else {
            placementsettings.m_74379_(Rotation.NONE);
        }
        DimDungeons.logMessageInfo("Placing a room: " + room.structure);
        boolean success = template.m_74536_((ServerLevelAccessor)world, position, sizeRange, placementsettings, world.m_5822_(), 2);
        for (StructureTemplate.StructureBlockInfo template$blockinfo : template.m_74603_(position, placementsettings, Blocks.f_50677_)) {
            StructureMode structuremode;
            if (template$blockinfo.f_74677_ == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.f_74677_.m_128461_("mode"))) != StructureMode.DATA) continue;
            DungeonPlacementDebug.handleDataBlock(template$blockinfo.f_74677_.m_128461_("metadata"), template$blockinfo.f_74675_, world, world.m_5822_(), placementsettings.m_74409_(), room);
        }
        return success;
    }
}

