/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSecretBell
extends Item {
    public static final String REG_NAME = "item_secret_bell";
    public static final String NBT_UPGRADE = "upgrade";
    public static final String NBT_SECRET_X = "secret_x";
    public static final String NBT_SECRET_Y = "secret_y";
    public static final String NBT_SECRET_Z = "secret_z";
    public static final int BELL_COOLDOWN_TICKS = 60;
    public static final TagKey<Block> tag_secret_chime = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("dimdungeons", "secret_chime_blocks"));

    public ItemSecretBell(Item.Properties builderIn) {
        super(builderIn);
    }

    public static float getUpgradeLevelAsFloat(ItemStack stack) {
        if (((ItemSecretBell)stack.m_41720_()).getUpgradeLevel(stack) == 2) {
            return 0.2f;
        }
        return 0.1f;
    }

    public int getUpgradeLevel(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_UPGRADE)) {
            return stack.m_41783_().m_128451_(NBT_UPGRADE);
        }
        return 1;
    }

    public int getSecretX(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_SECRET_X)) {
            return stack.m_41783_().m_128451_(NBT_SECRET_X);
        }
        return -1;
    }

    public int getSecretY(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_SECRET_Y)) {
            return stack.m_41783_().m_128451_(NBT_SECRET_Y);
        }
        return -1;
    }

    public int getSecretZ(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_SECRET_Z)) {
            return stack.m_41783_().m_128451_(NBT_SECRET_Z);
        }
        return -1;
    }

    public void setUpgradeLevel(ItemStack stack, int level) {
        CompoundTag data = new CompoundTag();
        data.m_128405_(NBT_UPGRADE, level);
        data.m_128405_(NBT_SECRET_X, this.getSecretX(stack));
        data.m_128405_(NBT_SECRET_Y, this.getSecretY(stack));
        data.m_128405_(NBT_SECRET_Z, this.getSecretZ(stack));
        stack.m_41751_(data);
    }

    public void setSecretLocation(ItemStack stack, int x, int y, int z) {
        CompoundTag data = new CompoundTag();
        data.m_128405_(NBT_UPGRADE, this.getUpgradeLevel(stack));
        data.m_128405_(NBT_SECRET_X, x);
        data.m_128405_(NBT_SECRET_Y, y);
        data.m_128405_(NBT_SECRET_Z, z);
        stack.m_41751_(data);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (playerIn.m_20193_().f_46443_) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (this.getUpgradeLevel(itemstack) < 2 && !DungeonUtils.isDimensionDungeon(playerIn.m_20193_())) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (handIn == InteractionHand.MAIN_HAND) {
            playerIn.m_36335_().m_41524_((Item)this, 60);
            BlockPos secret = this.findSecretChestNearby(playerIn.m_142538_(), worldIn);
            this.setSecretLocation(itemstack, secret.m_123341_(), secret.m_123342_(), secret.m_123343_());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof Player) || !isSelected) {
            return;
        }
        Player playerIn = (Player)entityIn;
        int time = (int)(playerIn.m_36335_().m_41521_((Item)this, 0.0f) * 60.0f);
        if (time == 0) {
            return;
        }
        if (time == 60) {
            this.playSoundAtPosition(worldIn, entityIn.m_20185_(), entityIn.m_20186_() + 1.0, entityIn.m_20189_(), 13);
        }
        if (time == 57) {
            this.playSoundAtPosition(worldIn, entityIn.m_20185_(), entityIn.m_20186_() + 1.0, entityIn.m_20189_(), 12);
        }
        if (this.getSecretY(stack) > -10000) {
            BlockPos secretPos = new BlockPos((double)this.getSecretX(stack), (double)this.getSecretY(stack) + 1.0, (double)this.getSecretZ(stack));
            if (time == 54) {
                this.playSoundAtPosition(worldIn, entityIn.m_20185_(), entityIn.m_20186_() + 1.0, entityIn.m_20189_(), 9);
            }
            if (time == 51) {
                this.playSoundAtPosition(worldIn, entityIn.m_20185_(), entityIn.m_20186_() + 1.0, entityIn.m_20189_(), 3);
            }
            if (time == 48) {
                this.playSoundAtPosition(worldIn, (double)secretPos.m_123341_() + 0.5, (double)secretPos.m_123342_() + 0.2, (double)secretPos.m_123343_() + 0.5, 2);
            }
            if (time == 45) {
                this.playSoundAtPosition(worldIn, (double)secretPos.m_123341_() + 0.5, (double)secretPos.m_123342_() + 0.2, (double)secretPos.m_123343_() + 0.5, 10);
            }
            if (time == 42) {
                this.playSoundAtPosition(worldIn, (double)secretPos.m_123341_() + 0.5, (double)secretPos.m_123342_() + 0.2, (double)secretPos.m_123343_() + 0.5, 14);
            }
            if (time == 39) {
                this.playSoundAtPosition(worldIn, (double)secretPos.m_123341_() + 0.5, (double)secretPos.m_123342_() + 0.2, (double)secretPos.m_123343_() + 0.5, 18);
            }
        }
    }

    public void playSoundAtPosition(Level worldIn, double x, double y, double z, int note) {
        float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        worldIn.m_7785_(x, y, z, NoteBlockInstrument.BELL.m_61668_(), SoundSource.PLAYERS, (float)note, pitch, false);
        if (DungeonConfig.showParticles) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x + 1.0, y, z + 0.0, (double)note / 24.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x - 1.0, y, z + 0.0, (double)note / 24.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x + 0.0, y, z + 1.0, (double)note / 24.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x + 0.0, y, z - 1.0, (double)note / 24.0, 0.0, 0.0);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        attacker.m_20193_().m_5594_((Player)null, target.m_142538_(), SoundEvents.f_11699_, SoundSource.BLOCKS, 2.0f, 1.0f);
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState blockIn) {
        return false;
    }

    private BlockPos findSecretChestNearby(BlockPos start, Level worldIn) {
        int startX = Math.floorDiv(start.m_123341_(), 16) * 16;
        int startZ = Math.floorDiv(start.m_123343_(), 16) * 16;
        int startY = start.m_123342_() - 8;
        for (int x = startX; x < startX + 16; ++x) {
            for (int z = startZ; z < startZ + 16; ++z) {
                for (int y = startY; y < startY + 16; ++y) {
                    BlockState bs = worldIn.m_8055_(new BlockPos(x, y, z));
                    if (bs == null || !ForgeRegistries.BLOCKS.tags().getTag(tag_secret_chime).contains((Object)bs.m_60734_())) continue;
                    return new BlockPos(x, y, z);
                }
            }
        }
        return new BlockPos(-1, -10000, -1);
    }
}

