/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.dimension.PersonalBuildData;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemBlankBuildKey
extends BaseItemKey {
    public static final String REG_NAME = "item_blank_build_key";

    public ItemBlankBuildKey() {
        super(new Item.Properties().m_41497_(Rarity.COMMON).m_41491_(ItemRegistrar.CREATIVE_TAB));
    }

    @Override
    public void performActivationRitual(Player player, ItemStack itemstack, Level worldIn, BlockPos pos) {
        worldIn.m_5594_((Player)null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player == null) {
            DimDungeons.logMessageError("Somehow activated a blank personal key without a player present. Do not do this.");
            return;
        }
        if (!worldIn.f_46443_) {
            int slot = player.m_150109_().m_36030_(itemstack);
            itemstack.m_41774_(1);
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.item_build_key);
            this.activateBuildKey(worldIn.m_142572_(), newkey, (LivingEntity)player);
            if (!player.m_150109_().m_36040_(slot, newkey) && !player.m_36356_(newkey)) {
                player.m_36176_(newkey, false);
            }
        }
        this.createActivationParticleEffects(worldIn, pos);
        this.createActivationParticleEffectsForBuildKey(worldIn, pos);
    }

    public void activateBuildKey(MinecraftServer server, ItemStack stack, LivingEntity player) {
        CompoundTag data = new CompoundTag();
        data.m_128379_("key_activated", true);
        data.m_128379_("built", false);
        data.m_128359_("dungeon_type", DungeonDesigner.DungeonType.PERSONAL_BUILD.toString());
        ChunkPos dest = PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(server)).getPosForOwner(player);
        data.m_128405_("dest_x", dest.f_45578_);
        data.m_128405_("dest_z", dest.f_45579_);
        stack.m_41714_((Component)new TranslatableComponent("npart.dimdungeons.struct_8").m_130946_(" " + player.m_7755_().getString()));
        stack.m_41751_(data);
    }

    public void createActivationParticleEffectsForBuildKey(Level worldIn, BlockPos pos) {
        Random random = worldIn.m_5822_();
        for (int i = 0; i < 8; ++i) {
            double d0 = (float)pos.m_123341_() + 0.5f;
            double d1 = (float)pos.m_123342_() + 0.8f;
            double d2 = (float)pos.m_123343_() + 0.5f;
            double xspeed = (double)random.nextFloat() * 0.04 * (double)(random.nextBoolean() ? 1 : -1);
            double yspeed = (double)random.nextFloat() * 0.65;
            double zspeed = (double)random.nextFloat() * 0.04 * (double)(random.nextBoolean() ? 1 : -1);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, xspeed, yspeed, zspeed);
        }
    }
}

