/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseItemKey
extends Item {
    public static final String NBT_KEY_ACTIVATED = "key_activated";
    public static final String NBT_BUILT = "built";
    public static final String NBT_KEY_DESTINATION_X = "dest_x";
    public static final String NBT_KEY_DESTINATION_Z = "dest_z";
    public static final String NBT_NAME_TYPE = "name_type";
    public static final String NBT_NAME_PART_1 = "name_part_1";
    public static final String NBT_NAME_PART_2 = "name_part_2";
    public static final String NBT_THEME = "theme";
    public static final String NBT_DUNGEON_TYPE = "dungeon_type";
    public static final int BLOCKS_APART_PER_DUNGEON = 256;
    public static final float ENTRANCE_OFFSET_X = 136.0f;
    public static final float ENTRANCE_OFFSET_Z = 188.5f;

    public BaseItemKey(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public int getKeyLevel(ItemStack stack) {
        if (!this.isActivated(stack)) {
            return 0;
        }
        if (this.getWarpZ(stack) < 0.0f || this.getDungeonType(stack) == DungeonDesigner.DungeonType.ADVANCED) {
            return 2;
        }
        return 1;
    }

    public void activateKeyLevel1(MinecraftServer server, ItemStack stack, int theme) {
        CompoundTag data = new CompoundTag();
        data.m_128379_(NBT_KEY_ACTIVATED, true);
        data.m_128379_(NBT_BUILT, false);
        data.m_128405_(NBT_THEME, theme);
        data.m_128359_(NBT_DUNGEON_TYPE, DungeonDesigner.DungeonType.BASIC.toString());
        long generation_limit = DungeonUtils.getLimitOfWorldBorder(server);
        long dungeonsPerLimit = generation_limit / 256L;
        int nextDungeonNumber = DungeonData.get((Level)server.m_129880_(DimDungeons.DUNGEON_DIMENSION)).getNumKeysRegistered() + 1;
        long destZ = (long)nextDungeonNumber / dungeonsPerLimit;
        long destX = (long)nextDungeonNumber % dungeonsPerLimit;
        data.m_128405_(NBT_KEY_DESTINATION_X, (int)destX);
        data.m_128405_(NBT_KEY_DESTINATION_Z, (int)destZ);
        Random random = server.m_129783_().m_5822_();
        int nameType = random.nextInt(3);
        if (theme > 0) {
            nameType = 2;
        }
        data.m_128405_(NBT_NAME_TYPE, nameType);
        if (nameType == 0 || nameType == 1) {
            data.m_128405_(NBT_NAME_PART_1, random.nextInt(32));
            data.m_128405_(NBT_NAME_PART_2, random.nextInt(32));
        } else {
            data.m_128405_(NBT_NAME_PART_1, random.nextInt(20));
            data.m_128405_(NBT_NAME_PART_2, random.nextInt(32));
        }
        stack.m_41751_(data);
        DungeonData.get((Level)DungeonUtils.getDungeonWorld(server)).notifyOfNewKeyActivation();
    }

    public void activateKeyLevel2(MinecraftServer server, ItemStack stack) {
        CompoundTag data = new CompoundTag();
        data.m_128379_(NBT_KEY_ACTIVATED, true);
        data.m_128379_(NBT_BUILT, false);
        data.m_128405_(NBT_THEME, 0);
        data.m_128359_(NBT_DUNGEON_TYPE, DungeonDesigner.DungeonType.ADVANCED.toString());
        long generation_limit = DungeonUtils.getLimitOfWorldBorder(server);
        long dungeonsPerLimit = generation_limit / 256L;
        long nextDungeonNumber = DungeonData.get((Level)server.m_129880_(DimDungeons.DUNGEON_DIMENSION)).getNumKeysRegistered() + 1;
        long destZ = nextDungeonNumber / dungeonsPerLimit;
        long destX = nextDungeonNumber % dungeonsPerLimit;
        data.m_128405_(NBT_KEY_DESTINATION_X, (int)destX);
        data.m_128405_(NBT_KEY_DESTINATION_Z, (int)destZ);
        Random random = server.m_129783_().m_5822_();
        data.m_128405_(NBT_NAME_TYPE, 3);
        data.m_128405_(NBT_NAME_PART_1, random.nextInt(20));
        data.m_128405_(NBT_NAME_PART_2, random.nextInt(12));
        stack.m_41751_(data);
        DungeonData.get((Level)DungeonUtils.getDungeonWorld(server)).notifyOfNewKeyActivation();
    }

    public void activateKeyForNewTeleporterHub(MinecraftServer server, ItemStack stack) {
        CompoundTag data = new CompoundTag();
        data.m_128379_(NBT_KEY_ACTIVATED, true);
        data.m_128379_(NBT_BUILT, false);
        data.m_128405_(NBT_THEME, 0);
        data.m_128359_(NBT_DUNGEON_TYPE, DungeonDesigner.DungeonType.TELEPORTER_HUB.toString());
        long generation_limit = DungeonUtils.getLimitOfWorldBorder(server);
        long dungeonsPerLimit = generation_limit / 256L;
        int nextDungeonNumber = DungeonData.get((Level)server.m_129880_(DimDungeons.DUNGEON_DIMENSION)).getNumKeysRegistered() + 1;
        long destZ = (long)nextDungeonNumber / dungeonsPerLimit;
        long destX = (long)nextDungeonNumber % dungeonsPerLimit;
        data.m_128405_(NBT_KEY_DESTINATION_X, (int)destX);
        data.m_128405_(NBT_KEY_DESTINATION_Z, (int)destZ);
        Random random = server.m_129783_().m_5822_();
        data.m_128405_(NBT_NAME_TYPE, 4);
        data.m_128405_(NBT_NAME_PART_1, random.nextInt(32));
        stack.m_41751_(data);
        DungeonData.get((Level)DungeonUtils.getDungeonWorld(server)).notifyOfNewKeyActivation();
    }

    public static void activateKeyForExistingTeleporterHub(MinecraftServer server, ItemStack stack, int destX, int destZ, int doorIndex) {
        CompoundTag data = new CompoundTag();
        data.m_128379_(NBT_KEY_ACTIVATED, true);
        data.m_128379_(NBT_BUILT, true);
        data.m_128405_(NBT_THEME, doorIndex);
        data.m_128359_(NBT_DUNGEON_TYPE, DungeonDesigner.DungeonType.TELEPORTER_HUB.toString());
        data.m_128405_(NBT_KEY_DESTINATION_X, destX);
        data.m_128405_(NBT_KEY_DESTINATION_Z, destZ);
        data.m_128405_(NBT_NAME_TYPE, 5);
        data.m_128405_(NBT_NAME_PART_1, doorIndex);
        stack.m_41751_(data);
    }

    public boolean isActivated(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_KEY_ACTIVATED);
    }

    public float getWarpX(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_(NBT_KEY_DESTINATION_X)) {
            DungeonDesigner.DungeonType dtype;
            if (itemData.m_128441_(NBT_DUNGEON_TYPE) && (dtype = DungeonDesigner.DungeonType.valueOf(itemData.m_128461_(NBT_DUNGEON_TYPE))) == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                float tempx = (float)(itemData.m_128451_(NBT_KEY_DESTINATION_X) * 256) + 136.0f;
                int doornum = itemData.m_128451_(NBT_THEME);
                int[] x_offset = new int[]{0, -16, -21, -21, -16, 0, 5, 5};
                return tempx + (float)x_offset[doornum];
            }
            return (float)(itemData.m_128451_(NBT_KEY_DESTINATION_X) * 256) + 136.0f;
        }
        return -1.0f;
    }

    public float getWarpZ(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_(NBT_KEY_DESTINATION_Z)) {
            DungeonDesigner.DungeonType dtype;
            if (itemData.m_128441_(NBT_DUNGEON_TYPE) && (dtype = DungeonDesigner.DungeonType.valueOf(itemData.m_128461_(NBT_DUNGEON_TYPE))) == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                float tempz = (float)(itemData.m_128451_(NBT_KEY_DESTINATION_Z) * 256) + 188.5f;
                int doornum = itemData.m_128451_(NBT_THEME);
                int[] z_offset = new int[]{0, 0, -5, -21, -26, -26, -21, -5};
                return tempz + (float)z_offset[doornum];
            }
            return (float)(itemData.m_128451_(NBT_KEY_DESTINATION_Z) * 256) + 188.5f;
        }
        return -1.0f;
    }

    public long getDungeonTopLeftX(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_(NBT_KEY_DESTINATION_X)) {
            return itemData.m_128451_(NBT_KEY_DESTINATION_X) * 256;
        }
        return -1L;
    }

    public long getDungeonTopLeftZ(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_(NBT_KEY_DESTINATION_Z)) {
            return itemData.m_128451_(NBT_KEY_DESTINATION_Z) * 256;
        }
        return -1L;
    }

    public int getDungeonTheme(ItemStack stack) {
        CompoundTag itemData;
        if (stack != null && !stack.m_41619_() && (itemData = stack.m_41783_()) != null && itemData.m_128441_(NBT_THEME)) {
            return itemData.m_128451_(NBT_THEME);
        }
        return -1;
    }

    public DungeonDesigner.DungeonType getDungeonType(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CompoundTag itemData = stack.m_41783_();
            if (itemData != null && itemData.m_128441_(NBT_DUNGEON_TYPE)) {
                return DungeonDesigner.DungeonType.valueOf(itemData.m_128461_(NBT_DUNGEON_TYPE));
            }
            if (this.getWarpZ(stack) < 0.0f) {
                return DungeonDesigner.DungeonType.ADVANCED;
            }
        }
        return DungeonDesigner.DungeonType.BASIC;
    }

    public boolean isBlockKeyCharger(BlockState state) {
        return state.m_60734_() == BlockRegistrar.block_key_charger || state.m_60734_() == BlockRegistrar.block_key_charger_used || state.m_60734_() == BlockRegistrar.block_key_charger_damaged;
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult m_6225_(UseOnContext parameters) {
        BlockState iblockstate;
        Random random;
        BlockPos pos;
        Level worldIn;
        block17: {
            worldIn = parameters.m_43725_();
            pos = parameters.m_8083_();
            Direction facing = parameters.m_43719_();
            double hitX = parameters.m_43720_().m_7096_();
            double hitZ = parameters.m_43720_().m_7094_();
            Player player = parameters.m_43723_();
            random = worldIn.m_5822_();
            iblockstate = worldIn.m_8055_(pos);
            ItemStack itemstack = parameters.m_43722_();
            hitX = Math.abs((double)((int)hitX) - hitX);
            hitZ = Math.abs((double)((int)hitZ) - hitZ);
            if (worldIn.m_8055_(pos) == null) return InteractionResult.PASS;
            if (worldIn.m_8055_(pos).m_60734_() == Blocks.f_50258_) {
                boolean isFilled = (Boolean)worldIn.m_8055_(pos).m_61143_((Property)EndPortalFrameBlock.f_53043_);
                if (hitX > (double)0.3f && hitX < (double)0.7f && hitZ > (double)0.3f && hitZ < (double)0.8f) {
                    if (!isFilled) {
                        if (facing != Direction.UP) return InteractionResult.PASS;
                        if (this.isActivated(itemstack)) {
                            worldIn.m_5594_((Player)null, pos, SoundEvents.f_12515_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            return InteractionResult.PASS;
                        }
                        this.performActivationRitual(player, itemstack, worldIn, pos);
                        return InteractionResult.SUCCESS;
                    }
                    break block17;
                } else {
                    worldIn.m_5594_((Player)null, pos, SoundEvents.f_11985_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.PASS;
                }
            }
            if (worldIn.m_8055_(pos).m_60734_().getRegistryName().m_135827_().equals("endrem")) {
                String blockid = worldIn.m_8055_(pos).m_60734_().getRegistryName().m_135815_();
                if (this.isActivated(itemstack)) {
                    worldIn.m_5594_((Player)null, pos, SoundEvents.f_12064_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.PASS;
                }
                if (!blockid.equals("end_creator") && !blockid.equals("end_creator_activated")) {
                    if (!blockid.equals("ancient_portal_frame")) return InteractionResult.PASS;
                }
                this.performActivationRitual(player, itemstack, worldIn, pos);
                return InteractionResult.SUCCESS;
            }
            if (!this.isBlockKeyCharger(worldIn.m_8055_(pos))) {
                worldIn.m_5594_((Player)null, pos, SoundEvents.f_11985_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.PASS;
            }
            if (hitX > (double)0.3f && hitX < (double)0.7f && hitZ > (double)0.3f && hitZ < (double)0.8f) {
                if (this.isActivated(itemstack)) {
                    worldIn.m_5594_((Player)null, pos, SoundEvents.f_12064_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.PASS;
                }
                this.performActivationRitual(player, itemstack, worldIn, pos);
                if (worldIn.f_46443_) return InteractionResult.PASS;
                String blockid = worldIn.m_8055_(pos).m_60734_().getRegistryName().m_135815_();
                int roll = worldIn.m_5822_().nextInt(100);
                if (blockid.equals(BlockRegistrar.REG_NAME_CHARGER_FULL)) {
                    if (roll < DungeonConfig.keyEnscriberDowngradeChanceFull) {
                        worldIn.m_5594_((Player)null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        worldIn.m_46597_(pos, BlockRegistrar.block_key_charger_used.m_49966_());
                        return InteractionResult.SUCCESS;
                    }
                    worldIn.m_5594_((Player)null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (blockid.equals(BlockRegistrar.REG_NAME_CHARGER_USED)) {
                    if (roll < DungeonConfig.keyEnscriberDowngradeChanceUsed) {
                        worldIn.m_5594_((Player)null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        worldIn.m_46597_(pos, BlockRegistrar.block_key_charger_damaged.m_49966_());
                        return InteractionResult.SUCCESS;
                    }
                    worldIn.m_5594_((Player)null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (!blockid.equals(BlockRegistrar.REG_NAME_CHARGER_DAMAGED)) return InteractionResult.SUCCESS;
                if (roll < DungeonConfig.keyEnscriberDowngradeChanceDamaged) {
                    worldIn.m_5594_((Player)null, pos, SoundEvents.f_11665_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    return InteractionResult.SUCCESS;
                }
                worldIn.m_5594_((Player)null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            worldIn.m_5594_((Player)null, pos, SoundEvents.f_11985_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        worldIn.m_7731_(pos, (BlockState)iblockstate.m_61124_((Property)EndPortalFrameBlock.f_53043_, (Comparable)Boolean.valueOf(false)), 2);
        worldIn.m_46717_(pos, Blocks.f_50258_);
        worldIn.m_5594_((Player)null, pos, SoundEvents.f_11897_, SoundSource.BLOCKS, 1.5f, 1.0f);
        worldIn.m_5594_((Player)null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 0.4f, 1.5f);
        int i = 0;
        while (i < 32) {
            double d0 = (float)pos.m_123341_() + 0.5f;
            double d1 = (float)pos.m_123342_() + 0.8f;
            double d2 = (float)pos.m_123343_() + 0.5f;
            double xspeed = (double)random.nextFloat() * 0.08 * (double)(random.nextBoolean() ? 1 : -1);
            double yspeed = (double)random.nextFloat() * 0.4;
            double zspeed = (double)random.nextFloat() * 0.08 * (double)(random.nextBoolean() ? 1 : -1);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d0, d1, d2, xspeed, yspeed, zspeed);
            ++i;
        }
        return InteractionResult.PASS;
    }

    public void performActivationRitual(Player player, ItemStack itemstack, Level worldIn, BlockPos pos) {
        worldIn.m_5594_((Player)null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.f_46443_) {
            this.activateKeyLevel1(worldIn.m_142572_(), itemstack, 0);
        }
        this.createActivationParticleEffects(worldIn, pos);
    }

    public void createActivationParticleEffects(Level worldIn, BlockPos pos) {
        Random random = worldIn.m_5822_();
        for (int i = 0; i < 32; ++i) {
            double d0 = (float)pos.m_123341_() + 0.5f;
            double d1 = (float)pos.m_123342_() + 0.8f;
            double d2 = (float)pos.m_123343_() + 0.5f;
            double xspeed = (double)random.nextFloat() * 0.04 * (double)(random.nextBoolean() ? 1 : -1);
            double yspeed = (double)random.nextFloat() * 0.125;
            double zspeed = (double)random.nextFloat() * 0.04 * (double)(random.nextBoolean() ? 1 : -1);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123815_, d0, d1, d2, xspeed, yspeed, zspeed);
        }
    }
}

