/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.dimension;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PersonalBuildData
extends SavedData {
    private ConcurrentHashMap<ChunkPos, OwnerData> ownerMap = new ConcurrentHashMap();
    private static String MY_DATA = "build_data";

    @Nonnull
    public static PersonalBuildData get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        if (!DungeonUtils.isDimensionPersonalBuild(level)) {
            throw new RuntimeException("PersonalBuildData is not supposed to exist in other dimensions! Calling this was probably unintended.");
        }
        DimensionDataStorage storage = ((ServerLevel)level).m_8895_();
        return (PersonalBuildData)storage.m_164861_(PersonalBuildData::new, PersonalBuildData::new, MY_DATA);
    }

    public OwnerData getOwnerAtPos(ChunkPos pos) {
        return this.ownerMap.getOrDefault(pos, null);
    }

    public ChunkPos getPosForOwner(LivingEntity player) {
        ChunkPos cpos;
        Iterator iter = ((ConcurrentHashMap.KeySetView)this.ownerMap.keySet()).iterator();
        if (player == null || !(player instanceof Player) && !DungeonConfig.enableDebugCheats) {
            DimDungeons.logMessageError("DIMENSIONAL DUNGEONS ERROR: registering personal key for a non-player or a null player.");
            return null;
        }
        while (iter.hasNext()) {
            cpos = (ChunkPos)iter.next();
            OwnerData nextOwner = this.ownerMap.get(cpos);
            if (!nextOwner.uuid.equals(player.m_142081_())) continue;
            DimDungeons.logMessageInfo("DIMENSIONAL DUNGEONS: Found existing build plot for player " + player.m_7755_().getString() + " at (" + cpos.f_45578_ + ", " + cpos.f_45579_ + ")");
            return cpos;
        }
        cpos = this.getNewChunkPos(this.ownerMap.size() + 1, player.m_20194_());
        DimDungeons.logMessageInfo("DIMENSIONAL DUNGEONS: Assigning player " + player.m_7755_().getString() + " the build plot at (" + cpos.f_45578_ + ", " + cpos.f_45579_ + ")");
        OwnerData newOwner = new OwnerData(player.m_142081_(), player.m_7755_().getString());
        this.ownerMap.computeIfAbsent(cpos, cp -> newOwner);
        this.m_77762_();
        return cpos;
    }

    protected ChunkPos getNewChunkPos(int numOtherPlayers, MinecraftServer server) {
        long generation_limit = DungeonUtils.getLimitOfPersonalBuildDimension(server);
        int plotsPerLimit = (int)(generation_limit / 512L);
        int destZ = numOtherPlayers / plotsPerLimit;
        int destX = numOtherPlayers % plotsPerLimit;
        return new ChunkPos(destX, destZ);
    }

    public void changeBlacklistMode(Player player, boolean isBlacklist) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        owner.isBlacklist = isBlacklist;
        this.ownerMap.put(this.getPosForOwner((LivingEntity)player), owner);
        this.m_77762_();
    }

    public boolean getBlacklistMode(Player player) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        return owner.isBlacklist;
    }

    public boolean isNameOnGuestList(Player player, String guestName) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        return owner.guestList.contains(guestName);
    }

    public boolean toggleNameOnGuestList(Player player, String guestName) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        if (owner.guestList.contains(guestName)) {
            owner.guestList.remove(guestName);
            this.ownerMap.put(this.getPosForOwner((LivingEntity)player), owner);
            this.m_77762_();
            return false;
        }
        owner.guestList.add(guestName);
        this.ownerMap.put(this.getPosForOwner((LivingEntity)player), owner);
        this.m_77762_();
        return true;
    }

    public void clearGuestListForPlayer(Player player) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        owner.guestList.clear();
        this.ownerMap.put(this.getPosForOwner((LivingEntity)player), owner);
        this.m_77762_();
    }

    public ArrayList<String> getGuestListForPlayer(Player player) {
        OwnerData owner = this.getOwnerAtPos(this.getPosForOwner((LivingEntity)player));
        return owner.guestList;
    }

    public boolean isPlayerAllowedInPersonalDimension(Player visitor, ChunkPos destination) {
        OwnerData owner = this.getOwnerAtPos(destination);
        if (owner == null) {
            return true;
        }
        String visitorName = visitor.m_36316_().getName();
        visitorName = visitorName.replace("[", "");
        visitorName = visitorName.replace("]", "");
        if ((visitorName = visitorName.replace(" ", "")).contentEquals(owner.playerName) || visitor.m_7500_() || DungeonConfig.disablePersonalDimSecurity) {
            return true;
        }
        if (owner.isBlacklist) {
            return !owner.guestList.contains(visitorName);
        }
        return owner.guestList.contains(visitorName);
    }

    public PersonalBuildData() {
    }

    public PersonalBuildData(CompoundTag tag) {
        ListTag allOwners = tag.m_128437_("player_data", (int)tag.m_7060_());
        for (Tag t : allOwners) {
            CompoundTag ownerTag = (CompoundTag)t;
            ChunkPos pos = new ChunkPos(ownerTag.m_128451_("x"), ownerTag.m_128451_("z"));
            UUID id = UUID.fromString(ownerTag.m_128461_("uuid"));
            String name = ownerTag.m_128461_("name");
            OwnerData owner = new OwnerData(id, name);
            if (ownerTag.m_128441_("isBlacklist")) {
                owner.isBlacklist = ownerTag.m_128471_("isBlacklist");
            }
            if (ownerTag.m_128441_("guestList")) {
                ListTag guests = ownerTag.m_128437_("guestList", 8);
                for (Tag g : guests) {
                    StringTag guestName = (StringTag)g;
                    owner.guestList.add(guestName.m_7916_());
                }
            }
            this.ownerMap.put(pos, owner);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag allOwners = new ListTag();
        this.ownerMap.forEach((chunkPos, owner) -> {
            CompoundTag ownerTag = new CompoundTag();
            ownerTag.m_128405_("x", chunkPos.f_45578_);
            ownerTag.m_128405_("z", chunkPos.f_45579_);
            ownerTag.m_128359_("uuid", owner.uuid.toString());
            ownerTag.m_128359_("name", owner.playerName);
            ownerTag.m_128379_("isBlacklist", owner.isBlacklist);
            if (owner.guestList != null && owner.guestList.size() > 0) {
                ListTag guests = new ListTag();
                owner.guestList.forEach(guest -> {
                    StringTag g = StringTag.m_129297_((String)guest);
                    guests.add((Object)g);
                });
                ownerTag.m_128365_("guestList", (Tag)guests);
            }
            allOwners.add((Object)ownerTag);
        });
        tag.m_128365_("player_data", (Tag)allOwners);
        return tag;
    }

    public void debugClearKnownOwners() {
        this.ownerMap.clear();
        this.m_77762_();
    }

    public class OwnerData {
        UUID uuid;
        String playerName;
        ArrayList<String> guestList;
        boolean isBlacklist;

        OwnerData(Player player) {
            this.uuid = player.m_142081_();
            this.playerName = player.m_7755_().getString();
            this.guestList = new ArrayList();
            this.isBlacklist = false;
        }

        OwnerData(UUID id, String name) {
            this.uuid = id;
            this.playerName = name;
            this.guestList = new ArrayList();
            this.isBlacklist = false;
        }
    }
}

