/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.dimension;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DungeonData
extends SavedData {
    private ConcurrentHashMap<ChunkPos, DungeonRoom> roomMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ChunkPos, DungeonRoom> remainingBuilds = new ConcurrentHashMap();
    private int numKeysRegistered = 0;
    private int ticksBetweenBuilds = 10;
    private static String MY_DATA = "dungeon_data";

    @Nonnull
    public static DungeonData get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("Don't access this client-side!");
        }
        if (!DungeonUtils.isDimensionDungeon(level)) {
            throw new RuntimeException("DungeonData is not supposed to exist in other dimensions! Calling this was probably unintended.");
        }
        DimensionDataStorage storage = ((ServerLevel)level).m_8895_();
        return (DungeonData)storage.m_164861_(DungeonData::new, DungeonData::new, MY_DATA);
    }

    public DungeonRoom getRoomAtPos(ChunkPos pos) {
        return this.roomMap.getOrDefault(pos, null);
    }

    public int getNumKeysRegistered() {
        return this.numKeysRegistered;
    }

    public boolean hasMoreRoomsToBuild() {
        return this.remainingBuilds.size() > 0;
    }

    public void notifyOfNewKeyActivation() {
        ++this.numKeysRegistered;
        this.m_77762_();
    }

    public void registerNewRooms(DungeonDesigner layout, long x, long z) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                DungeonRoom nextRoom = layout.finalLayout[i][j];
                if (!nextRoom.hasRoom()) continue;
                ChunkPos cpos = new ChunkPos((int)x / 16 + i + 4, (int)z / 16 + j + 4);
                this.roomMap.computeIfAbsent(cpos, cp -> nextRoom);
                this.remainingBuilds.computeIfAbsent(cpos, cp -> nextRoom);
            }
        }
        this.m_77762_();
    }

    public void tick(Level level) {
        --this.ticksBetweenBuilds;
        if (this.ticksBetweenBuilds <= 0 && this.remainingBuilds.size() > 0) {
            this.ticksBetweenBuilds = DungeonConfig.getDungeonBuildSpeed();
            ChunkPos cpos = (ChunkPos)((ConcurrentHashMap.KeySetView)this.remainingBuilds.keySet()).iterator().next();
            DungeonRoom nextBuild = this.remainingBuilds.get(cpos);
            this.remainingBuilds.remove(cpos);
            this.m_77762_();
            DimDungeons.logMessageInfo("Now building room: " + nextBuild.structure);
            DungeonPlacement.buildRoomAtChunk(DungeonUtils.getDungeonWorld(level.m_142572_()), cpos);
        }
    }

    public DungeonData() {
        this.numKeysRegistered = 0;
    }

    public DungeonData(CompoundTag tag) {
        ListTag allRooms = tag.m_128437_("room_data", (int)tag.m_7060_());
        for (Object t : allRooms) {
            CompoundTag roomTag = (CompoundTag)t;
            ChunkPos pos = new ChunkPos(roomTag.m_128451_("x"), roomTag.m_128451_("z"));
            DungeonRoom room = new DungeonRoom();
            room.structure = roomTag.m_128461_("structure");
            room.rotation = Rotation.valueOf((String)roomTag.m_128461_("rotation"));
            room.roomType = DungeonDesigner.RoomType.valueOf(roomTag.m_128461_("room_type"));
            room.dungeonType = DungeonDesigner.DungeonType.valueOf(roomTag.m_128461_("dungeon_type"));
            this.roomMap.put(pos, room);
        }
        ListTag newBuilds = tag.m_128437_("remaining_builds", (int)tag.m_7060_());
        for (Tag t : newBuilds) {
            CompoundTag roomTag = (CompoundTag)t;
            ChunkPos pos = new ChunkPos(roomTag.m_128451_("x"), roomTag.m_128451_("z"));
            DungeonRoom room = new DungeonRoom();
            room.structure = roomTag.m_128461_("structure");
            room.rotation = Rotation.valueOf((String)roomTag.m_128461_("rotation"));
            room.roomType = DungeonDesigner.RoomType.valueOf(roomTag.m_128461_("room_type"));
            room.dungeonType = DungeonDesigner.DungeonType.valueOf(roomTag.m_128461_("dungeon_type"));
            this.remainingBuilds.put(pos, room);
        }
        CompoundTag totalKeyData = tag.m_128469_("total_key_data");
        this.numKeysRegistered = totalKeyData.m_128451_("numKeysActivated");
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag allRooms = new ListTag();
        this.roomMap.forEach((chunkPos, room) -> {
            CompoundTag roomTag = new CompoundTag();
            roomTag.m_128405_("x", chunkPos.f_45578_);
            roomTag.m_128405_("z", chunkPos.f_45579_);
            roomTag.m_128359_("structure", room.structure);
            roomTag.m_128359_("rotation", room.rotation.toString());
            roomTag.m_128359_("room_type", room.roomType.toString());
            roomTag.m_128359_("dungeon_type", room.dungeonType.toString());
            roomTag.m_128405_("theme", room.theme);
            allRooms.add((Object)roomTag);
        });
        ListTag buildingRooms = new ListTag();
        this.remainingBuilds.forEach((chunkPos, room) -> {
            CompoundTag roomTag = new CompoundTag();
            roomTag.m_128405_("x", chunkPos.f_45578_);
            roomTag.m_128405_("z", chunkPos.f_45579_);
            roomTag.m_128359_("structure", room.structure);
            roomTag.m_128359_("rotation", room.rotation.toString());
            roomTag.m_128359_("room_type", room.roomType.toString());
            roomTag.m_128359_("dungeon_type", room.dungeonType.toString());
            roomTag.m_128405_("theme", room.theme);
            buildingRooms.add((Object)roomTag);
        });
        CompoundTag totalKeyData = new CompoundTag();
        totalKeyData.m_128405_("numKeysActivated", this.numKeysRegistered);
        tag.m_128365_("room_data", (Tag)allRooms);
        tag.m_128365_("remaining_builds", (Tag)buildingRooms);
        tag.m_128365_("total_key_data", (Tag)totalKeyData);
        return tag;
    }
}

