/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ObjectHolder;

public class TileEntityPortalKeyhole
extends BlockEntity {
    public static final String REG_NAME = "tileentity_portal_keyhole";
    @ObjectHolder(value="dimdungeons:tileentity_portal_keyhole")
    public static BlockEntityType<TileEntityPortalKeyhole> TYPE;
    private ItemStack objectInserted = ItemStack.f_41583_;
    private static final String ITEM_PROPERTY_KEY = "objectInserted";

    public TileEntityPortalKeyhole(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public static void buildTick(Level level, BlockPos pos, BlockState state, TileEntityPortalKeyhole self) {
        ItemPortalKey key = (ItemPortalKey)self.getObjectInserted().m_41720_();
        DungeonGenData genData = DungeonGenData.Create().setKeyItem(self.getObjectInserted()).setDungeonType(key.getDungeonType(self.getObjectInserted())).setTheme(key.getDungeonTheme(self.getObjectInserted())).setReturnPoint(BlockPortalKeyhole.getReturnPoint(state, pos), DungeonUtils.serializeDimensionKey((ResourceKey<Level>)level.m_46472_()));
        if (!(genData.keyItem.m_41720_() instanceof ItemPortalKey)) {
            DimDungeons.logMessageError("FATAL ERROR: Using a non-key item to build a dungeon? What happened?");
            return;
        }
        if (!((Boolean)state.m_61143_((Property)BlockPortalKeyhole.IS_BUILDING)).booleanValue()) {
            DimDungeons.logMessageError("DIMDUNGEONS ERROR: Keyhole block ticked when it should not have.");
        } else if (!DungeonData.get((Level)DungeonUtils.getDungeonWorld(level.m_142572_())).hasMoreRoomsToBuild()) {
            DungeonUtils.openPortalAfterBuild(level, pos, genData, self);
            BlockState newBlockState = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BlockPortalKeyhole.FACING, (Comparable)((Direction)state.m_61143_((Property)BlockPortalKeyhole.FACING)))).m_61124_((Property)BlockPortalKeyhole.FILLED, (Comparable)Boolean.valueOf(self.isFilled()))).m_61124_((Property)BlockPortalKeyhole.LIT, (Comparable)Boolean.valueOf(self.isActivated()))).m_61124_((Property)BlockPortalKeyhole.IS_BUILDING, (Comparable)Boolean.valueOf(false));
            level.m_46597_(pos, newBlockState);
        }
    }

    protected static int nextBuildStep(int currentStep, DungeonBuildSpeed speed) {
        if (speed == DungeonBuildSpeed.STOPPED) {
            return currentStep;
        }
        if (speed == DungeonBuildSpeed.SLOW) {
            return currentStep >= 650 ? 0 : currentStep + 1;
        }
        if (speed == DungeonBuildSpeed.NORMAL) {
            if (currentStep < 5) {
                return 5;
            }
            if (currentStep >= 650) {
                return 0;
            }
            return currentStep + 5;
        }
        if (speed == DungeonBuildSpeed.FASTEST) {
            if (currentStep < 10) {
                return 10;
            }
            if (currentStep >= 650) {
                return 0;
            }
            return currentStep + 10;
        }
        return 0;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_(ITEM_PROPERTY_KEY)) {
            this.setContents(ItemStack.m_41712_((CompoundTag)compound.m_128469_(ITEM_PROPERTY_KEY)));
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_(ITEM_PROPERTY_KEY, (Tag)this.objectInserted.m_41739_(new CompoundTag()));
    }

    public boolean isFilled() {
        return !this.objectInserted.m_41619_();
    }

    public boolean isActivated() {
        ItemStack item = this.getObjectInserted();
        if (item.m_41619_()) {
            return false;
        }
        if (item.m_41720_() instanceof BaseItemKey) {
            BaseItemKey key = (BaseItemKey)item.m_41720_();
            return key.isActivated(item);
        }
        return false;
    }

    public ItemStack getObjectInserted() {
        return this.objectInserted;
    }

    public void setContents(ItemStack item) {
        this.objectInserted = item;
        this.objectInserted.m_41764_(1);
        this.m_6596_();
    }

    public void removeContents() {
        this.objectInserted = ItemStack.f_41583_;
        this.m_6596_();
    }

    public static enum DungeonBuildSpeed {
        STOPPED,
        SLOW,
        NORMAL,
        FASTEST;

    }
}

