/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DungeonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ObjectHolder;

public class TileEntityGoldPortal
extends BlockEntity {
    public static final String REG_NAME = "tileentity_gold_portal";
    @ObjectHolder(value="dimdungeons:tileentity_gold_portal")
    public static BlockEntityType<TileEntityGoldPortal> TYPE;
    private double destX = 0.0;
    private double destY = -10000.0;
    private double destZ = 0.0;
    private Direction facing = Direction.NORTH;
    private int cooldown = DungeonConfig.portalCooldownTicks;
    private int lastUpdate = 0;
    private String destDimension = "minecraft:overworld";

    public TileEntityGoldPortal(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("destX") && compound.m_128441_("destY") && compound.m_128441_("destZ")) {
            this.destX = compound.m_128459_("destX");
            this.destY = compound.m_128459_("destY");
            this.destZ = compound.m_128459_("destZ");
        }
        if (compound.m_128441_("cooldown")) {
            this.cooldown = compound.m_128451_("cooldown");
        }
        this.destDimension = compound.m_128441_("destDimension") ? compound.m_128461_("destDimension") : "minecraft:overworld";
        this.facing = compound.m_128441_("facing") ? Direction.valueOf((String)compound.m_128461_("facing")) : Direction.NORTH;
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128347_("destX", this.destX);
        compound.m_128347_("destY", this.destY);
        compound.m_128347_("destZ", this.destZ);
        compound.m_128405_("cooldown", this.cooldown);
        compound.m_128359_("destDimension", this.destDimension);
        compound.m_128359_("facing", this.facing.name());
    }

    public void setDestination(double posX, double posY, double posZ, String destDim, Direction faceExit) {
        this.destX = posX;
        this.destY = posY;
        this.destZ = posZ;
        this.destDimension = destDim;
        this.facing = faceExit;
    }

    public BlockPos getDestination() {
        return new BlockPos(this.destX, this.destY, this.destZ);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public ResourceKey<Level> getDestinationDimension() {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.destDimension));
    }

    public Direction getExitDirection() {
        return this.facing;
    }

    public boolean needsUpdateThisTick(int tick) {
        return tick > this.lastUpdate;
    }

    public boolean setCooldown(int value, Level worldIn, BlockPos pos, int currentServerTick) {
        if (this.cooldown == value || currentServerTick <= this.lastUpdate) {
            return false;
        }
        this.cooldown = value;
        this.lastUpdate = currentServerTick;
        int numBlocksUpdated = 0;
        if (worldIn.m_7702_(pos.m_142125_()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.m_7702_(pos.m_142125_())).setCooldown(value, worldIn, pos.m_142125_(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.m_7702_(pos.m_142126_()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.m_7702_(pos.m_142126_())).setCooldown(value, worldIn, pos.m_142126_(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.m_7702_(pos.m_142127_()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.m_7702_(pos.m_142127_())).setCooldown(value, worldIn, pos.m_142127_(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.m_7702_(pos.m_142128_()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.m_7702_(pos.m_142128_())).setCooldown(value, worldIn, pos.m_142128_(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.m_7702_(pos.m_7494_()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.m_7702_(pos.m_7494_())).setCooldown(value, worldIn, pos.m_7494_(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.m_7702_(pos.m_7495_()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.m_7702_(pos.m_7495_())).setCooldown(value, worldIn, pos.m_7495_(), currentServerTick) ? 1 : 0;
        }
        return numBlocksUpdated > 0;
    }
}

