/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.CustomTeleporter;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.dimension.PersonalBuildData;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockGoldPortal
extends BaseEntityBlock {
    public static String REG_NAME = "block_gold_portal";
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final TagKey<Block> tag_portal_frame_blocks = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("dimdungeons", "portal_frame_blocks"));

    public BlockGoldPortal() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76298_).m_60978_(50.0f).m_60977_().m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_60910_().m_60953_(p -> 15));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!this.checkPortalIntegrity(state, (LevelAccessor)worldIn, pos)) {
            worldIn.m_46961_(pos, false);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.checkPortalIntegrity(state, (LevelAccessor)worldIn, pos)) {
            worldIn.m_46961_(pos, false);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.checkPortalIntegrity(stateIn, worldIn, currentPos)) {
            return stateIn;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public boolean m_7923_(BlockState state) {
        return true;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity tile;
        if (worldIn.f_46443_) {
            return;
        }
        if (!(entityIn instanceof ServerPlayer)) {
            return;
        }
        if (!entityIn.m_20159_() && !entityIn.m_20160_() && entityIn.m_6072_() && (tile = worldIn.m_7702_(pos)) != null && tile instanceof TileEntityGoldPortal) {
            TileEntityPortalKeyhole keyhole;
            TileEntityGoldPortal te = (TileEntityGoldPortal)worldIn.m_7702_(pos);
            BlockPos destination = te.getDestination();
            float warpX = destination.m_123341_();
            float warpY = destination.m_123342_();
            float warpZ = destination.m_123343_();
            ResourceKey<Level> destDim = te.getDestinationDimension();
            int cooldown = te.getCooldown();
            int currentTick = worldIn.m_142572_().m_129921_();
            if (!te.needsUpdateThisTick(currentTick)) {
                return;
            }
            if (cooldown > 0) {
                te.setCooldown(cooldown - 1, worldIn, pos, currentTick);
                return;
            }
            te.setCooldown(DungeonConfig.portalCooldownTicks, worldIn, pos, currentTick);
            if (destDim.m_135782_().m_135815_().equals("dungeon_dimension") && DungeonConfig.hardcoreMode && (keyhole = this.findKeyholeForThisPortal(state, (LevelAccessor)worldIn, pos)) != null) {
                keyhole.removeContents();
                BlockState emptyState = worldIn.m_8055_(keyhole.m_58899_());
                worldIn.m_46597_(keyhole.m_58899_(), (BlockState)((BlockState)emptyState.m_61124_((Property)BlockPortalKeyhole.FILLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockPortalKeyhole.LIT, (Comparable)Boolean.valueOf(false)));
            }
            if (destDim.m_135782_().m_135815_().equals("build_dimension")) {
                keyhole = this.findKeyholeForThisPortal(state, (LevelAccessor)worldIn, pos);
                if (keyhole == null) {
                    DimDungeons.logMessageError("Unable to check the permissions for a personal build dimension because the keyhole is missing.");
                } else {
                    ItemStack key = keyhole.getObjectInserted();
                    if (key.m_41720_() == ItemRegistrar.item_build_key) {
                        CompoundTag itemData = key.m_41783_();
                        ChunkPos cpos = new ChunkPos(itemData.m_128451_("dest_x"), itemData.m_128451_("dest_z"));
                        if (!PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(entityIn.m_20194_())).isPlayerAllowedInPersonalDimension((Player)((ServerPlayer)entityIn), cpos)) {
                            te.setCooldown(DungeonConfig.portalCooldownTicks, worldIn, pos, currentTick);
                            DungeonUtils.giveSecuritySystemPrompt((Player)((ServerPlayer)entityIn), "security.dimdungeons.player_failed_teleport");
                            return;
                        }
                        DimDungeons.logMessageInfo("You passed the permissions check!");
                    } else {
                        DimDungeons.logMessageError("Unable to check the permissions for a personal build dimension because the keyhole does not contain a key?");
                    }
                }
            }
            DimDungeons.logMessageInfo("Player is using a gold portal to teleport to (" + warpX + " " + warpY + " " + warpZ + ") in dimension " + destDim.m_135782_().toString() + ".");
            ServerPlayer player = (ServerPlayer)entityIn;
            this.actuallyPerformTeleport(player, player.m_20194_().m_129880_(te.getDestinationDimension()), warpX, warpY, warpZ, this.getReturnYawForDirection(te.getExitDirection()));
        }
    }

    protected float getReturnYawForDirection(Direction exitFacing) {
        switch (exitFacing) {
            case SOUTH: {
                return 0.0f;
            }
            case EAST: {
                return 270.0f;
            }
            case WEST: {
                return 90.0f;
            }
        }
        return 180.0f;
    }

    protected Entity actuallyPerformTeleport(ServerPlayer player, ServerLevel dim, double x, double y, double z, float yaw) {
        float destPitch = 0.0f;
        float destYaw = yaw;
        if (DungeonUtils.isDimensionDungeon((Level)dim)) {
            ChunkPos cpos = new ChunkPos(new BlockPos(x -= 0.0, y, z += 1.0));
            DungeonRoom entrance = DungeonData.get((Level)dim).getRoomAtPos(cpos);
            if (entrance != null && entrance.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
                player.m_8960_().m_135988_(dim.m_142572_().m_129889_().m_136041_(new ResourceLocation("dimdungeons:dungeons/enter_advanced_dungeon")), "advanced_dungeon");
            }
        } else if (DungeonUtils.isDimensionPersonalBuild((Level)dim) && !DungeonUtils.isPersonalBuildChunk(new BlockPos(x, y, z))) {
            x += 1.0;
            z += 0.5;
            if (DungeonUtils.isDimensionPersonalBuild((Level)player.m_183503_()) && DungeonUtils.isDimensionPersonalBuild((Level)dim)) {
                // empty if block
            }
        } else {
            x += 0.5;
            z += 0.5;
        }
        CustomTeleporter tele = new CustomTeleporter(dim);
        tele.setDestPos(x, y, z, destYaw, destPitch);
        player.changeDimension(dim, (ITeleporter)tele);
        return player;
    }

    protected void sendPlayerBackHome(ServerPlayer player) {
        float lastX = 0.0f;
        float lastY = 0.0f;
        float lastZ = 0.0f;
        float lastYaw = player.m_20155_().f_82471_;
        Optional respawn = player.m_21257_();
        if (respawn.isPresent()) {
            lastX = ((BlockPos)respawn.get()).m_123341_();
            lastY = ((BlockPos)respawn.get()).m_123342_() + 3;
            lastZ = ((BlockPos)respawn.get()).m_123343_();
        } else {
            lastX = player.m_20194_().m_129880_(Level.f_46428_).m_6106_().m_6789_();
            lastY = player.m_20194_().m_129880_(Level.f_46428_).m_6106_().m_6527_() + 2;
            lastZ = player.m_20194_().m_129880_(Level.f_46428_).m_6106_().m_6526_();
        }
        this.actuallyPerformTeleport(player, player.m_20194_().m_129880_(Level.f_46428_), lastX, lastY, lastZ, lastYaw);
    }

    public boolean checkPortalIntegrity(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (DungeonUtils.isDimensionPersonalBuild((Level)worldIn) && !DungeonUtils.isPersonalBuildChunk(pos)) {
            return true;
        }
        return DungeonUtils.isDimensionDungeon((Level)worldIn) || this.isPortalShapeIntact(state, worldIn, pos);
    }

    private boolean isPortalShapeIntact(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        TileEntityPortalKeyhole te = this.findKeyholeForThisPortal(state, worldIn, pos);
        if (te == null) {
            return false;
        }
        if (!te.isActivated()) {
            return false;
        }
        BlockState keyholeBlock = worldIn.m_8055_(te.m_58899_());
        boolean frameLevel1 = this.checkPortalFrameLevel1(worldIn, te.m_58899_());
        if (!frameLevel1) {
            return false;
        }
        ItemStack key = te.getObjectInserted();
        int keyLevel = ((BaseItemKey)key.m_41720_()).getKeyLevel(key);
        if (key.m_41720_() instanceof ItemPortalKey && keyLevel >= 2) {
            boolean frameLevel2 = false;
            frameLevel2 = keyholeBlock.m_61143_((Property)BlockPortalKeyhole.FACING) == Direction.WEST || keyholeBlock.m_61143_((Property)BlockPortalKeyhole.FACING) == Direction.EAST ? this.checkPortalFrameLevel2NorthSouth(worldIn, te.m_58899_()) : this.checkPortalFrameLevel2WestEast(worldIn, te.m_58899_());
            if (!frameLevel2) {
                return false;
            }
        }
        return true;
    }

    private TileEntityPortalKeyhole findKeyholeForThisPortal(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        BlockPos p = pos.m_7494_();
        for (int i = 0; i < 2; ++i) {
            BlockState keyhole = worldIn.m_8055_(p);
            if (keyhole.m_60734_() == BlockRegistrar.block_portal_keyhole) {
                return (TileEntityPortalKeyhole)worldIn.m_7702_(p);
            }
            p = p.m_7494_();
        }
        return null;
    }

    public static boolean isValidPortalFrameBlock(Block b) {
        return ForgeRegistries.BLOCKS.tags().getTag(tag_portal_frame_blocks).contains((Object)b);
    }

    private boolean checkPortalFrameLevel1(LevelAccessor worldIn, BlockPos keyhole) {
        BlockState keyholeState = worldIn.m_8055_(keyhole);
        ArrayList<BlockState> blocks = keyholeState.m_61143_((Property)BlockPortalKeyhole.FACING) == Direction.WEST || keyholeState.m_61143_((Property)BlockPortalKeyhole.FACING) == Direction.EAST ? BlockGoldPortal.getPortalFrameMaterialsNorthSouth(worldIn, keyhole) : BlockGoldPortal.getPortalFrameMaterialsWestEast(worldIn, keyhole);
        for (int i = 0; i < 9; ++i) {
            if (BlockGoldPortal.isValidPortalFrameBlock(blocks.get(i).m_60734_())) continue;
            return false;
        }
        return blocks.get(9).m_60734_() == BlockRegistrar.block_gilded_portal && blocks.get(10).m_60734_() == BlockRegistrar.block_gilded_portal;
    }

    public static ArrayList<BlockState> getPortalFrameMaterialsWestEast(LevelAccessor worldIn, BlockPos keyhole) {
        ArrayList<BlockState> retval = new ArrayList<BlockState>();
        retval.add(worldIn.m_8055_(keyhole.m_142125_().m_7495_()));
        retval.add(worldIn.m_8055_(keyhole.m_142125_().m_6625_(2)));
        retval.add(worldIn.m_8055_(keyhole.m_142126_().m_7495_()));
        retval.add(worldIn.m_8055_(keyhole.m_142126_().m_6625_(2)));
        retval.add(worldIn.m_8055_(keyhole.m_6625_(3)));
        retval.add(worldIn.m_8055_(keyhole.m_142386_(3).m_6625_(2)));
        retval.add(worldIn.m_8055_(keyhole.m_142386_(3).m_6625_(3)));
        retval.add(worldIn.m_8055_(keyhole.m_142385_(3).m_6625_(2)));
        retval.add(worldIn.m_8055_(keyhole.m_142385_(3).m_6625_(3)));
        retval.add(worldIn.m_8055_(keyhole.m_142386_(3).m_6625_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142385_(3).m_6625_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142386_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142385_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142386_(3).m_6625_(1).m_142390_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142386_(3).m_6625_(1).m_142383_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142385_(3).m_6625_(1).m_142390_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142385_(3).m_6625_(1).m_142383_(1)));
        return retval;
    }

    public static ArrayList<BlockState> getPortalFrameMaterialsNorthSouth(LevelAccessor worldIn, BlockPos keyhole) {
        ArrayList<BlockState> retval = new ArrayList<BlockState>();
        retval.add(worldIn.m_8055_(keyhole.m_142127_().m_7495_()));
        retval.add(worldIn.m_8055_(keyhole.m_142127_().m_6625_(2)));
        retval.add(worldIn.m_8055_(keyhole.m_142128_().m_7495_()));
        retval.add(worldIn.m_8055_(keyhole.m_142128_().m_6625_(2)));
        retval.add(worldIn.m_8055_(keyhole.m_6625_(3)));
        retval.add(worldIn.m_8055_(keyhole.m_142390_(3).m_6625_(2)));
        retval.add(worldIn.m_8055_(keyhole.m_142390_(3).m_6625_(3)));
        retval.add(worldIn.m_8055_(keyhole.m_142383_(3).m_6625_(2)));
        retval.add(worldIn.m_8055_(keyhole.m_142383_(3).m_6625_(3)));
        retval.add(worldIn.m_8055_(keyhole.m_142390_(3).m_6625_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142383_(3).m_6625_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142390_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142383_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142390_(3).m_6625_(1).m_142385_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142390_(3).m_6625_(1).m_142386_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142383_(3).m_6625_(1).m_142385_(1)));
        retval.add(worldIn.m_8055_(keyhole.m_142383_(3).m_6625_(1).m_142386_(1)));
        return retval;
    }

    private boolean checkPortalFrameLevel2WestEast(LevelAccessor worldIn, BlockPos keyhole) {
        if (worldIn.m_8055_(keyhole.m_142386_(1)).m_60734_() != BlockRegistrar.block_portal_crown || worldIn.m_8055_(keyhole.m_142385_(1)).m_60734_() != BlockRegistrar.block_portal_crown) {
            return false;
        }
        int front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.m_142386_(3).m_6625_(1).m_142390_(1));
        int back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.m_142386_(3).m_6625_(1).m_142383_(1));
        if (front < 2 && back < 2) {
            return false;
        }
        front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.m_142385_(3).m_6625_(1).m_142390_(1));
        back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.m_142385_(3).m_6625_(1).m_142383_(1));
        return front >= 2 || back >= 2;
    }

    private boolean checkPortalFrameLevel2NorthSouth(LevelAccessor worldIn, BlockPos keyhole) {
        if (worldIn.m_8055_(keyhole.m_142390_(1)).m_60734_() != BlockRegistrar.block_portal_crown || worldIn.m_8055_(keyhole.m_142383_(1)).m_60734_() != BlockRegistrar.block_portal_crown) {
            return false;
        }
        int front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.m_142390_(3).m_6625_(1).m_142386_(1));
        int back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.m_142390_(3).m_6625_(1).m_142385_(1));
        if (front < 2 && back < 2) {
            return false;
        }
        front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.m_142383_(3).m_6625_(1).m_142386_(1));
        back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.m_142383_(3).m_6625_(1).m_142385_(1));
        return front >= 2 || back >= 2;
    }

    public static int getBannerLevel(LevelAccessor worldIn, BlockPos pos) {
        Block banner = worldIn.m_8055_(pos).m_60734_();
        if (banner != Blocks.f_50430_ && banner != Blocks.f_50388_) {
            return 0;
        }
        return 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (DungeonConfig.showParticles) {
            double d0 = (float)pos.m_123341_() + rand.nextFloat();
            double d1 = (float)pos.m_123342_() + 0.8f;
            double d2 = (float)pos.m_123343_() + rand.nextFloat();
            double xspeed = rand.nextFloat() * (float)(rand.nextInt(3) - 1) / 9.0f;
            double zspeed = rand.nextFloat() * (float)(rand.nextInt(3) - 1) / 9.0f;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d0, d1, d2, xspeed, 0.0, zspeed);
        }
    }

    public static BannerPattern getBannerForHash(String hash) {
        for (BannerPattern bannerpattern : BannerPattern.values()) {
            if (!bannerpattern.m_58579_().equals(hash)) continue;
            return bannerpattern;
        }
        return null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityGoldPortal(pos, state);
    }
}

