/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures.villages;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.tags.SkiesStructureTags;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageProfessions;
import com.legacy.structure_gel.api.registry.registrar.BiomeRegistrar;
import com.legacy.structure_gel.api.structure.GelJigsawStructure;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.common.util.Lazy;

public class SkiesVillageStructure
extends GelJigsawStructure<JigsawConfiguration> {
    public static final Lazy<Map<SkiesVillageBiomes, BiomeRegistrar>> BIOMES = Lazy.of(() -> Map.of(SkiesVillageBiomes.CALMING_SKIES, SkiesBiomes.CALMING_SKIES, SkiesVillageBiomes.BRIGHTLANDS, SkiesBiomes.SNOW_COVERED_PINES, SkiesVillageBiomes.SLUSHLANDS, SkiesBiomes.SLUSHLANDS, SkiesVillageBiomes.SHADED_WOODLANDS, SkiesBiomes.SHADED_WOODLANDS, SkiesVillageBiomes.SUNSET_MAPLE_FOREST, SkiesBiomes.SUNSET_MAPLE_FOREST, SkiesVillageBiomes.CRYSTAL_DUNES, SkiesBiomes.CRYSTAL_DUNES));

    public SkiesVillageStructure(Codec<JigsawConfiguration> config) {
        super(config, 0, true, true, SkiesVillageStructure::farFromDungeon, Piece::new);
    }

    public int getSpacing() {
        return 28;
    }

    public float getProbability() {
        return 0.75f;
    }

    private static boolean farFromDungeon(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos pos = context.f_197355_();
        return !StructureAccessHelper.hasFeatureChunkInRange((ChunkGenerator)context.f_197352_(), SkiesStructureTags.DUNGEONS, (RegistryAccess)context.f_197360_(), (long)context.f_197354_(), (ChunkPos)pos, (int)7);
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        private static final Map<String, EntityType<?>> BASIC_SPAWNS = new HashMap();

        public Piece(StructureManager templateManager, StructurePoolElement jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
            super(templateManager, jigsawPiece, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(context, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, Random rand, BoundingBox bounds) {
            if (BASIC_SPAWNS.containsKey(key)) {
                this.spawnEntity(BASIC_SPAWNS.get(key), pos, level, rand, null);
                return;
            }
            if (key.equals("cod")) {
                this.spawnEntity(EntityType.f_20556_, pos, level, rand, cod -> {
                    level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                    cod.m_21530_();
                });
                return;
            }
            if (key.contains("villager")) {
                this.spawnEntity(EntityType.f_20492_, pos, level, rand, villager -> {
                    if (key.contains("-")) {
                        villager.m_141967_(villager.m_7141_().m_35567_(Registry.f_122868_.m_6612_(BlueSkies.locate(key.split("-")[1])).orElseGet(() -> SkiesVillagers.CALMING_SKIES)));
                    }
                    if (rand.nextFloat() < 0.1f) {
                        if (rand.nextBoolean()) {
                            villager.m_141967_(villager.m_7141_().m_35565_(VillagerProfession.f_35596_));
                        } else {
                            villager.m_6863_(true);
                        }
                    }
                });
                return;
            }
            if (key.startsWith("chest")) {
                SkiesVillageBiomes biome;
                this.setAir((LevelAccessor)level, pos);
                String[] data = key.split("-");
                ResourceLocation lootTable = BuiltInLootTables.f_78755_;
                if (data.length > 2) {
                    SkiesVillageProfessions profession = SkiesVillageProfessions.from(data[2]);
                    if (profession != null) {
                        if (data[1].equals("bright")) {
                            lootTable = SkiesLootProv.VILLAGE_EVERBRIGHT_PROFESSIONS.get((Object)profession);
                        } else if (data[1].equals("dawn")) {
                            lootTable = SkiesLootProv.VILLAGE_EVERDAWN_PROFESSIONS.get((Object)profession);
                        }
                    }
                } else if (data.length > 1 && (biome = SkiesVillageBiomes.from(data[1])) != null) {
                    lootTable = SkiesLootProv.VILLAGE_BIOME_CHESTS.get((Object)biome);
                }
                RandomizableContainerBlockEntity.m_59620_((BlockGetter)level, (Random)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)lootTable);
                return;
            }
        }

        private <T extends Entity> void spawnEntity(EntityType<T> entityType, BlockPos pos, ServerLevelAccessor level, Random rand, @Nullable Consumer<T> modifyEntity) {
            this.setAir((LevelAccessor)level, pos);
            Entity entity = this.createEntity(entityType, level, pos, this.f_72599_);
            if (modifyEntity != null) {
                modifyEntity.accept(entity);
            }
            if (entity instanceof Mob) {
                ((Mob)entity).m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
            }
            level.m_7967_(entity);
        }

        public StructurePieceType m_210000_() {
            return SkiesStructures.BLUE_SKIES_VILLAGE.getPieceType();
        }

        static {
            BASIC_SPAWNS.put("golem", EntityType.f_20460_);
            BASIC_SPAWNS.put("azulfo", SkiesEntityTypes.AZULFO);
            BASIC_SPAWNS.put("ram", SkiesEntityTypes.STARDUST_RAM);
            BASIC_SPAWNS.put("monitor", SkiesEntityTypes.SHADE_MONITOR);
            BASIC_SPAWNS.put("camel", SkiesEntityTypes.CRYSTAL_CAMEL);
        }
    }
}

