/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.IStructureRestricted;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.material.Material;

public class SkyLakesFeature
extends Feature<BlockStateConfiguration>
implements IStructureRestricted {
    private static final BlockState AIR = Blocks.f_50627_.m_49966_();
    private boolean everDawn;

    public SkyLakesFeature(Codec<BlockStateConfiguration> codec, boolean everDawn) {
        super(codec);
        this.everDawn = everDawn;
    }

    public boolean m_142674_(FeaturePlaceContext<BlockStateConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = world.m_5822_();
        BlockStateConfiguration config = (BlockStateConfiguration)context.m_159778_();
        while (pos.m_123342_() > 5 && world.m_46859_(pos)) {
            pos = pos.m_7495_();
        }
        if (pos.m_123342_() <= 4) {
            return false;
        }
        if (!this.shouldGenerate(world, pos = pos.m_6625_(4))) {
            return false;
        }
        boolean[] aboolean = new boolean[2048];
        int i = rand.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = rand.nextDouble() * 6.0 + 3.0;
            double d1 = rand.nextDouble() * 4.0 + 2.0;
            double d2 = rand.nextDouble() * 6.0 + 3.0;
            double d3 = rand.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = rand.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = rand.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && aboolean[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && aboolean[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && aboolean[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && aboolean[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && aboolean[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && aboolean[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    Material material = world.m_8055_(pos.m_142082_(k1, k, l2)).m_60767_();
                    if (k >= 4 && material.m_76332_()) {
                        return false;
                    }
                    if (k >= 4 || material.m_76333_() || world.m_8055_(pos.m_142082_(k1, k, l2)) == config.f_67547_) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 8; ++i4) {
                    if (!aboolean[(l1 * 16 + i3) * 8 + i4]) continue;
                    world.m_7731_(pos.m_142082_(l1, i4, i3), i4 >= 4 ? AIR : config.f_67547_, 2);
                    BlockPos above = pos.m_142082_(l1, i4, i3).m_7494_();
                    if (world.m_8055_(above).m_60710_((LevelReader)world, above)) continue;
                    world.m_7731_(above, i4 >= 4 ? AIR : config.f_67547_, 2);
                }
            }
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int j4 = 4; j4 < 8; ++j4) {
                    BlockPos blockpos;
                    if (!aboolean[(i2 * 16 + j3) * 8 + j4] || !SkyLakesFeature.m_159759_((BlockState)world.m_8055_(blockpos = pos.m_142082_(i2, j4 - 1, j3))) || world.m_45517_(LightLayer.SKY, pos.m_142082_(i2, j4, j3)) <= 0) continue;
                    world.m_7731_(blockpos, this.everDawn ? SkiesBlocks.lunar_grass_block.m_49966_() : SkiesBlocks.turquoise_grass_block.m_49966_(), 2);
                }
            }
        }
        if (config.f_67547_.m_60767_() == Material.f_76307_) {
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int k3 = 0; k3 < 16; ++k3) {
                    for (int k4 = 0; k4 < 8; ++k4) {
                        boolean flag1;
                        boolean bl = flag1 = !aboolean[(j2 * 16 + k3) * 8 + k4] && (j2 < 15 && aboolean[((j2 + 1) * 16 + k3) * 8 + k4] || j2 > 0 && aboolean[((j2 - 1) * 16 + k3) * 8 + k4] || k3 < 15 && aboolean[(j2 * 16 + k3 + 1) * 8 + k4] || k3 > 0 && aboolean[(j2 * 16 + (k3 - 1)) * 8 + k4] || k4 < 7 && aboolean[(j2 * 16 + k3) * 8 + k4 + 1] || k4 > 0 && aboolean[(j2 * 16 + k3) * 8 + (k4 - 1)]);
                        if (!flag1 || k4 >= 4 && rand.nextInt(2) == 0 || !world.m_8055_(pos.m_142082_(j2, k4, k3)).m_60767_().m_76333_()) continue;
                        world.m_7731_(pos.m_142082_(j2, k4, k3), this.everDawn ? SkiesBlocks.lunar_stone.m_49966_() : SkiesBlocks.turquoise_stone.m_49966_(), 2);
                    }
                }
            }
        }
        if (config.f_67547_.m_60767_() == Material.f_76305_) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int l3 = 0; l3 < 16; ++l3) {
                    BlockPos blockpos1 = pos.m_142082_(k2, 4, l3);
                    if (!((Biome)world.m_204166_(blockpos1).m_203334_()).m_47480_((LevelReader)world, blockpos1, false)) continue;
                    world.m_7731_(blockpos1, Blocks.f_50126_.m_49966_(), 2);
                }
            }
        }
        return true;
    }
}

