/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.bunker;

import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.structure_gel.api.structure.GelJigsawStructure;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class FrozenBunkerStructure
extends GelJigsawStructure<JigsawConfiguration> {
    public FrozenBunkerStructure(Codec<JigsawConfiguration> config) {
        super(config, 0, true, true, FrozenBunkerStructure::isValidHeight, Piece::new);
    }

    protected static boolean isValidHeight(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos chunkPos = context.f_197355_();
        int height = FrozenBunkerStructure.getYValue(context.f_197357_(), context.f_197352_(), chunkPos.f_45578_ * 16, chunkPos.f_45579_ * 16);
        return height <= 80 && height >= 60;
    }

    public float getProbability() {
        return 0.7f;
    }

    public int getSpacing() {
        return 25;
    }

    public static int getYValue(LevelHeightAccessor level, ChunkGenerator chunkGen, int x, int z) {
        return chunkGen.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, level);
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(StructureManager template, StructurePoolElement jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox boundingBox) {
            super(template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super(context, nbt);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor worldIn, Random rand, BoundingBox bounds) {
            if (key.equals("spawner")) {
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                worldIn.m_7731_(pos, Blocks.f_50085_.m_49966_(), 3);
                if (worldIn.m_7702_(pos) instanceof SpawnerBlockEntity) {
                    SpawnerBlockEntity tile = (SpawnerBlockEntity)worldIn.m_7702_(pos);
                    tile.m_59801_().m_45462_(SkiesEntityTypes.ARMORED_FROST_SPIRIT);
                }
            } else if (key.startsWith("chest") && key.contains("-")) {
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                String facing = key.split("-")[1];
                boolean isRare = (double)rand.nextFloat() < 0.25;
                this.m_73420_(worldIn, bounds, rand, pos, isRare ? SkiesLootProv.BUNKER_RARE : SkiesLootProv.BUNKER, ((BlockState)(isRare ? SkiesBlocks.starlit_chest : SkiesBlocks.bluebright_chest).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.m_122402_((String)facing))).rotate((LevelAccessor)worldIn, pos, this.f_72599_));
            }
        }

        public StructurePieceType m_210000_() {
            return SkiesStructures.FROZEN_BUNKER.getPieceType();
        }
    }
}

