/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.SkiesChunkGenerator;
import com.legacy.blue_skies.world.SkiesSurfaceRuleData;
import com.legacy.blue_skies.world.everbright.biome.provider.EverbrightBiomeSource;
import com.legacy.blue_skies.world.everdawn.biome.provider.EverdawnBiomeSource;
import com.legacy.structure_gel.api.dimension.DimensionAccessHelper;
import com.legacy.structure_gel.api.dimension.DimensionTypeBuilder;
import com.legacy.structure_gel.api.events.RegisterDimensionEvent;
import com.legacy.structure_gel.api.registry.registrar.DimensionRegistrar;
import java.util.OptionalLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouterWithOnlyNoises;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SkiesDimensions {
    public static final ResourceLocation EVERBRIGHT_ID = BlueSkies.locate("everbright");
    public static final ResourceLocation EVERDAWN_ID = BlueSkies.locate("everdawn");
    private static DimensionRegistrar EVERBRIGHT;
    private static DimensionRegistrar EVERDAWN;

    public static void init() {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)BlueSkies.locate("skies_chunk_generator"), SkiesChunkGenerator.SKIES_CODEC);
        NoiseSettings noise = NoiseSettings.m_212298_((int)0, (int)384, (NoiseSamplingSettings)new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), (NoiseSlider)new NoiseSlider(-23.4375, 64, -46), (NoiseSlider)new NoiseSlider(-0.234375, 7, 1), (int)2, (int)1, (TerrainShaper)TerrainProvider.m_194816_((boolean)false));
        NoiseGeneratorSettings brightSettings = DimensionAccessHelper.newDimensionSettings((NoiseSettings)noise, (BlockState)SkiesBlocks.turquoise_stone.m_49966_(), (BlockState)Blocks.f_49990_.m_49966_(), (NoiseRouterWithOnlyNoises)DimensionAccessHelper.overworldNoiseRouter((NoiseSettings)noise, (boolean)false), (SurfaceRules.RuleSource)SkiesSurfaceRuleData.everbright(false, false, true), (int)63, (boolean)false);
        Function<RegisterDimensionEvent, ChunkGenerator> brightGenerator = e -> {
            long seed = e.getSeed() + 80085L;
            return new SkiesChunkGenerator((Registry<StructureSet>)e.getStructureSetRegistry(), (Registry<NormalNoise.NoiseParameters>)e.getNoiseRegistry(), new EverbrightBiomeSource((Registry<Biome>)e.getBiomeRegistry(), seed, brightSettings.f_64439_().f_158688_(), brightSettings.f_64439_().f_64508_()), seed, (Holder<NoiseGeneratorSettings>)e.getNoiseGeneratorSettingsRegistry().m_206081_(EVERBRIGHT.getSettingsKey()));
        };
        DimensionType brightDimensionType = DimensionTypeBuilder.of().fixedTime(OptionalLong.of(6000L)).minY(0).effects(EVERBRIGHT_ID).build();
        EVERBRIGHT = new DimensionRegistrar(EVERBRIGHT_ID, () -> brightDimensionType, () -> brightSettings, brightGenerator);
        NoiseGeneratorSettings dawnSettings = DimensionAccessHelper.newDimensionSettings((NoiseSettings)noise, (BlockState)SkiesBlocks.lunar_stone.m_49966_(), (BlockState)Blocks.f_49990_.m_49966_(), (NoiseRouterWithOnlyNoises)DimensionAccessHelper.overworldNoiseRouter((NoiseSettings)noise, (boolean)false), (SurfaceRules.RuleSource)SkiesSurfaceRuleData.everdawn(false, false, true), (int)63, (boolean)false);
        Function<RegisterDimensionEvent, ChunkGenerator> dawnGenerator = e -> {
            long seed = e.getSeed() + 1337L;
            return new SkiesChunkGenerator((Registry<StructureSet>)e.getStructureSetRegistry(), (Registry<NormalNoise.NoiseParameters>)e.getNoiseRegistry(), new EverdawnBiomeSource((Registry<Biome>)e.getBiomeRegistry(), seed, dawnSettings.f_64439_().f_158688_(), dawnSettings.f_64439_().f_64508_()), seed, (Holder<NoiseGeneratorSettings>)e.getNoiseGeneratorSettingsRegistry().m_206081_(EVERDAWN.getSettingsKey()));
        };
        DimensionType dawnDimensionType = DimensionTypeBuilder.of().fixedTime(OptionalLong.of(23200L)).minY(0).effects(EVERDAWN_ID).build();
        EVERDAWN = new DimensionRegistrar(EVERDAWN_ID, () -> dawnDimensionType, () -> dawnSettings, dawnGenerator);
    }

    public static ResourceKey<Level> everbrightKey() {
        return EVERBRIGHT.getLevelKey();
    }

    public static ResourceKey<Level> everdawnKey() {
        return EVERDAWN.getLevelKey();
    }

    public static boolean inSkyDimension(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.f_19853_.m_46472_() == SkiesDimensions.everbrightKey() || entity.f_19853_.m_46472_() == SkiesDimensions.everdawnKey();
    }
}

