/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.gui.toast.SkiesToast;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.util.StringUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class DisplayToastPacket {
    private byte toastId;

    public DisplayToastPacket(byte toastIdIn) {
        this.toastId = toastIdIn;
    }

    public static void encoder(DisplayToastPacket packet, FriendlyByteBuf buff) {
        buff.writeByte((int)packet.toastId);
    }

    public static DisplayToastPacket decoder(FriendlyByteBuf buff) {
        return new DisplayToastPacket(buff.readByte());
    }

    public static void handler(DisplayToastPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> DisplayToastPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(DisplayToastPacket packet) {
        if (packet.toastId <= 0) {
            SkiesPlayer.ifPresent(Minecraft.m_91087_().f_91074_, skyPlayer -> DisplayToastPacket.builder().withTitle(StringUtil.getBasicKey("toasts", "unlock_journal_entry")).withDesc(StringUtil.getBasicKey("toasts", !skyPlayer.hasUsedBlueLore() ? "unlock_journal_entry_no_book.desc" : "unlock_journal_entry.desc")).withSound(SoundEvents.f_12493_).build().beginDisplaying());
        } else if (packet.toastId == 1) {
            DisplayToastPacket.builder().withTitle(StringUtil.getBasicKey("toasts", "boss_room_death")).withDesc(StringUtil.getBasicKey("toasts", "boss_room_death.desc")).withDisplayItem((ItemLike)SkiesBlocks.bright_blinding_keystone).build().beginDisplaying();
        } else {
            int start = 15;
            Item key = packet.toastId == start + 1 ? SkiesItems.nature_key : (packet.toastId == start + 2 ? SkiesItems.poison_key : SkiesItems.blinding_key);
            String keyName = key.getRegistryName().m_135815_();
            DisplayToastPacket.builder().withTitle(StringUtil.getBasicKey("toasts", "unlock_key_trade")).withDesc(StringUtil.getBasicKey("toasts", "unlock_" + keyName + "_trade")).withDisplayItem((ItemLike)key).build().beginDisplaying();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static SkiesToast.Builder builder() {
        return SkiesToast.Builder.get();
    }
}

