/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.mod_compat.jei;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.gui.menu.AlchemyTableMenu;
import com.legacy.blue_skies.client.gui.menu.HorizoniteForgeMenu;
import com.legacy.blue_skies.client.gui.menu.SnowcapOvenMenu;
import com.legacy.blue_skies.client.gui.screen.ArcsScreen;
import com.legacy.blue_skies.client.gui.screen.HorizoniteForgeScreen;
import com.legacy.blue_skies.client.gui.screen.SnowcapOvenScreen;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.SnowcapMushroomFreezing;
import com.legacy.blue_skies.mod_compat.jei.JEIOverlayWrapper;
import com.legacy.blue_skies.mod_compat.jei.category.AlchemyCategory;
import com.legacy.blue_skies.mod_compat.jei.category.HorizoniteForgeFuelCategory;
import com.legacy.blue_skies.mod_compat.jei.category.SnowcapMushroomFreezingCategory;
import com.legacy.blue_skies.mod_compat.jei.category.SnowcapOvenFreezingCategory;
import com.legacy.blue_skies.mod_compat.jei.helpers.BlockIngredientHelper;
import com.legacy.blue_skies.mod_compat.jei.renderers.BlockIngredientRenderer;
import com.legacy.blue_skies.registries.SkiesBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

@JeiPlugin
public class SkiesJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = BlueSkies.locate("jei_plugin");
    public static final IIngredientType<BlockState> BLOCKSTATE = () -> BlockState.class;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addGuiContainerHandler(InventoryScreen.class, new JEIOverlayWrapper());
        reg.addGuiContainerHandler(ArcsScreen.class, new JEIOverlayWrapper());
        reg.addGuiContainerHandler(CreativeModeInventoryScreen.class, new JEIOverlayWrapper());
        reg.addRecipeClickArea(HorizoniteForgeScreen.class, 78, 32, 28, 23, new ResourceLocation[]{HorizoniteForgeFuelCategory.ID, VanillaRecipeCategoryUid.FURNACE});
        reg.addRecipeClickArea(SnowcapOvenScreen.class, 78, 16, 28, 49, new ResourceLocation[]{SnowcapOvenFreezingCategory.ID, VanillaRecipeCategoryUid.FURNACE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration reg) {
        reg.addRecipeTransferHandler(HorizoniteForgeMenu.class, VanillaRecipeCategoryUid.FURNACE, 0, 1, 3, 36);
        reg.addRecipeTransferHandler(HorizoniteForgeMenu.class, HorizoniteForgeFuelCategory.ID, 1, 1, 3, 36);
        reg.addRecipeTransferHandler(SnowcapOvenMenu.class, VanillaRecipeCategoryUid.FURNACE, 0, 1, 3, 36);
        reg.addRecipeTransferHandler(SnowcapOvenMenu.class, SnowcapOvenFreezingCategory.ID, 1, 1, 3, 36);
        reg.addRecipeTransferHandler(AlchemyTableMenu.class, AlchemyCategory.ID, 0, 2, 3, 36);
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new SnowcapMushroomFreezingCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new HorizoniteForgeFuelCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new SnowcapOvenFreezingCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlchemyCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        reg.addRecipes(SnowcapMushroomFreezingCategory.getAllRecipes(), SnowcapMushroomFreezingCategory.ID);
        reg.addRecipes(BlueSkiesData.HORIZONITE_FORGE_FUEL.getData().values(), HorizoniteForgeFuelCategory.ID);
        reg.addRecipes(BlueSkiesData.SNOWCAP_OVEN_FREEZING.getData().values(), SnowcapOvenFreezingCategory.ID);
        reg.addRecipes(BlueSkiesData.ALCHEMY_RECIPES.getData().values(), AlchemyCategory.ID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)SkiesBlocks.snowcap_mushroom), new ResourceLocation[]{SnowcapMushroomFreezingCategory.ID});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)SkiesBlocks.horizonite_forge), new ResourceLocation[]{HorizoniteForgeFuelCategory.ID});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)SkiesBlocks.snowcap_oven), new ResourceLocation[]{SnowcapOvenFreezingCategory.ID});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)SkiesBlocks.alchemy_table), new ResourceLocation[]{AlchemyCategory.ID});
    }

    public void registerIngredients(IModIngredientRegistration reg) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (SnowcapMushroomFreezing recipe : SnowcapMushroomFreezingCategory.getAllRecipes()) {
            this.addBlockStateIngredient(blocks, recipe.block);
            this.addBlockStateIngredient(blocks, recipe.frozenBlock);
        }
        BlockIngredientRenderer blockIngredientRenderer = new BlockIngredientRenderer();
        BlockIngredientHelper blockIngredientHelper = new BlockIngredientHelper();
        reg.register(BLOCKSTATE, (Collection)blocks.stream().map(Block::m_49966_).collect(Collectors.toList()), (IIngredientHelper)blockIngredientHelper, (IIngredientRenderer)blockIngredientRenderer);
    }

    private void addBlockStateIngredient(Set<Block> blocks, Block block) {
        if (Item.f_41373_.get(block) == null && !(block instanceof LiquidBlock)) {
            blocks.add(block);
        }
    }
}

