/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.villager.tasks;

import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.entities.villager.GatekeeperEntity;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class GatekeeperStayNearPointTask
extends Behavior<GatekeeperEntity> {
    private final MemoryModuleType<GlobalPos> memoryType;
    private final float speedModifier;
    private final int closeEnoughDist;
    private final int tooFarDistance;
    private final int tooLongUnreachableDuration;

    public GatekeeperStayNearPointTask(MemoryModuleType<GlobalPos> p_i51501_1_, float p_i51501_2_, int p_i51501_3_, int p_i51501_4_, int p_i51501_5_) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, p_i51501_1_, (Object)MemoryStatus.VALUE_PRESENT));
        this.memoryType = p_i51501_1_;
        this.speedModifier = p_i51501_2_;
        this.closeEnoughDist = p_i51501_3_;
        this.tooFarDistance = p_i51501_4_;
        this.tooLongUnreachableDuration = p_i51501_5_;
    }

    private void dropPOI(GatekeeperEntity p_225457_1_, long p_225457_2_) {
        Brain<GatekeeperEntity> brain = p_225457_1_.m_6274_();
        p_225457_1_.removePOI(this.memoryType);
        brain.m_21936_(this.memoryType);
        brain.m_21879_(MemoryModuleType.f_26326_, (Object)p_225457_2_);
    }

    protected void start(ServerLevel worldIn, GatekeeperEntity entity, long gameTimeIn) {
        Brain<GatekeeperEntity> brain = entity.m_6274_();
        brain.m_21952_(this.memoryType).ifPresent(memoryPos -> {
            if (this.tiredOfTryingToFindTarget(worldIn, entity)) {
                this.dropPOI(entity, gameTimeIn);
            } else if (this.wrongDimension(worldIn, entity, (GlobalPos)memoryPos)) {
                int i;
                Vec3 vec3d = null;
                for (i = 0; i < 1000 && (vec3d == null || this.wrongDimension(worldIn, entity, GlobalPos.m_122643_((ResourceKey)entity.f_19853_.m_46472_(), (BlockPos)new BlockPos(vec3d)))); ++i) {
                    vec3d = DefaultRandomPos.m_148412_((PathfinderMob)entity, (int)15, (int)7, (Vec3)Vec3.m_82539_((Vec3i)memoryPos.m_122646_()), (double)1.5707963705062866);
                }
                if (i == 1000) {
                    this.dropPOI(entity, gameTimeIn);
                    return;
                }
                brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(vec3d, this.speedModifier, this.closeEnoughDist));
            } else if (!this.closeEnough(worldIn, entity, (GlobalPos)memoryPos)) {
                brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(memoryPos.m_122646_(), this.speedModifier, this.closeEnoughDist));
            }
        });
    }

    private boolean tiredOfTryingToFindTarget(ServerLevel level, GatekeeperEntity entity) {
        Optional optional = entity.m_6274_().m_21952_(MemoryModuleType.f_26326_);
        if (optional.isPresent()) {
            return level.m_46467_() - (Long)optional.get() > (long)this.tooLongUnreachableDuration;
        }
        return false;
    }

    private boolean wrongDimension(ServerLevel level, GatekeeperEntity entity, GlobalPos memoryPos) {
        return memoryPos.m_122640_() != level.m_46472_() || memoryPos.m_122646_().m_123333_((Vec3i)entity.m_142538_()) > this.tooFarDistance;
    }

    private boolean closeEnough(ServerLevel level, GatekeeperEntity entity, GlobalPos memoryPos) {
        return memoryPos.m_122640_() == level.m_46472_() && memoryPos.m_122646_().m_123333_((Vec3i)entity.m_142538_()) <= this.closeEnoughDist;
    }
}

