/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeLilyPadBlock
extends BushBlock {
    public static final EnumProperty<Corner> CORNER = EnumProperty.m_61587_((String)"corner", Corner.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public LargeLilyPadBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(CORNER, (Comparable)((Object)Corner.BOTTOM_L)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean m_6266_(BlockState groundState, BlockGetter world, BlockPos groundPos) {
        return (groundState.m_60819_().m_76152_() == Fluids.f_76193_ || groundState.m_60767_() == Material.f_76276_) && world.m_6425_(groundPos.m_7494_()).m_76152_() == Fluids.f_76191_;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_60713_((Block)this) && super.m_7898_(state, world, pos)) {
            Corner corner = (Corner)((Object)state.m_61143_(CORNER));
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            switch (corner) {
                case BOTTOM_L: {
                    for (Corner c : new Corner[]{Corner.TOP_L, Corner.TOP_R, Corner.BOTTOM_R}) {
                        BlockPos offsetPos = c.getOffset(pos, facing);
                        BlockState offsetState = world.m_8055_(offsetPos);
                        if (offsetState.m_60734_() == this && super.m_7898_(offsetState, world, offsetPos)) continue;
                        return false;
                    }
                    return true;
                }
            }
            BlockPos offsetPos = switch (corner) {
                case Corner.BOTTOM_R -> pos.m_142300_(facing.m_122427_().m_122427_().m_122427_());
                case Corner.TOP_R -> pos.m_142300_(facing.m_122424_()).m_142300_(facing.m_122424_().m_122427_());
                case Corner.TOP_L -> pos.m_142300_(facing.m_122424_());
                default -> pos;
            };
            return this.m_7898_(world.m_8055_(offsetPos), world, offsetPos);
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        for (Corner corner : new Corner[]{Corner.TOP_L, Corner.TOP_R, Corner.BOTTOM_R}) {
            BlockPos offsetPos;
            Level world = context.m_43725_();
            if (world.m_8055_(offsetPos = corner.getOffset(context.m_8083_(), facing)).m_60629_(context) && this.m_6266_(world.m_8055_(offsetPos.m_7495_()), (BlockGetter)world, offsetPos.m_7495_())) continue;
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        for (Corner corner : new Corner[]{Corner.TOP_L, Corner.TOP_R, Corner.BOTTOM_R}) {
            world.m_7731_(corner.getOffset(pos, facing), (BlockState)state.m_61124_(CORNER, (Comparable)((Object)corner)), 27);
        }
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return this.m_6843_(state, rotation);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_(CORNER, (Comparable)((Object)((Corner)((Object)state.m_61143_(CORNER))).rotate(rotation)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.m_6843_(state, mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CORNER});
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public static enum Corner implements StringRepresentable
    {
        BOTTOM_L("bottom_left"),
        BOTTOM_R("bottom_right"),
        TOP_L("top_left"),
        TOP_R("top_right");

        private final String name;

        private Corner(String name) {
            this.name = name;
        }

        public BlockPos getOffset(BlockPos pos, Direction facing) {
            switch (this) {
                case BOTTOM_R: {
                    return pos.m_142300_(facing.m_122427_());
                }
                case TOP_L: {
                    return pos.m_142300_(facing);
                }
                case TOP_R: {
                    return pos.m_142300_(facing).m_142300_(facing.m_122427_());
                }
            }
            return pos;
        }

        public Corner rotate(Rotation rotation) {
            Corner corner = this;
            for (int i = 0; i < rotation.ordinal(); ++i) {
                corner = corner.rotate90();
            }
            return corner;
        }

        public Corner rotate90() {
            switch (this) {
                case BOTTOM_L: {
                    return BOTTOM_R;
                }
                case BOTTOM_R: {
                    return TOP_R;
                }
                case TOP_L: {
                    return BOTTOM_L;
                }
            }
            return TOP_L;
        }

        public Corner mirror(Mirror mirror, Direction stateFacing) {
            switch (this) {
                case BOTTOM_L: {
                    return BOTTOM_R;
                }
                case BOTTOM_R: {
                    return BOTTOM_L;
                }
                case TOP_L: {
                    return TOP_R;
                }
            }
            return TOP_L;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

