/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.misc;

import com.legacy.blue_skies.client.particle.StarFlareParticle;
import com.legacy.blue_skies.util.LogicUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StarFlareBlock
extends Block {
    private static final VoxelShape FLARE_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final IntegerProperty COLOR = IntegerProperty.m_61631_((String)"color", (int)0, (int)15);

    public StarFlareBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.0f).m_60918_(SoundType.f_56745_).m_60953_(value -> 15).m_60910_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FLARE_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (level.f_46443_) {
            this.m_7100_(state, level, pos, this.RANDOM);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DyeItem dye;
        int appliedColor;
        Item item;
        ItemStack heldItem = player.m_21120_(hand);
        if (player.m_36326_() && (item = heldItem.m_41720_()) instanceof DyeItem && (appliedColor = (dye = (DyeItem)item).m_41089_().m_41060_()) != (Integer)state.m_61143_((Property)COLOR)) {
            level.m_46597_(pos, (BlockState)this.m_49966_().m_61124_((Property)COLOR, (Comparable)Integer.valueOf(appliedColor)));
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItem.m_41720_()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        if (level.f_46443_) {
            DyeColor color = DyeColor.values()[(Integer)state.m_61143_((Property)COLOR)];
            for (int i = rand.nextInt(2) + 1; i > 0; --i) {
                double offset = 0.1;
                double x = LogicUtil.plusOrMinus((double)pos.m_123341_() + 0.5, offset, rand);
                double y = LogicUtil.plusOrMinus((double)pos.m_123342_() + 0.5, offset, rand);
                double z = LogicUtil.plusOrMinus((double)pos.m_123343_() + 0.5, offset, rand);
                double motion = 0.018;
                double dx = LogicUtil.plusOrMinus(motion, rand);
                double dy = LogicUtil.plusOrMinus(motion, rand);
                double dz = LogicUtil.plusOrMinus(motion, rand);
                level.m_7106_((ParticleOptions)StarFlareParticle.dyeToRGB(color), x, y, z, dx, dy, dz);
            }
            level.m_7106_((ParticleOptions)StarFlareParticle.dyeToRGB(color), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLOR});
    }
}

