/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.dungeon;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.block_entity.KeystoneBlockEntity;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.DisplayToastPacket;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStats;
import com.legacy.blue_skies.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class KeystoneBlock
extends BaseEntityBlock {
    public KeystoneBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50752_).m_60993_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ServerPlayer serverPlayer;
        player.m_36220_(SkiesStats.INTERACT_WITH_KEYSTONE);
        if (player instanceof ServerPlayer) {
            int start = 15;
            serverPlayer = (ServerPlayer)player;
            if (!(state.m_60734_() != SkiesBlocks.bright_blinding_keystone && state.m_60734_() != SkiesBlocks.dawn_blinding_keystone || EntityUtil.hasAdvancement(serverPlayer, BlueSkies.locate("progression/unlock_everbright_blinding_key_trade")) || EntityUtil.hasAdvancement(serverPlayer, BlueSkies.locate("progression/unlock_everdawn_blinding_key_trade")))) {
                PacketHandler.sendToClient(new DisplayToastPacket((byte)start), serverPlayer);
            }
            if (state.m_60734_() == SkiesBlocks.nature_keystone && !EntityUtil.hasAdvancement(serverPlayer, BlueSkies.locate("progression/unlock_nature_key_trade"))) {
                PacketHandler.sendToClient(new DisplayToastPacket((byte)(start + 1)), serverPlayer);
            }
            if (state.m_60734_() == SkiesBlocks.poison_keystone && !EntityUtil.hasAdvancement(serverPlayer, BlueSkies.locate("progression/unlock_poison_key_trade"))) {
                PacketHandler.sendToClient(new DisplayToastPacket((byte)(start + 2)), serverPlayer);
            }
        }
        if (worldIn.m_46791_().m_19028_() <= Difficulty.PEACEFUL.m_19028_()) {
            return KeystoneBlock.playLockedWithMessage(player, pos, "tile.keystone.peaceful_difficulty");
        }
        if (player.m_36326_()) {
            serverPlayer = worldIn.m_7702_(pos);
            if (serverPlayer instanceof KeystoneBlockEntity) {
                KeystoneBlockEntity tile = (KeystoneBlockEntity)serverPlayer;
                ItemStack heldItem = player.m_21120_(handIn);
                if (player.m_7500_() && heldItem.m_41720_() instanceof SpawnEggItem) {
                    EntityType entityType = ((SpawnEggItem)heldItem.m_41720_()).m_43228_(heldItem.m_41783_());
                    tile.setContainedMob(entityType);
                    return InteractionResult.SUCCESS;
                }
                if ((tile.isCorrectKey(heldItem) || tile.isCorrectArc(heldItem.m_41720_())) && SkiesPlayerEvents.inBossFight(player)) {
                    return KeystoneBlock.playLockedWithMessage(player, pos, "tile.keystone.respawning_in_fight");
                }
                if (tile.getSpawnsBoss() && tile.isCorrectArc(heldItem.m_41720_()) && player.m_36335_().m_41519_(heldItem.m_41720_())) {
                    return KeystoneBlock.playLockedWithMessage(player, pos, "tile.keystone.arc_on_cooldown");
                }
                if (tile.getSpawnsBoss() && (tile.isCorrectKey(heldItem) || tile.isCorrectArc(heldItem.m_41720_())) && this.spawnBoss(tile, state, worldIn, pos, player, heldItem)) {
                    return InteractionResult.SUCCESS;
                }
                if (!(tile.getSpawnsBoss() && tile.getKeysRequired() || !this.teleportPlayer(tile, state, worldIn, pos, player, hit.m_82434_()))) {
                    return InteractionResult.SUCCESS;
                }
                if (tile.getKeysRequired()) {
                    return KeystoneBlock.playLockedWithMessage(player, pos, "tile.keystone.requires_keys");
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public boolean spawnBoss(KeystoneBlockEntity tile, BlockState state, Level worldIn, BlockPos pos, Player player, ItemStack heldItem) {
        if (!(worldIn.f_46443_ || player.m_7500_() || EntityUtil.hasPlayerProgressedTo(player, tile.isEverbrightBased(), tile.getRequiredProgressionId()))) {
            return false;
        }
        tile.spawnMob(tile.isCorrectArc(heldItem.m_41720_()));
        tile.teleportClosePlayers(worldIn);
        tile.setKeysRequired(false);
        if (tile.isCorrectKey(heldItem)) {
            if (!player.m_7500_() && !worldIn.f_46443_) {
                heldItem.m_41774_(4);
            }
            if (worldIn.f_46443_) {
                player.m_5661_((Component)new TranslatableComponent("tile.keystone.remove_key_requirement"), true);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItem.m_41720_()));
        } else if (tile.isCorrectArc(heldItem.m_41720_())) {
            if (!player.m_7500_()) {
                player.m_36335_().m_41524_(heldItem.m_41720_(), 3600);
            }
            if (worldIn.f_46443_) {
                player.m_5661_((Component)new TranslatableComponent("tile.keystone.arc_drained", new Object[]{heldItem.m_41720_().m_41466_()}), true);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItem.m_41720_()));
        }
        if (worldIn.f_46443_) {
            worldIn.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SkiesSounds.BLOCK_KEYSTONE_UNLOCK, SoundSource.BLOCKS, 1.0f, EntityUtil.getSoundPitchWithStart(worldIn.f_46441_, 1.0f), false);
            worldIn.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SkiesSounds.BLOCK_KEYSTONE_TELEPORT, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }
        return true;
    }

    public boolean teleportPlayer(KeystoneBlockEntity tile, BlockState state, Level worldIn, BlockPos pos, Player player, Direction clickDirection) {
        if (!player.m_7500_() && !EntityUtil.hasPlayerProgressedTo(player, tile.isEverbrightBased(), tile.getRequiredProgressionId())) {
            return false;
        }
        tile.teleportPlayer(player);
        return true;
    }

    public static InteractionResult playLockedWithMessage(Player player, BlockPos pos, String message) {
        player.f_19853_.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_LOCKED, SoundSource.BLOCKS, 1.0f, EntityUtil.getSoundPitchWithStart(player.f_19853_.f_46441_, 1.0f));
        player.m_5661_((Component)new TranslatableComponent(message), true);
        return InteractionResult.SUCCESS;
    }

    public static abstract class DirectionalKeystoneBlock
    extends KeystoneBlock {
        public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.f_54117_;

        public DirectionalKeystoneBlock() {
            this.m_49959_((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.NORTH));
        }

        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_().m_122424_());
        }

        public BlockState m_6843_(BlockState state, Rotation rotation) {
            return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
        }

        public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
            return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_(FACING)));
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{FACING});
        }
    }
}

