/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.asm_hooks;

import com.legacy.blue_skies.blocks.misc.SkyWebbingBlock;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.data.objects.tags.SkiesEntityTags;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;

public class PlayerHooks {
    private static final Set<Item> NERFED_ITEMS_CACHE = new HashSet<Item>();
    private static final String[] NERFABLE_ITEM_NAMES = new String[]{"axe", "pickaxe", "shovel", "hoe", "hammer", "mattock", "pickadze", "excavator", "kama", "scythe", "sword", "dagger", "cleaver", "rapier", "saber", "scabbard", "scimitar", "shortsword", "greatsword", "katana", "spear"};

    public static boolean cannotDismount(Player player) {
        return player.m_20159_() && player.m_20201_().m_6095_().m_204039_(SkiesEntityTags.BOSSES);
    }

    public static float modifyBreakSpeed(float speed, BlockState state, @Nullable BlockPos pos, Player player) {
        Block block = state.m_60734_();
        Item item = player.m_21205_().m_41720_();
        if (item != null && pos != null) {
            if (PlayerHooks.webHarvestCheck(block, item)) {
                return 15.0f;
            }
            if (SkiesDimensions.inSkyDimension((Entity)player) && PlayerHooks.isNerfableTool(player.m_21205_(), state)) {
                return SkiesPlayer.getIfPresent(player, skyPlayer -> {
                    if (!EntityUtil.hasPlayerCompletedProgression(skyPlayer)) {
                        player.m_5661_((Component)new TranslatableComponent("gui.blue_skies.tooltip.invalid_tool"), true);
                        return Float.valueOf(0.999f);
                    }
                    return Float.valueOf(speed);
                }, () -> Float.valueOf(speed)).floatValue();
            }
        }
        return speed;
    }

    public static synchronized boolean isNerfableTool(@Nullable ItemStack stack, @Nullable BlockState state) {
        Item item;
        ResourceLocation registryName;
        if (stack == null) {
            return false;
        }
        if (NERFED_ITEMS_CACHE.size() > 100) {
            NERFED_ITEMS_CACHE.clear();
        }
        if ((registryName = (item = stack.m_41720_()).getRegistryName()) != null && "blue_skies".equals(registryName.m_135827_())) {
            return false;
        }
        if (registryName == null) {
            return true;
        }
        if (!NERFED_ITEMS_CACHE.contains(item)) {
            PlayerHooks.tryAddToNerfedCache(item, registryName);
        }
        if (NERFED_ITEMS_CACHE.contains(item)) {
            return state == null || stack.m_41735_(state);
        }
        return false;
    }

    private static void tryAddToNerfedCache(Item item, ResourceLocation registryName) {
        if (item instanceof TieredItem) {
            TieredItem tiered = (TieredItem)item;
            Tier tier = tiered.m_43314_();
            if (tier == Tiers.WOOD || tier == Tiers.STONE || tier == Tiers.GOLD) {
                return;
            }
            NERFED_ITEMS_CACHE.add(item);
            return;
        }
        String name = registryName.m_135815_();
        for (String nerfedName : NERFABLE_ITEM_NAMES) {
            if (!name.equals(nerfedName) && !name.endsWith(nerfedName)) continue;
            NERFED_ITEMS_CACHE.add(item);
            return;
        }
    }

    public static boolean isBreakingNerfed(Item item, Player player, BlockState state) {
        return item != null && SkiesDimensions.inSkyDimension((Entity)player) && PlayerHooks.isNerfableTool(player.m_21205_(), state) && !TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.WOOD, (BlockState)state);
    }

    public static boolean webHarvestCheck(Block block, Item item) {
        return block instanceof WebBlock && item == SkiesItems.ventium_shears || block instanceof SkyWebbingBlock && item.m_8096_(Blocks.f_50033_.m_49966_());
    }
}

