/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.util;

import java.util.function.Supplier;
import net.minecraftforge.common.util.Lazy;

public class LazyOptional<T>
implements Lazy<T> {
    private final Lazy<T> lazy;
    private boolean isPresent = false;

    public static <T> LazyOptional<T> of(Supplier<T> supplier) {
        return new LazyOptional<T>(supplier);
    }

    private LazyOptional(Supplier<T> supplier) {
        this.lazy = Lazy.of(supplier);
    }

    public T get() {
        if (!this.isPresent) {
            this.isPresent = true;
        }
        return (T)this.lazy.get();
    }

    public T orElseGet(Supplier<T> orElse) {
        return (T)(this.isPresent ? this.lazy.get() : orElse.get());
    }

    public boolean isPresent() {
        return this.isPresent;
    }
}

