/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import quek.undergarden.entity.UGBoat;

public class UGBoatRenderer
extends EntityRenderer<UGBoat> {
    private final Map<UGBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public UGBoatRenderer(EntityRendererProvider.Context renderContext) {
        super(renderContext);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(UGBoat.Type.values()).collect(ImmutableMap.toImmutableMap(boatType -> boatType, boatType -> Pair.of((Object)new ResourceLocation("undergarden", "textures/entity/boat/" + boatType.getName() + ".png"), (Object)new BoatModel(renderContext.m_174023_(UGBoatRenderer.boatLayer(boatType))))));
    }

    public static ModelLayerLocation boatLayer(UGBoat.Type boatType) {
        return new ModelLayerLocation(new ResourceLocation("undergarden", "boat/" + boatType.getName()), "main");
    }

    public void render(UGBoat pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float bubbleAngle;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, 0.375, 0.0);
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - pEntityYaw));
        float f = (float)pEntity.m_38385_() - pPartialTicks;
        float f1 = pEntity.m_38384_() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)pEntity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(bubbleAngle = pEntity.m_38352_(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), pEntity.m_38352_(pPartialTicks), true));
        }
        Pair<ResourceLocation, BoatModel> pair = this.boatResources.get((Object)pEntity.getUGBoatType());
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel boatmodel = (BoatModel)pair.getSecond();
        pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boatmodel.m_6973_((Boat)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(boatmodel.m_103119_(resourcelocation));
        boatmodel.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!pEntity.m_5842_()) {
            VertexConsumer vertexconsumer1 = pBuffer.m_6299_(RenderType.m_110478_());
            boatmodel.m_102282_().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(UGBoat boat) {
        return (ResourceLocation)this.boatResources.get((Object)boat.getUGBoatType()).getFirst();
    }
}

