/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import quek.undergarden.block.UGBushBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class BlisterberryBushBlock
extends UGBushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;

    public BlisterberryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60713_((Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get());
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)UGItems.BLISTERBERRY.get());
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        super.m_7458_(state, worldIn, pos, rand);
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.m_6095_() != UGEntityTypes.SCINTLING.get()) {
            entityIn.m_7601_(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(worldIn.f_46443_ || (Integer)state.m_61143_((Property)AGE) <= 0 || entityIn.f_19790_ == entityIn.m_20185_() && entityIn.f_19792_ == entityIn.m_20189_())) {
                double d0 = Math.abs(entityIn.m_20185_() - entityIn.f_19790_);
                double d1 = Math.abs(entityIn.m_20189_() - entityIn.f_19792_);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    entityIn.m_6469_(UGDamageSources.BLISTERBERRY_BUSH, 2.0f);
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean flag;
        int age = (Integer)state.m_61143_((Property)AGE);
        boolean bl = flag = age == 3;
        if (!flag && player.m_21120_(handIn).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (age > 1) {
            int random = 1 + worldIn.f_46441_.nextInt(2);
            int random2 = worldIn.f_46441_.nextInt(2);
            BlisterberryBushBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)UGItems.BLISTERBERRY.get(), random + (flag ? 1 : 0)));
            BlisterberryBushBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get(), random2 + (flag ? 1 : 0)));
            worldIn.m_5594_(null, pos, (SoundEvent)UGSoundEvents.PICK_BLISTERBERRY_BUSH.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.nextFloat() * 0.4f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1);
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

