/*
 * Decompiled with CFR 0.152.
 */
package net.ggwpgaming.dangerclose.util;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import net.ggwpgaming.dangerclose.DangerClose;
import net.ggwpgaming.dangerclose.util.ConfigNode;
import org.slf4j.Logger;

public class DCIO {
    public static final String DCConfigFilename = "config/dangerclose.properties";
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void main(String[] args) {
        LOGGER.debug("You ran AMIO as a standalone program!");
    }

    public static void writeLinkedListToFile(LinkedList<ConfigNode> linkedList, String fileName) {
        try {
            File file;
            File directory = new File("config");
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!(file = new File(fileName)).exists()) {
                file.createNewFile();
            }
            try (FileWriter writer = new FileWriter(file);){
                for (ConfigNode node : linkedList) {
                    writer.write(node.CONFIG_NAME + "=" + node.value + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LinkedList<ConfigNode> readLinkedListFromFile(String fileName) {
        LinkedList<ConfigNode> linkedList = new LinkedList<ConfigNode>();
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] parts = line.split("\\=", 2);
                System.out.println(Arrays.stream(parts).toList().toString());
                if (parts.length >= 2) {
                    String name = parts[0];
                    System.out.println(name);
                    Boolean value = Boolean.valueOf(parts[1]);
                    System.out.println(value.toString());
                    linkedList.add(new ConfigNode(name, value));
                    continue;
                }
                DangerClose.LOGGER.info("Invalid line format: " + line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return linkedList;
    }
}

