/*
 * Decompiled with CFR 0.152.
 */
package net.ggwpgaming.dangerclose;

import java.io.File;
import java.util.LinkedList;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.ggwpgaming.dangerclose.event.DangerDetector;
import net.ggwpgaming.dangerclose.util.ConfigNode;
import net.ggwpgaming.dangerclose.util.DCIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DangerClose
implements ModInitializer {
    public static final String MOD_ID = "dangerclose";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dangerclose");
    public static Boolean TORCHES_BURN;
    public static Boolean CAMPFIRES_BURN;
    public static Boolean STONECUTTERS_CUT;
    public static Boolean ENABLE_BLAZE_DAMAGE;
    public static Boolean ENABLE_MAGMA_CUBE_DAMAGE;
    public static Boolean ENABLE_MAGMA_BLOCK_DAMAGE;

    public DangerClose() {
        if (new File("config/dangerclose.properties").isFile() && !new File("config/dangerclose.properties").isDirectory()) {
            LOGGER.info("Config file was found. Attempting to read...");
            LinkedList<ConfigNode> retrievedList = DCIO.readLinkedListFromFile("config/dangerclose.properties");
            for (ConfigNode node : retrievedList) {
                if (node.CONFIG_NAME.contains("TORCHES_BURN")) {
                    TORCHES_BURN = node.value;
                    LOGGER.info("We found " + node.CONFIG_NAME + " with value: " + node.value.toString());
                }
                if (node.CONFIG_NAME.contains("CAMPFIRES_BURN")) {
                    CAMPFIRES_BURN = node.value;
                    LOGGER.info("We found " + node.CONFIG_NAME + " with value: " + node.value.toString());
                }
                if (node.CONFIG_NAME.contains("STONECUTTERS_CUT")) {
                    STONECUTTERS_CUT = node.value;
                    LOGGER.info("We found " + node.CONFIG_NAME + " with value: " + node.value.toString());
                }
                if (node.CONFIG_NAME.contains("ENABLE_BLAZE_DAMAGE")) {
                    ENABLE_BLAZE_DAMAGE = node.value;
                    LOGGER.info("We found " + node.CONFIG_NAME + " with value: " + node.value.toString());
                }
                if (node.CONFIG_NAME.contains("ENABLE_MAGMA_CUBE_DAMAGE")) {
                    ENABLE_MAGMA_CUBE_DAMAGE = node.value;
                    LOGGER.info("We found " + node.CONFIG_NAME + " with value: " + node.value.toString());
                }
                if (!node.CONFIG_NAME.contains("ENABLE_MAGMA_BLOCK_DAMAGE")) continue;
                ENABLE_MAGMA_BLOCK_DAMAGE = node.value;
                LOGGER.info("We found " + node.CONFIG_NAME + " with value: " + node.value.toString());
            }
            LOGGER.info("Config loaded from file: config/dangerclose.properties");
        } else if (!new File("config/dangerclose.properties").isFile() && !new File("config/dangerclose.properties").isDirectory()) {
            LOGGER.info("Config not found. Initializing file, please restart your game to edit.");
            LinkedList<ConfigNode> configList = new LinkedList<ConfigNode>();
            configList.add(new ConfigNode("TORCHES_BURN", false));
            configList.add(new ConfigNode("CAMPFIRES_BURN", true));
            configList.add(new ConfigNode("STONECUTTERS_CUT", true));
            configList.add(new ConfigNode("ENABLE_BLAZE_DAMAGE", true));
            configList.add(new ConfigNode("ENABLE_MAGMA_CUBE_DAMAGE", true));
            configList.add(new ConfigNode("ENABLE_MAGMA_BLOCK_DAMAGE", false));
            DCIO.writeLinkedListToFile(configList, "config/dangerclose.properties");
            TORCHES_BURN = false;
            CAMPFIRES_BURN = true;
            STONECUTTERS_CUT = true;
            ENABLE_BLAZE_DAMAGE = true;
            ENABLE_MAGMA_CUBE_DAMAGE = true;
            ENABLE_MAGMA_BLOCK_DAMAGE = false;
        } else {
            LOGGER.info("config/dangerclose.properties was found as a directory. Please delete it...");
        }
    }

    public void onInitialize() {
        LOGGER.info("dangerclose initialized!");
        ServerTickEvents.START_SERVER_TICK.register((Object)new DangerDetector());
    }
}

