/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.mc.ColorUtils;

@Environment(value=EnvType.CLIENT)
public class GuiRenderHelper {
    private static final class_310 mc = class_310.method_1551();

    public static class_327 getFont() {
        return GuiRenderHelper.mc.field_1772;
    }

    public static void drawItemStack(class_4587 mat, class_1799 stack, float alpha) {
        boolean flag;
        class_918 renderer = mc.method_1480();
        mc.method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        class_4587 matrix = RenderSystem.getModelViewStack();
        matrix.method_22903();
        matrix.method_34425(mat.method_23760().method_23761());
        matrix.method_46416(0.0f, 0.0f, 100.0f);
        matrix.method_46416(8.0f, 8.0f, 8.0f);
        matrix.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrix.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 multibuffersource$buffersource = class_310.method_1551().method_22940().method_23000();
        class_1087 bakedmodel = renderer.method_4019(stack, (class_1937)null, (class_1309)null, 0);
        boolean bl = flag = !bakedmodel.method_24304();
        if (flag) {
            class_308.method_24210();
        }
        renderer.method_23179(stack, class_811.field_4317, false, new class_4587(), (class_4597)multibuffersource$buffersource, 0xF000F0, class_4608.field_21444, bakedmodel);
        multibuffersource$buffersource.method_22993();
        RenderSystem.enableDepthTest();
        if (flag) {
            class_308.method_24211();
        }
        matrix.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public static void drawItemStackDecorations(class_4587 posestack, class_1799 stack) {
        GuiRenderHelper.drawItemStackDecorations(posestack, stack, stack.method_7947());
    }

    public static void drawItemStackDecorations(class_4587 posestack, class_1799 stack, int count) {
        if (!stack.method_7960()) {
            class_746 localplayer;
            float f;
            int x = 0;
            int y = 0;
            if ((long)count != 1L) {
                String s = String.valueOf(count);
                posestack.method_22904(0.0, 0.0, 200.0);
                class_4597.class_4598 multibuffersource$buffersource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                GuiRenderHelper.mc.field_1772.method_27521(s, (float)(x + 19 - 2 - GuiRenderHelper.mc.field_1772.method_1727(s)), (float)(y + 6 + 3), 0xFFFFFF, true, posestack.method_23760().method_23761(), (class_4597)multibuffersource$buffersource, class_327.class_6415.field_33993, 0, 0xF000F0);
                multibuffersource$buffersource.method_22993();
            }
            if (stack.method_31578()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                class_289 tesselator = class_289.method_1348();
                class_287 bufferbuilder = tesselator.method_1349();
                int i = stack.method_31579();
                int j = stack.method_31580();
                GuiRenderHelper.colorRect(posestack, bufferbuilder, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                GuiRenderHelper.colorRect(posestack, bufferbuilder, x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
            float f2 = f = (localplayer = class_310.method_1551().field_1724) == null ? 0.0f : localplayer.method_7357().method_7905(stack.method_7909(), class_310.method_1551().method_1488());
            if (f > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                class_289 tesselator1 = class_289.method_1348();
                class_287 bufferbuilder1 = tesselator1.method_1349();
                GuiRenderHelper.colorRect(posestack, bufferbuilder1, x, y + class_3532.method_15375((float)(16.0f * (1.0f - f))), 16, class_3532.method_15386((float)(16.0f * f)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    public static void drawStringCentered(class_4587 stack, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.field_1772.method_1727((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.field_1772.method_1727("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = GuiRenderHelper.mc.field_1772.method_1727("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = builder.toString() + "...";
        }
        class_4597.class_4598 buffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        class_327 class_3272 = GuiRenderHelper.mc.field_1772;
        float f = width / 2.0f - (float)(GuiRenderHelper.mc.field_1772.method_1727((String)text) / 2);
        float f2 = height / 2.0f;
        Objects.requireNonNull(GuiRenderHelper.mc.field_1772);
        class_3272.method_27521((String)text, f, f2 - (float)(9 / 2), -1, shadow, stack.method_23760().method_23761(), (class_4597)buffer, class_327.class_6415.field_33993, 0, 0xF000F0);
        buffer.method_22993();
    }

    public static void horizontalGradientRect(class_4587 pose, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        GuiRenderHelper.horizontalGradientRect(pose.method_23760().method_23761(), bufferbuilder, x, y, x2, y2, 0, colorFrom, colorTo);
        tesselator.method_1350();
    }

    public static void horizontalGradientRect(Matrix4f matrix, class_287 builder, int x, int y, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.method_22918(matrix, (float)x2, (float)y, (float)z).method_22915(f5, f6, f7, f4).method_1344();
        builder.method_22918(matrix, (float)x, (float)y, (float)z).method_22915(f1, f2, f3, f).method_1344();
        builder.method_22918(matrix, (float)x, (float)y2, (float)z).method_22915(f1, f2, f3, f).method_1344();
        builder.method_22918(matrix, (float)x2, (float)y2, (float)z).method_22915(f5, f6, f7, f4).method_1344();
    }

    public static void verticalGradientRect(class_4587 pose, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        GuiRenderHelper.verticalGradientRect(pose.method_23760().method_23761(), bufferbuilder, x, y, x2, y2, 0, colorFrom, colorTo);
        tesselator.method_1350();
    }

    public static void verticalGradientRect(Matrix4f matrix, class_287 builder, int x, int y, int x2, int y2, int z, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.method_22918(matrix, (float)x2, (float)y, (float)z).method_22915(f1, f2, f3, f).method_1344();
        builder.method_22918(matrix, (float)x, (float)y, (float)z).method_22915(f1, f2, f3, f).method_1344();
        builder.method_22918(matrix, (float)x, (float)y2, (float)z).method_22915(f5, f6, f7, f4).method_1344();
        builder.method_22918(matrix, (float)x2, (float)y2, (float)z).method_22915(f5, f6, f7, f4).method_1344();
    }

    public static void horizontalGradientMaskRect(class_4587 pose, int x, int y, int x2, int y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(pose, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void colorRect(class_4587 pose, int x, int y, int width, int height, int color) {
        GuiRenderHelper.colorRect(pose, class_289.method_1348().method_1349(), x, y, x + width, y + height, ColorUtils.red(color), ColorUtils.green(color), ColorUtils.blue(color), ColorUtils.alpha(color));
    }

    public static void colorRect(class_4587 pose, class_287 builder, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        Matrix4f mat = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34540);
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22918(mat, (float)x, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        builder.method_22918(mat, (float)x, (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        builder.method_22918(mat, (float)(x + width), (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        builder.method_22918(mat, (float)(x + width), (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }

    private static void textureRect(class_4587 pose, int x, int y, int z, int width, int height, float u, float v, int textureWidth, int textureHeight) {
        GuiRenderHelper.textureRect(pose, x, x + width, y, y + height, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void textureRect(class_4587 pose, int x, int y, int width, int height, float u, float v) {
        GuiRenderHelper.textureRect(pose, x, y, 0, width, height, u, v, 256, 256);
    }

    public static void textureRect(class_4587 pose, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        GuiRenderHelper.textureRect(pose, x, x + width, y, y + height, 0, u, v, u2, v2, 256, 256);
    }

    private static void textureRect(class_4587 pose, int x, int x2, int y, int y2, int z, float u, float v, float u2, float v2, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(pose.method_23760().method_23761(), x, x2, y, y2, z, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    private static void textureRect(class_4587 pose, int x, int x2, int y, int y2, int z, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        GuiRenderHelper.drawTextureRect(pose.method_23760().method_23761(), x, x2, y, y2, z, u / (float)textureWidth, (u + (float)uWidth) / (float)textureWidth, v / (float)textureHeight, (v + (float)vHeight) / (float)textureHeight);
    }

    private static void drawTextureRect(Matrix4f matrix, int x, int x2, int y, int y2, int z, float u, float u2, float v, float v2) {
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(matrix, (float)x, (float)y2, (float)z).method_22913(u, v2).method_1344();
        bufferbuilder.method_22918(matrix, (float)x2, (float)y2, (float)z).method_22913(u2, v2).method_1344();
        bufferbuilder.method_22918(matrix, (float)x2, (float)y, (float)z).method_22913(u2, v).method_1344();
        bufferbuilder.method_22918(matrix, (float)x, (float)y, (float)z).method_22913(u, v).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
    }
}

