/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.loadingbackgrounds;

import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3304;
import net.minecraft.class_332;
import net.minecraft.class_3902;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class LoadingBackgrounds
implements ClientModInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"loadingbackgrounds");
    private static LoadingBackgrounds INSTANCE;
    private Config config = Config.DEFAULT;
    private Iterator<class_2960> textures;
    private class_2960 texturePrevious;
    private class_2960 textureCurrent;
    private double stateSecondsStarted = LoadingBackgrounds.seconds();
    private boolean stateIsFading = false;
    private static final long secondsStart;
    private static final Pattern PROFILE_NAME_PATTERN;

    public static LoadingBackgrounds getInstance() {
        return INSTANCE;
    }

    public LoadingBackgrounds() {
        INSTANCE = this;
    }

    public Position getPosition() {
        return this.config.position();
    }

    public void onInitializeClient() {
        LOGGER.info("Setting up loadingbackgrounds...");
        this.config = Config.read();
    }

    public void draw(class_332 context, class_437 screen) {
        double secondsNow = LoadingBackgrounds.seconds();
        double secondsDiff = secondsNow - this.stateSecondsStarted;
        if (secondsDiff > Math.max(this.config.secondsStay(), this.config.secondsFade()) + 5.0 || this.textures == null) {
            secondsDiff = 0.0;
            this.stateSecondsStarted = secondsNow;
            this.stateIsFading = false;
            this.textures = LoadingBackgrounds.getBackgroundTextures();
            if (this.textures == null) {
                return;
            }
            this.texturePrevious = this.textures.next();
            this.textureCurrent = this.textures.next();
        }
        if (this.stateIsFading) {
            LoadingBackgrounds.drawBackgroundTexture(context, screen, this.texturePrevious, this.config.brightness(), 1.0f);
            LoadingBackgrounds.drawBackgroundTexture(context, screen, this.textureCurrent, this.config.brightness(), (float)Math.min(secondsDiff / this.config.secondsFade(), 1.0));
            if (secondsDiff > this.config.secondsFade()) {
                this.stateSecondsStarted = secondsNow;
                this.stateIsFading = false;
            }
        } else {
            LoadingBackgrounds.drawBackgroundTexture(context, screen, this.textureCurrent, this.config.brightness(), 1.0f);
            if (secondsDiff > this.config.secondsStay()) {
                this.stateSecondsStarted = secondsNow;
                this.stateIsFading = true;
                this.texturePrevious = this.textureCurrent;
                this.textureCurrent = this.textures.next();
            }
        }
    }

    private static double seconds() {
        return (double)(System.nanoTime() - secondsStart) * 1.0E-9;
    }

    private static class_310 getClient() {
        return class_310.method_1551();
    }

    private static class_3300 getResourceManager() {
        return LoadingBackgrounds.getClient().method_1478();
    }

    private static class_3283 getResourcePackManager() {
        return LoadingBackgrounds.getClient().method_1520();
    }

    private static class_1060 getTextureManager() {
        return LoadingBackgrounds.getClient().method_1531();
    }

    private static void reloadResourcePacks() {
        class_3304 resourceManager = (class_3304)LoadingBackgrounds.getResourceManager();
        class_3283 resourcePackManager = LoadingBackgrounds.getResourcePackManager();
        Collection profiles = resourcePackManager.method_14441();
        Collection profilesEnabled = resourcePackManager.method_14444();
        boolean reload = false;
        for (class_3288 profile : profiles) {
            if (profilesEnabled.contains(profile) || !PROFILE_NAME_PATTERN.matcher(profile.method_14463()).find()) continue;
            LOGGER.info("Enabling resource pack " + profile.method_14463());
            resourcePackManager.method_49427(profile.method_14463());
            reload = true;
        }
        if (reload) {
            resourceManager.method_18232((Executor)LoadingBackgrounds.getClient(), (Executor)LoadingBackgrounds.getClient(), CompletableFuture.completedFuture(class_3902.field_17274), resourcePackManager.method_29211());
        }
    }

    private static Map<class_2960, class_3298> getBackgroundTextureResources() {
        return LoadingBackgrounds.getResourceManager().method_14488("textures/gui/backgrounds", filename -> filename.method_12832().endsWith(".png"));
    }

    private static Iterator<class_2960> getBackgroundTextures() {
        Map<class_2960, class_3298> resources = LoadingBackgrounds.getBackgroundTextureResources();
        if (resources.isEmpty()) {
            LoadingBackgrounds.reloadResourcePacks();
            resources = LoadingBackgrounds.getBackgroundTextureResources();
            if (resources.isEmpty()) {
                return null;
            }
        }
        List<Object> textures = Arrays.asList(resources.keySet().toArray());
        Collections.shuffle(textures);
        return Iterators.cycle(textures);
    }

    private static void drawBackgroundTexture(class_332 context, class_437 screen, class_2960 texture, float brightness, float opacity) {
        TextureInfo textureInfo = (TextureInfo)LoadingBackgrounds.getTextureManager().method_4619(texture);
        textureInfo.loadingbackgrounds$init();
        float textureWidth = textureInfo.loadingbackgrounds$getWidth();
        float textureHeight = textureInfo.loadingbackgrounds$getHeight();
        float screenWidth = screen.field_22789;
        float screenHeight = screen.field_22790;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        scaleX = screenWidth / textureWidth;
        scaleY = screenHeight / textureHeight;
        if (scaleX < scaleY) {
            scaleX = scaleY;
            offsetX = 0.0f - (screenWidth - textureWidth * scaleX) * 0.5f;
        } else {
            scaleY = scaleX;
            offsetY = 0.0f - (screenHeight - textureHeight * scaleY) * 0.5f;
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        context.method_51422(brightness, brightness, brightness, opacity);
        context.method_25291(texture, 0, 0, 0, offsetX, offsetY, (int)screenWidth, (int)screenHeight, (int)(textureWidth * scaleX), (int)(textureHeight * scaleY));
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    static {
        secondsStart = System.nanoTime();
        PROFILE_NAME_PATTERN = Pattern.compile("load(ing)?\\W?(background|image)", 2);
    }

    public record Config(double secondsStay, double secondsFade, float brightness, Position position) {
        private static final Config DEFAULT = new Config(3.0, 0.75, 0.66f, Position.BOTTOM_RIGHT);
        private static final String DEFAULT_JSON = "{\n  // Amount of time that each background is displayed for\n  \"secondsStay\": 5.0,\n  // Amount of time it takes to fade between backgrounds\n  \"secondsFade\": 0.5,\n  // Background brightness, between 0.0 and 1.0\n  \"brightness\": 1.0,\n  // Level loading indicator position\n  // One of \"CENTER\", \"BOTTOM_LEFT\", \"BOTTOM_RIGHT\", \"TOP_LEFT\", or \"TOP_RIGHT\"\n  \"position\": \"BOTTOM_RIGHT\"\n}\n";
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().setLenient().create();

        @NotNull
        public static Config read() {
            Path pathDirectory = FabricLoaderImpl.INSTANCE.getConfigDir();
            Path pathFile = pathDirectory.resolve("loadingbackgrounds-config.json");
            Path pathTemp = pathDirectory.resolve("loadingbackgrounds-config.json.tmp");
            try {
                return (Config)GSON.fromJson((Reader)Files.newBufferedReader(pathFile), Config.class);
            }
            catch (NoSuchFileException cause) {
                LOGGER.error("Failed to read config, file not found");
            }
            catch (IOException cause) {
                LOGGER.error("Failed to read config, IO error", (Throwable)cause);
            }
            catch (JsonParseException cause) {
                LOGGER.error("Failed to read config, JSON error", (Throwable)cause);
            }
            catch (Exception cause) {
                LOGGER.error("Failed to read config", (Throwable)cause);
            }
            try {
                Files.writeString(pathTemp, (CharSequence)DEFAULT_JSON, new OpenOption[0]);
                Files.move(pathTemp, pathFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException cause) {
                LOGGER.error("Failed to write new config, IO error", (Throwable)cause);
            }
            catch (Exception cause) {
                LOGGER.error("Failed to write new config", (Throwable)cause);
            }
            return DEFAULT;
        }
    }

    public static enum Position {
        CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static interface TextureInfo {
        public void loadingbackgrounds$init();

        public int loadingbackgrounds$getWidth();

        public int loadingbackgrounds$getHeight();
    }
}

