/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.packedup.BackpackContainer;
import com.supermartijn642.packedup.BackpackInventory;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackRecipeCondition;
import com.supermartijn642.packedup.BackpackStorageManager;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.BackpackUpgradeRecipe;
import com.supermartijn642.packedup.generators.PackedUpAdvancementGenerator;
import com.supermartijn642.packedup.generators.PackedUpLanguageGenerator;
import com.supermartijn642.packedup.generators.PackedUpModelGenerator;
import com.supermartijn642.packedup.generators.PackedUpRecipeGenerator;
import com.supermartijn642.packedup.generators.PackedUpTagGenerator;
import com.supermartijn642.packedup.packets.PacketOpenBag;
import com.supermartijn642.packedup.packets.PacketRename;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class PackedUp
implements ModInitializer {
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"packedup");
    @RegistryEntryAcceptor(namespace="packedup", identifier="container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<BackpackContainer> container;
    @RegistryEntryAcceptor(namespace="packedup", identifier="basicbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem basicbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="ironbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem ironbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="copperbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem copperbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="silverbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem silverbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="goldbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem goldbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="diamondbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem diamondbackpack;
    @RegistryEntryAcceptor(namespace="packedup", identifier="obsidianbackpack", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BackpackItem obsidianbackpack;
    public static final class_1761 ITEM_GROUP;

    public void onInitialize() {
        CHANNEL.registerMessage(PacketRename.class, PacketRename::new, true);
        CHANNEL.registerMessage(PacketOpenBag.class, PacketOpenBag::new, true);
        BackpackStorageManager.registerEventListeners();
        PackedUp.register();
        PackedUp.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"packedup");
        for (BackpackType type : BackpackType.values()) {
            handler.registerItem(type.getRegistryName(), () -> new BackpackItem(type));
        }
        handler.registerMenuType("container", () -> BaseContainerType.create((container, data) -> {
            data.method_53002(container.type.ordinal());
            data.method_53002(container.bagSlot);
            data.method_10814(class_2561.class_2562.method_10867((class_2561)container.bagName));
            BackpackInventory inventory = container.inventory;
            data.method_53002(inventory.getInventoryIndex());
            data.method_53002(inventory.bagsInThisBag.size());
            inventory.bagsInThisBag.forEach(arg_0 -> ((class_2540)data).method_53002(arg_0));
            data.method_53002(inventory.bagsThisBagIsIn.size());
            inventory.bagsThisBagIsIn.forEach(arg_0 -> ((class_2540)data).method_53002(arg_0));
            data.method_53002(inventory.layer);
        }, (player, data) -> {
            BackpackType type = BackpackType.values()[data.readInt()];
            int bagSlot = data.readInt();
            class_5250 bagName = class_2561.class_2562.method_10877((String)data.method_19772());
            int inventoryIndex = data.readInt();
            int size = data.readInt();
            HashSet<Integer> bagsInThisBag = new HashSet<Integer>(size);
            for (int i = 0; i < size; ++i) {
                bagsInThisBag.add(data.readInt());
            }
            size = data.readInt();
            HashSet<Integer> bagsThisBagIsIn = new HashSet<Integer>(size);
            for (int i = 0; i < size; ++i) {
                bagsThisBagIsIn.add(data.readInt());
            }
            int layer = data.readInt();
            return new BackpackContainer((class_1657)player, bagSlot, (class_2561)bagName, inventoryIndex, type, (Set<Integer>)bagsInThisBag, (Set<Integer>)bagsThisBagIsIn, layer);
        }));
        handler.registerRecipeSerializer("upgrade_backpack", BackpackUpgradeRecipe.SERIALIZER);
        handler.registerResourceConditionSerializer("is_backpack_enabled", BackpackRecipeCondition.SERIALIZER);
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"packedup");
        handler.addGenerator(PackedUpAdvancementGenerator::new);
        handler.addGenerator(PackedUpLanguageGenerator::new);
        handler.addGenerator(PackedUpModelGenerator::new);
        handler.addGenerator(PackedUpRecipeGenerator::new);
        handler.addGenerator(PackedUpTagGenerator::new);
    }

    static {
        ITEM_GROUP = CreativeItemGroup.create((String)"packedup", () -> basicbackpack);
    }
}

