/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.google.common.collect.Lists;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackStorageManager;
import com.supermartijn642.packedup.BackpackType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

public class BackpackInventory {
    private final boolean remote;
    private final ArrayList<class_1799> stacks = new ArrayList();
    private final int inventoryIndex;
    public Set<Integer> bagsInThisBag = new HashSet<Integer>();
    public Set<Integer> bagsDirectlyInThisBag = new HashSet<Integer>();
    public Set<Integer> bagsThisBagIsIn = new HashSet<Integer>();
    public Set<Integer> bagsThisBagIsDirectlyIn = new HashSet<Integer>();
    public int layer;

    public BackpackInventory(boolean remote, int inventoryIndex, int slots, Set<Integer> bagsInThisBag, Set<Integer> bagsThisBagIsIn, int layer) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
        for (int a = 0; a < slots; ++a) {
            this.stacks.add(class_1799.field_8037);
        }
        this.bagsInThisBag.addAll(bagsInThisBag);
        this.bagsThisBagIsIn.addAll(bagsThisBagIsIn);
        this.layer = layer;
    }

    public BackpackInventory(boolean remote, int inventoryIndex, int slots) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
        for (int a = 0; a < slots; ++a) {
            this.stacks.add(class_1799.field_8037);
        }
    }

    public BackpackInventory(boolean remote, int inventoryIndex) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
    }

    public int getInventoryIndex() {
        return this.inventoryIndex;
    }

    public class_1799 getStackInSlot(int slot) {
        return this.stacks.get(slot);
    }

    public class_1799 extractItem(int slot, int amount) {
        class_1799 stack = this.stacks.get(slot);
        int count = Math.min(amount, stack.method_7947());
        class_1799 result = stack.method_7972();
        stack.method_7934(count);
        if (!this.remote && result.method_7909() instanceof BackpackItem && result.method_7948().method_10545("packedup:invIndex")) {
            int index = result.method_7948().method_10550("packedup:invIndex");
            boolean contains = false;
            for (class_1799 stack1 : this.stacks) {
                if (!(stack1.method_7909() instanceof BackpackItem) || !stack1.method_7948().method_10545("packedup:invIndex") || stack1.method_7948().method_10550("packedup:invIndex") != index) continue;
                contains = true;
                break;
            }
            if (!contains) {
                BackpackStorageManager.onExtract(index, this.inventoryIndex);
            }
        }
        result.method_7939(count);
        return result;
    }

    public boolean isItemValid(class_1799 stack) {
        class_2487 compound;
        if (stack.method_7909() instanceof BackpackItem && !this.isBagAllowed(stack)) {
            return false;
        }
        if (stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480 && stack.method_7985() && (compound = stack.method_7969().method_10562("BlockEntityTag")).method_10573("Items", 9)) {
            class_2371 items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)compound, (class_2371)items);
            for (class_1799 stack1 : items) {
                if (!(stack1.method_7909() instanceof BackpackItem)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canStack(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7960() || stack2.method_7960() || stack1.method_7909() == stack2.method_7909() && stack1.method_7919() == stack2.method_7919() && class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    public void save(File file) {
        class_2487 compound = new class_2487();
        compound.method_10569("stacks", this.stacks.size());
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            compound.method_10566("stack" + slot, (class_2520)this.stacks.get(slot).method_7953(new class_2487()));
        }
        compound.method_10572("bagsInThisBag", (List)Lists.newArrayList(this.bagsInThisBag));
        compound.method_10572("bagsThisBagIsIn", (List)Lists.newArrayList(this.bagsThisBagIsIn));
        compound.method_10569("layer", this.layer);
        try {
            class_2507.method_10630((class_2487)compound, (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(File file) {
        class_2487 compound;
        try {
            compound = class_2507.method_10633((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.stacks.clear();
        int size = compound.method_10545("stacks") ? compound.method_10550("stacks") : (compound.method_10545("rows") ? compound.method_10550("rows") * 9 : compound.method_10550("slots"));
        for (int slot = 0; slot < size; ++slot) {
            this.stacks.add(class_1799.method_7915((class_2487)compound.method_10562("stack" + slot)));
        }
        this.bagsInThisBag.clear();
        Arrays.stream(compound.method_10561("bagsInThisBag")).forEach(this.bagsInThisBag::add);
        this.bagsThisBagIsIn.clear();
        Arrays.stream(compound.method_10561("bagsThisBagIsIn")).forEach(this.bagsThisBagIsIn::add);
        this.layer = compound.method_10550("layer");
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        int index;
        class_1799 oldStack = this.stacks.get(slot);
        this.stacks.set(slot, class_1799.field_8037);
        if (!this.remote && oldStack.method_7909() instanceof BackpackItem && oldStack.method_7948().method_10545("packedup:invIndex")) {
            index = oldStack.method_7948().method_10550("packedup:invIndex");
            boolean contains = false;
            for (class_1799 stack1 : this.stacks) {
                if (!(stack1.method_7909() instanceof BackpackItem) || !stack1.method_7948().method_10545("packedup:invIndex") || stack1.method_7948().method_10550("packedup:invIndex") != index) continue;
                contains = true;
                break;
            }
            if (!contains) {
                BackpackStorageManager.onExtract(index, this.inventoryIndex);
            }
        }
        this.stacks.set(slot, stack);
        if (!this.remote && stack.method_7909() instanceof BackpackItem && stack.method_7948().method_10545("packedup:invIndex") && !this.bagsDirectlyInThisBag.contains(index = stack.method_7948().method_10550("packedup:invIndex"))) {
            BackpackStorageManager.onInsert(index, this.inventoryIndex);
        }
    }

    public void adjustSize(BackpackType type) {
        while (this.stacks.size() < type.getSlots()) {
            this.stacks.add(class_1799.field_8037);
        }
    }

    public List<class_1799> getStacks() {
        return this.stacks;
    }

    private boolean isBagAllowed(class_1799 bag) {
        if (BackpackStorageManager.maxLayers.get() != -1 && this.layer >= BackpackStorageManager.maxLayers.get()) {
            return false;
        }
        if (!bag.method_7948().method_10545("packedup:invIndex")) {
            return true;
        }
        int index = bag.method_7948().method_10550("packedup:invIndex");
        return index != this.inventoryIndex && !this.bagsThisBagIsIn.contains(index);
    }
}

