/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfigData;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class TravelersBackpackConfig {
    public static boolean enableTierUpgrades;
    public static boolean disableCrafting;
    public static boolean enableBackpackBlockQuickEquip;
    public static boolean invulnerableBackpack;
    public static String[] toolSlotsAcceptableItems;
    public static String[] blacklistedItems;
    public static boolean allowShulkerBoxes;
    public static long[] tanksCapacity;
    public static boolean voidProtection;
    public static boolean backpackDeathPlace;
    public static boolean backpackForceDeathPlace;
    public static boolean enableSleepingBagSpawnPoint;
    public static boolean trinketsIntegration;
    public static boolean enableLoot;
    public static boolean spawnEntitiesWithBackpack;
    public static String[] possibleOverworldEntityTypes;
    public static String[] possibleNetherEntityTypes;
    public static int spawnChance;
    public static String[] overworldBackpacks;
    public static String[] netherBackpacks;
    public static boolean enableVillagerTrade;
    public static boolean enableBackpackAbilities;
    public static boolean forceAbilityEnabled;
    public static String[] allowedAbilities;
    public static boolean tooManyBackpacksSlowness;
    public static int maxNumberOfBackpacks;
    public static int slownessPerExcessedBackpack;
    public static boolean enableToolCycling;
    public static boolean obtainTips;
    public static boolean renderTools;
    public static boolean renderBackpackWithElytra;
    public static boolean disableBackpackRender;
    public static boolean enableOverlay;
    public static int offsetX;
    public static int offsetY;

    public static void setup() {
        TravelersBackpackConfigData data = (TravelersBackpackConfigData)AutoConfig.register(TravelersBackpackConfigData.class, JanksonConfigSerializer::new).getConfig();
        TravelersBackpackConfig.bake(null, data);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> TravelersBackpackConfig.bake(server, data));
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, b) -> TravelersBackpackConfig.bake(server, data));
    }

    public static void bake(MinecraftServer server, TravelersBackpackConfigData data) {
        enableTierUpgrades = data.backpackSettings.enableTierUpgrades;
        disableCrafting = data.backpackSettings.disableCrafting;
        enableBackpackBlockQuickEquip = data.backpackSettings.enableBackpackBlockQuickEquip;
        invulnerableBackpack = data.backpackSettings.invulnerableBackpack;
        toolSlotsAcceptableItems = data.backpackSettings.toolSlotsAcceptableItems;
        blacklistedItems = data.backpackSettings.blacklistedItems;
        allowShulkerBoxes = data.backpackSettings.allowShulkerBoxes;
        tanksCapacity = data.backpackSettings.tanksCapacity;
        voidProtection = data.backpackSettings.voidProtection;
        backpackDeathPlace = data.backpackSettings.backpackDeathPlace;
        backpackForceDeathPlace = data.backpackSettings.backpackForceDeathPlace;
        enableSleepingBagSpawnPoint = data.backpackSettings.enableSleepingBagSpawnPoint;
        trinketsIntegration = data.backpackSettings.trinketsIntegration;
        enableLoot = data.world.enableLoot;
        spawnEntitiesWithBackpack = data.world.spawnEntitiesWithBackpack;
        possibleOverworldEntityTypes = data.world.possibleOverworldEntityTypes;
        possibleNetherEntityTypes = data.world.possibleNetherEntityTypes;
        spawnChance = data.world.spawnChance;
        overworldBackpacks = data.world.overworldBackpacks;
        netherBackpacks = data.world.netherBackpacks;
        enableVillagerTrade = data.world.enableVillagerTrade;
        enableBackpackAbilities = data.backpackAbilities.enableBackpackAbilities;
        forceAbilityEnabled = data.backpackAbilities.forceAbilityEnabled;
        allowedAbilities = data.backpackAbilities.allowedAbilities;
        tooManyBackpacksSlowness = data.slownessDebuff.tooManyBackpacksSlowness;
        maxNumberOfBackpacks = data.slownessDebuff.maxNumberOfBackpacks;
        slownessPerExcessedBackpack = data.slownessDebuff.slownessPerExcessedBackpack;
        if (server == null) {
            enableToolCycling = data.client.enableToolCycling;
            obtainTips = data.client.obtainTips;
            renderTools = data.client.renderTools;
            renderBackpackWithElytra = data.client.renderBackpackWithElytra;
            disableBackpackRender = data.client.disableBackpackRender;
            enableOverlay = data.client.overlay.enableOverlay;
            offsetX = data.client.overlay.offsetX;
            offsetY = data.client.overlay.offsetY;
        } else {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10794((class_2520)TravelersBackpackConfig.toNbt());
            server.method_3760().method_14571().forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)ModNetwork.UPDATE_CONFIG_ID, (class_2540)buf));
        }
    }

    public static class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10556("enableTierUpgrades", enableTierUpgrades);
        compound.method_10556("disableCrafting", disableCrafting);
        compound.method_10556("enableBackpackBlockQuickEquip", enableBackpackBlockQuickEquip);
        compound.method_10556("invulnerableBackpack", invulnerableBackpack);
        TravelersBackpackConfig.putStringArray(compound, toolSlotsAcceptableItems, "toolSlotsAcceptableItems");
        TravelersBackpackConfig.putStringArray(compound, blacklistedItems, "blacklistedItems");
        compound.method_10556("allowShulkerBoxes", allowShulkerBoxes);
        compound.method_10564("tanksCapacity", tanksCapacity);
        compound.method_10556("voidProtection", voidProtection);
        compound.method_10556("backpackDeathPlace", backpackDeathPlace);
        compound.method_10556("backpackForceDeathPlace", backpackForceDeathPlace);
        compound.method_10556("enableSleepingBagSpawnPoint", enableSleepingBagSpawnPoint);
        compound.method_10556("trinketsIntegration", trinketsIntegration);
        compound.method_10556("enableLoot", enableLoot);
        compound.method_10556("spawnEntitiesWithBackpack", spawnEntitiesWithBackpack);
        TravelersBackpackConfig.putStringArray(compound, possibleOverworldEntityTypes, "possibleOverworldEntityTypes");
        TravelersBackpackConfig.putStringArray(compound, possibleNetherEntityTypes, "possibleNetherEntityTypes");
        compound.method_10569("spawnChance", spawnChance);
        TravelersBackpackConfig.putStringArray(compound, overworldBackpacks, "overworldBackpacks");
        TravelersBackpackConfig.putStringArray(compound, netherBackpacks, "netherBackpacks");
        compound.method_10556("enableVillagerTrade", enableVillagerTrade);
        compound.method_10556("enableBackpackAbilities", enableBackpackAbilities);
        compound.method_10556("forceAbilityEnabled", forceAbilityEnabled);
        TravelersBackpackConfig.putStringArray(compound, allowedAbilities, "allowedAbilities");
        compound.method_10556("tooManyBackpacksSlowness", tooManyBackpacksSlowness);
        compound.method_10569("maxNumberOfBackpacks", maxNumberOfBackpacks);
        compound.method_10569("slownessPerExcessedBackpack", slownessPerExcessedBackpack);
        return compound;
    }

    public static void putStringArray(class_2487 targetCompound, String[] array, String listName) {
        class_2499 nbtList = new class_2499();
        for (String s : array) {
            nbtList.add((Object)class_2519.method_23256((String)s));
        }
        targetCompound.method_10566(listName, (class_2520)nbtList);
    }

    public static String[] getStringArray(class_2487 targetCompound, String listName) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (class_2520 nbt : (class_2499)targetCompound.method_10580(listName)) {
            class_2519 nbtString = (class_2519)nbt;
            stringList.add(nbtString.toString());
        }
        return stringList.toArray(new String[0]);
    }

    public static void fromNbt(class_2487 compound) {
        enableTierUpgrades = compound.method_10577("enableTierUpgrades");
        disableCrafting = compound.method_10577("disableCrafting");
        enableBackpackBlockQuickEquip = compound.method_10577("enableBackpackBlockQuickEquip");
        invulnerableBackpack = compound.method_10577("invulnerableBackpack");
        toolSlotsAcceptableItems = TravelersBackpackConfig.getStringArray(compound, "toolSlotsAcceptableItems");
        blacklistedItems = TravelersBackpackConfig.getStringArray(compound, "blacklistedItems");
        allowShulkerBoxes = compound.method_10577("allowShulkerBoxes");
        tanksCapacity = compound.method_10565("tanksCapacity");
        voidProtection = compound.method_10577("voidProtection");
        backpackDeathPlace = compound.method_10577("backpackDeathPlace");
        backpackForceDeathPlace = compound.method_10577("backpackForceDeathPlace");
        enableSleepingBagSpawnPoint = compound.method_10577("enableSleepingBagSpawnPoint");
        trinketsIntegration = compound.method_10577("trinketsIntegration");
        enableLoot = compound.method_10577("enableLoot");
        spawnEntitiesWithBackpack = compound.method_10577("spawnEntitiesWithBackpack");
        possibleOverworldEntityTypes = TravelersBackpackConfig.getStringArray(compound, "possibleOverworldEntityTypes");
        possibleNetherEntityTypes = TravelersBackpackConfig.getStringArray(compound, "possibleNetherEntityTypes");
        spawnChance = compound.method_10550("spawnChance");
        overworldBackpacks = TravelersBackpackConfig.getStringArray(compound, "overworldBackpacks");
        netherBackpacks = TravelersBackpackConfig.getStringArray(compound, "netherBackpacks");
        enableVillagerTrade = compound.method_10577("enableVillagerTrade");
        enableBackpackAbilities = compound.method_10577("enableBackpackAbilities");
        forceAbilityEnabled = compound.method_10577("forceAbilityEnabled");
        allowedAbilities = TravelersBackpackConfig.getStringArray(compound, "allowedAbilities");
        tooManyBackpacksSlowness = compound.method_10577("tooManyBackpacksSlowness");
        maxNumberOfBackpacks = compound.method_10550("maxNumberOfBackpacks");
        slownessPerExcessedBackpack = compound.method_10550("slownessPerExcessedBackpack");
    }

    public static void loadItemsFromConfig(String[] configArray, List<class_1792> targetList) {
        for (String registryName : configArray) {
            class_2960 id = new class_2960(registryName);
            if (!class_7923.field_41178.method_17966(id).isPresent()) continue;
            targetList.add((class_1792)class_7923.field_41178.method_10223(id));
        }
    }

    public static void loadEntityTypesFromConfig(String[] configArray, List<class_1299> targetList) {
        for (String registryName : configArray) {
            class_2960 id = new class_2960(registryName);
            if (!class_7923.field_41177.method_17966(id).isPresent()) continue;
            targetList.add((class_1299)class_7923.field_41177.method_10223(id));
        }
    }
}

