/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.init.ModCrafting;
import com.tiviacz.travelersbackpack.items.SleepingBagItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import net.minecraft.class_8785;
import org.apache.commons.lang3.NotImplementedException;

public class ShapedBackpackRecipe
extends class_1869 {
    protected final class_1799 output;

    public ShapedBackpackRecipe(String group, class_7710 category, int width, int height, class_2371<class_1856> input, class_1799 output, boolean showNotification) {
        super(group, category, width, height, input, output, showNotification);
        this.output = output;
    }

    public class_1799 method_17727(class_8566 inv, class_5455 manager) {
        class_1799 output = super.method_17727(inv, manager);
        if (!output.method_7960()) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 ingredient = inv.method_5438(i);
                if (!ingredient.method_7960() && ingredient.method_7909() instanceof TravelersBackpackItem) {
                    class_2487 compound = ingredient.method_7969();
                    output.method_7980(compound);
                    break;
                }
                if (ingredient.method_7960() || !(ingredient.method_7909() instanceof SleepingBagItem)) continue;
                output.method_7948().method_10569("SleepingBagColor", ShapedBackpackRecipe.getProperColor((SleepingBagItem)ingredient.method_7909()));
            }
        }
        return output;
    }

    public static int getProperColor(SleepingBagItem item) {
        if (item.method_7711() instanceof SleepingBagBlock) {
            return ((SleepingBagBlock)item.method_7711()).method_9487().method_7789();
        }
        return class_1767.field_7964.method_7789();
    }

    public class_1865<?> method_8119() {
        return ModCrafting.BACKPACK_SHAPED;
    }

    private static int findFirstSymbol(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findLastSymbol(String pattern) {
        int i;
        for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] removePadding(List<String> pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < pattern.size(); ++m) {
            String string = pattern.get(m);
            i = Math.min(i, ShapedBackpackRecipe.findFirstSymbol(string));
            int n = ShapedBackpackRecipe.findLastSymbol(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.size() == l) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = pattern.get(o + k).substring(i, j + 1);
        }
        return strings;
    }

    public static class Serializer
    implements class_1865<ShapedBackpackRecipe> {
        static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().flatXmap(rows -> {
            String string;
            if (rows.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (rows.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)rows.get(0)).length();
            Iterator var2 = rows.iterator();
            do {
                if (!var2.hasNext()) {
                    return DataResult.success((Object)rows);
                }
                string = (String)var2.next();
                if (string.length() <= 3) continue;
                return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
            } while (i == string.length());
            return DataResult.error(() -> "Invalid pattern: each row must be the same width");
        }, DataResult::success);
        static final Codec<String> KEY_ENTRY_CODEC = Codec.STRING.flatXmap(keyEntry -> {
            if (keyEntry.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(keyEntry) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)keyEntry);
        }, DataResult::success);
        private static final Codec<ShapedBackpackRecipe> CODEC = RawShapedRecipe.CODEC.flatXmap(recipe -> {
            String[] strings = ShapedBackpackRecipe.removePadding(recipe.pattern);
            int i = strings[0].length();
            int j = strings.length;
            class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            HashSet set = Sets.newHashSet(recipe.key.keySet());
            for (int k = 0; k < strings.length; ++k) {
                String string = strings[k];
                for (int l = 0; l < string.length(); ++l) {
                    class_1856 ingredient;
                    String string2 = string.substring(l, l + 1);
                    class_1856 class_18562 = ingredient = string2.equals(" ") ? class_1856.field_9017 : recipe.key.get(string2);
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + string2 + "' but it's not defined in the key");
                    }
                    set.remove(string2);
                    defaultedList.set(l + i * k, (Object)ingredient);
                }
            }
            if (!set.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + set);
            }
            ShapedBackpackRecipe shapedRecipe = new ShapedBackpackRecipe(recipe.group, recipe.category, i, j, (class_2371<class_1856>)defaultedList, recipe.result, recipe.showNotification);
            return DataResult.success((Object)((Object)shapedRecipe));
        }, recipe -> {
            throw new NotImplementedException("Serializing ShapedRecipe is not implemented yet.");
        });

        public Codec<ShapedBackpackRecipe> method_53736() {
            return CODEC;
        }

        public ShapedBackpackRecipe read(class_2540 packetByteBuf) {
            int i = packetByteBuf.method_10816();
            int j = packetByteBuf.method_10816();
            String string = packetByteBuf.method_19772();
            class_7710 craftingRecipeCategory = (class_7710)packetByteBuf.method_10818(class_7710.class);
            class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            for (int k = 0; k < defaultedList.size(); ++k) {
                defaultedList.set(k, (Object)class_1856.method_8086((class_2540)packetByteBuf));
            }
            class_1799 itemStack = packetByteBuf.method_10819();
            boolean bl = packetByteBuf.readBoolean();
            return new ShapedBackpackRecipe(string, craftingRecipeCategory, i, j, (class_2371<class_1856>)defaultedList, itemStack, bl);
        }

        public void write(class_2540 packetByteBuf, ShapedBackpackRecipe shapedRecipe) {
            packetByteBuf.method_10804(shapedRecipe.method_8150());
            packetByteBuf.method_10804(shapedRecipe.method_8158());
            packetByteBuf.method_10814(shapedRecipe.method_8112());
            packetByteBuf.method_10817((Enum)shapedRecipe.method_45441());
            for (class_1856 ingredient : shapedRecipe.method_8117()) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10793(shapedRecipe.output);
            packetByteBuf.method_52964(shapedRecipe.method_49188());
        }

        private record RawShapedRecipe(String group, class_7710 category, Map<String, class_1856> key, List<String> pattern, class_1799 result, boolean showNotification) {
            public static final Codec<RawShapedRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53049((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> recipe.group), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(recipe -> recipe.category), (App)class_5699.method_53703(KEY_ENTRY_CODEC, (Codec)class_1856.field_46096).fieldOf("key").forGetter(recipe -> recipe.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(recipe -> recipe.pattern), (App)class_8785.field_46092.fieldOf("result").forGetter(recipe -> recipe.result), (App)class_5699.method_53049((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, RawShapedRecipe::new));
        }
    }
}

