/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen.tooltip;

import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.util.InventoryUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_5632;

public class BackpackTooltipData
implements class_5632 {
    protected InventoryImproved inventory = this.createInventory(54);
    protected InventoryImproved craftingInventory = this.createInventory(9);
    protected SingleVariantStorage<FluidVariant> leftTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    protected SingleVariantStorage<FluidVariant> rightTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    protected class_1799 stack;
    protected Tiers.Tier tier = Tiers.LEATHER;

    public BackpackTooltipData(class_1799 stack) {
        this.stack = stack;
        this.loadTier(stack.method_7969());
        this.loadComponentData(stack.method_7969());
    }

    public void loadTier(class_2487 compound) {
        this.tier = compound != null ? Tiers.of(compound.method_10550("Tier")) : Tiers.LEATHER;
    }

    public void loadComponentData(class_2487 compound) {
        if (compound == null) {
            return;
        }
        this.loadInventory(compound);
        this.loadCraftingInventory(compound);
        this.loadLeftTank(compound);
        this.loadRightTank(compound);
    }

    public void loadInventory(class_2487 compound) {
        if (compound.method_10545("Inventory")) {
            this.inventory = this.createInventory(this.tier.getAllSlots());
            InventoryUtils.readNbt(compound, this.inventory.getStacks(), false);
        }
    }

    public void loadCraftingInventory(class_2487 compound) {
        if (compound.method_10545("CraftingInventory")) {
            this.craftingInventory = this.createInventory(9);
            InventoryUtils.readNbt(compound, this.craftingInventory.getStacks(), true);
        }
    }

    public void loadLeftTank(class_2487 compound) {
        if (compound.method_10545("LeftTank")) {
            this.leftTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("LeftTank"));
            this.leftTank.amount = compound.method_10537("LeftTankAmount");
        }
    }

    public void loadRightTank(class_2487 compound) {
        if (compound.method_10545("RightTank")) {
            this.rightTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("RightTank"));
            this.rightTank.amount = compound.method_10537("RightTankAmount");
        }
    }

    public boolean hasToolInSlot(Tiers.SlotType type) {
        return !this.inventory.method_5438(this.tier.getSlotIndex(type)).method_7960();
    }

    public InventoryImproved createInventory(int size) {
        return new InventoryImproved(class_2371.method_10213((int)size, (Object)class_1799.field_8037)){

            @Override
            public void method_5431() {
            }
        };
    }

    public SingleVariantStorage<FluidVariant> createFluidTank(long capacity) {
        return new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return BackpackTooltipData.this.tier.getTankCapacity();
            }
        };
    }
}

