/*
 * Decompiled with CFR 0.152.
 */
package pers.saikel0rado1iu.silk.util;

import java.util.concurrent.TimeUnit;

public interface TickUtil {
    public static final int TPS = 20;
    public static final int MC_TIME_PASSES_MAGNIFICATION = 72;

    public static int getTick(float naturalSec) {
        return (int)(naturalSec * 20.0f);
    }

    public static float getTime(int tick) {
        return (float)tick / 20.0f;
    }

    public static int getTick(TimeType type, TimeUnit unit, float time) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TimeType.NATURAL -> TickUtil.getNaturalTick(unit, time);
            case TimeType.GAME -> TickUtil.getGameTick(unit, time);
        };
    }

    public static float getTime(TimeType type, TimeUnit unit, float tick) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TimeType.NATURAL -> TickUtil.getNaturalTime(unit, tick);
            case TimeType.GAME -> TickUtil.getGameTime(unit, tick);
        };
    }

    private static int getNaturalTick(TimeUnit unit, float time) {
        return Math.max(1, (int)((double)time * TickUtil.getTimeRatio(unit)));
    }

    private static int getGameTick(TimeUnit unit, float time) {
        return Math.max(1, TickUtil.getNaturalTick(unit, time) / 72);
    }

    private static float getNaturalTime(TimeUnit unit, float tick) {
        return Math.max(1.0f, (float)((double)tick / TickUtil.getTimeRatio(unit)));
    }

    private static float getGameTime(TimeUnit unit, float tick) {
        return TickUtil.getNaturalTime(unit, tick) / 72.0f;
    }

    private static double getTimeRatio(TimeUnit unit) {
        return switch (unit) {
            default -> throw new IncompatibleClassChangeError();
            case TimeUnit.DAYS -> 1728000.0;
            case TimeUnit.HOURS -> 72000.0;
            case TimeUnit.MINUTES -> 1200.0;
            case TimeUnit.SECONDS -> 20.0;
            case TimeUnit.MILLISECONDS -> 0.02;
            case TimeUnit.MICROSECONDS -> 2.0E-5;
            case TimeUnit.NANOSECONDS -> 2.0E-8;
        };
    }

    public static enum TimeType {
        NATURAL,
        GAME;

    }
}

