/*
 * Decompiled with CFR 0.152.
 */
package pers.saikel0rado1iu.silk.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_2960;
import net.minecraft.class_3797;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.saikel0rado1iu.silk.SilkData;

public interface ModBasicData {
    public static String getMinecraftVer() {
        return class_3797.field_25319.method_48019();
    }

    default public int getThemeColor() {
        return -1;
    }

    @NotNull
    public String getModId();

    @NotNull
    default public String getModName() {
        return this.getModInstance().getMetadata().getName();
    }

    @NotNull
    default public String getModVer() {
        return this.getModInstance().getMetadata().getVersion().getFriendlyString();
    }

    @NotNull
    default public String getModSlug() {
        return this.getModId();
    }

    default public Collection<Person> getAuthors() {
        return this.getModInstance().getMetadata().getAuthors();
    }

    default public Collection<String> getLicense() {
        return this.getModInstance().getMetadata().getLicense();
    }

    default public Optional<class_2960> getIconId() {
        Optional path = this.getModInstance().getMetadata().getIconPath(4);
        return path.map(class_2960::new);
    }

    default public Optional<URL> getLink(LinkType type) {
        try {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case LinkType.HOMEPAGE -> this.getHomepage();
                case LinkType.SOURCES -> this.getSourcesLink();
                case LinkType.ISSUES -> this.getIssuesLink();
                case LinkType.COMMUNITY -> this.getCommunityLink();
                case LinkType.SUPPORT -> this.getSupportLink();
            };
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    default public ModContainer getModInstance() {
        Optional modContainerOptional = FabricLoader.getInstance().getModContainer(this.getModId());
        if (modContainerOptional.isEmpty()) {
            String msg = "Mod not found, no mod with id '" + this.getModId() + "' exists!";
            SilkData.INSTANCE.getLogger().atError().log(msg);
            throw new RuntimeException(msg);
        }
        return (ModContainer)modContainerOptional.get();
    }

    @NotNull
    default public Logger getLogger() {
        return LoggerFactory.getLogger((String)this.getModName());
    }

    @ApiStatus.OverrideOnly
    default public Optional<URL> getHomepage() throws MalformedURLException {
        Optional url = this.getModInstance().getMetadata().getContact().get("homepage");
        if (url.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new URL((String)url.get()));
    }

    @ApiStatus.OverrideOnly
    default public Optional<URL> getSourcesLink() throws MalformedURLException {
        Optional url = this.getModInstance().getMetadata().getContact().get("sources");
        if (url.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new URL((String)url.get()));
    }

    @ApiStatus.OverrideOnly
    default public Optional<URL> getIssuesLink() throws MalformedURLException {
        Optional url = this.getModInstance().getMetadata().getContact().get("issues");
        if (url.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new URL((String)url.get()));
    }

    @ApiStatus.OverrideOnly
    default public Optional<URL> getCommunityLink() throws MalformedURLException {
        return Optional.empty();
    }

    @ApiStatus.OverrideOnly
    default public Optional<URL> getSupportLink() throws MalformedURLException {
        return Optional.empty();
    }

    public static enum LinkType {
        HOMEPAGE,
        SOURCES,
        ISSUES,
        COMMUNITY,
        SUPPORT;

    }
}

