/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.fabric;

import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public class SpawnEntityPacket {
    private static final class_2960 PACKET_ID = new class_2960("architectury", "spawn_entity_packet");

    public static class_2596<class_2602> create(class_1297 entity) {
        if (entity.method_37908().method_8608()) {
            throw new IllegalStateException("SpawnPacketUtil.create called on the logical client!");
        }
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10804(class_7923.field_41177.method_10206((Object)entity.method_5864()));
        buffer.method_10797(entity.method_5667());
        buffer.method_10804(entity.method_5628());
        class_243 position = entity.method_19538();
        buffer.method_52940(position.field_1352);
        buffer.method_52940(position.field_1351);
        buffer.method_52940(position.field_1350);
        buffer.method_52941(entity.method_36455());
        buffer.method_52941(entity.method_36454());
        buffer.method_52941(entity.method_5791());
        class_243 deltaMovement = entity.method_18798();
        buffer.method_52940(deltaMovement.field_1352);
        buffer.method_52940(deltaMovement.field_1351);
        buffer.method_52940(deltaMovement.field_1350);
        if (entity instanceof EntitySpawnExtension) {
            EntitySpawnExtension ext = (EntitySpawnExtension)entity;
            ext.saveAdditionalSpawnData(buffer);
        }
        return NetworkManager.toPacket(NetworkManager.s2c(), PACKET_ID, buffer);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        @Environment(value=EnvType.CLIENT)
        public static void register() {
            NetworkManager.registerReceiver(NetworkManager.s2c(), PACKET_ID, Client::receive);
        }

        @Environment(value=EnvType.CLIENT)
        public static void receive(class_2540 buf, NetworkManager.PacketContext context) {
            int entityTypeId = buf.method_10816();
            UUID uuid = buf.method_10790();
            int id = buf.method_10816();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float xRot = buf.readFloat();
            float yRot = buf.readFloat();
            float yHeadRot = buf.readFloat();
            double deltaX = buf.readDouble();
            double deltaY = buf.readDouble();
            double deltaZ = buf.readDouble();
            buf.method_52938();
            context.queue(() -> {
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10200(entityTypeId);
                if (entityType == null) {
                    throw new IllegalStateException("Entity type (" + entityTypeId + ") is unknown, spawning at (" + x + ", " + y + ", " + z + ")");
                }
                if (class_310.method_1551().field_1687 == null) {
                    throw new IllegalStateException("Client world is null!");
                }
                class_1297 entity = entityType.method_5883((class_1937)class_310.method_1551().field_1687);
                if (entity == null) {
                    throw new IllegalStateException("Created entity is null!");
                }
                entity.method_5826(uuid);
                entity.method_5838(id);
                entity.method_43391(x, y, z);
                entity.method_24203(x, y, z);
                entity.method_36457(xRot);
                entity.method_36456(yRot);
                entity.method_5847(yHeadRot);
                entity.method_5636(yHeadRot);
                if (entity instanceof EntitySpawnExtension) {
                    EntitySpawnExtension ext = (EntitySpawnExtension)entity;
                    ext.loadAdditionalSpawnData(buf);
                }
                buf.release();
                class_310.method_1551().field_1687.method_53875(entity);
                entity.method_5750(deltaX, deltaY, deltaZ);
            });
        }
    }
}

