/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.text2speech.Narrator;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8658;
import net.minecraft.class_8690;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.ui.BoxElement;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientProxy;

public class WailaTickHandler {
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    private static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static String lastNarration = "";
    private static long lastNarrationTime = 0L;
    public BoxElement rootElement;
    public ProgressTracker progressTracker = new ProgressTracker();

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    public static void narrate(ITooltip tooltip, boolean dedupe) {
        if (!NARRATOR.get().active() || tooltip.isEmpty()) {
            return;
        }
        if (System.currentTimeMillis() - lastNarrationTime < 500L) {
            return;
        }
        String narration = tooltip.getMessage();
        if (dedupe && narration.equals(lastNarration)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            Narrator narrator = NARRATOR.get();
            narrator.clear();
            narrator.say(class_3544.method_15440((String)narration), false);
        });
        lastNarration = narration;
        lastNarrationTime = System.currentTimeMillis();
    }

    public static void clearLastNarration() {
        lastNarration = "";
    }

    public void tickClient() {
        class_3965 blockTarget;
        this.progressTracker.tick();
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.rootElement = null;
            return;
        }
        class_310 client = class_310.method_1551();
        if (!ClientProxy.shouldShowWithOverlay(client, client.field_1755)) {
            return;
        }
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world == null || player == null) {
            this.rootElement = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        class_239 target = RayTracing.INSTANCE.getTarget();
        Tooltip tooltip = new Tooltip();
        if (target == null) {
            this.rootElement = null;
            return;
        }
        Accessor<class_3966> accessor = null;
        if (target instanceof class_3965 && (blockTarget = (class_3965)target).method_17783() != class_239.class_240.field_1333) {
            class_2680 state = world.method_8320(blockTarget.method_17777());
            class_2586 tileEntity = world.method_8321(blockTarget.method_17777());
            accessor = WailaClientRegistration.instance().blockAccessor().blockState(state).blockEntity(tileEntity).hit(blockTarget).requireVerification().build();
        } else if (target instanceof class_3966) {
            class_3966 entityTarget = (class_3966)target;
            accessor = WailaClientRegistration.instance().entityAccessor().hit(entityTarget).entity(entityTarget.method_17782()).requireVerification().build();
        } else if (client.field_1755 instanceof BaseOptionsScreen) {
            accessor = WailaClientRegistration.instance().blockAccessor().blockState(class_2246.field_10219.method_9564()).hit(new class_3965(player.method_19538(), class_2350.field_11036, player.method_24515(), false)).build();
        }
        EntityAccessor originalAccessor = accessor;
        for (JadeRayTraceCallback callback2 : WailaClientRegistration.instance().rayTraceCallback.callbacks()) {
            accessor = callback2.onRayTrace(target, accessor, originalAccessor);
        }
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.rootElement = null;
            return;
        }
        AccessorClientHandler<Accessor<?>> handler = WailaClientRegistration.instance().getAccessorHandler(accessor.getAccessorType());
        if (!handler.shouldDisplay(accessor)) {
            this.rootElement = null;
            return;
        }
        if (accessor.isServerConnected()) {
            boolean request = handler.shouldRequestData(accessor);
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (request) {
                    handler.requestData(accessor);
                }
            }
            if (request && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        OverlayRenderer.theme.setValue((Object)IWailaConfig.get().getOverlay().getTheme());
        Accessor<class_3966> accessor0 = accessor;
        WailaClientRegistration.instance().beforeTooltipCollectCallback.call(callback -> callback.beforeCollecting(OverlayRenderer.theme, accessor0));
        Theme theme = (Theme)OverlayRenderer.theme.getValue();
        Preconditions.checkNotNull((Object)theme, (Object)"Theme cannot be null");
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !ClientProxy.isShowDetailsPressed()) {
            Tooltip dummyTooltip = new Tooltip();
            handler.gatherComponents(accessor, $ -> {
                if (Math.abs(WailaCommonRegistration.instance().priorities.byValue((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            handler.gatherComponents(accessor, $ -> tooltip);
        }
        this.rootElement = new BoxElement(tooltip, IThemeHelper.get().theme().tooltipStyle);
        this.rootElement.tag(Identifiers.ROOT);
        if (IWailaConfig.get().getOverlay().shouldShowIcon()) {
            IElement icon = RayTracing.INSTANCE.getIcon();
            if (icon != null && theme.iconSlotSprite != null) {
                if (theme.iconSlotSpriteCache == null) {
                    class_8658 guiSprites = class_310.method_1551().method_52699();
                    class_1058 textureAtlasSprite = guiSprites.method_18667(theme.iconSlotSprite);
                    class_8690 scaling = guiSprites.method_52714(textureAtlasSprite);
                    int[] padding = new int[4];
                    Arrays.fill(padding, theme.iconSlotInflation);
                    if (scaling instanceof class_8690.class_8691) {
                        class_8690.class_8691 nineSlice = (class_8690.class_8691)scaling;
                        class_8690.class_8691.class_8692 border = nineSlice.comp_1639();
                        padding[0] = padding[0] + border.comp_1641();
                        padding[1] = padding[1] + border.comp_1642();
                        padding[2] = padding[2] + border.comp_1643();
                        padding[3] = padding[3] + border.comp_1640();
                    }
                    theme.iconSlotSpriteCache = new BoxElement(new Tooltip(), BoxStyle.getSprite(theme.iconSlotSprite, padding));
                }
                ITooltip tooltip1 = theme.iconSlotSpriteCache.getTooltip();
                tooltip1.clear();
                tooltip1.add(icon);
                icon = theme.iconSlotSpriteCache.size(null);
            }
            this.rootElement.setIcon(icon);
        }
        for (JadeTooltipCollectedCallback callback3 : WailaClientRegistration.instance().tooltipCollectedCallback.callbacks()) {
            callback3.onTooltipCollected(this.rootElement, accessor);
        }
    }
}

