/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.commons.lang3.mutable.MutableObject;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.TooltipRect;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.impl.ui.BoxElement;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;

public class OverlayRenderer {
    public static final MutableObject<Theme> theme = new MutableObject((Object)IWailaConfig.get().getOverlay().getTheme());
    private static final TooltipRect rect = new TooltipRect();
    public static float ticks;
    public static boolean shown;
    public static float alpha;
    private static BoxElement lingerTooltip;
    private static float disappearTicks;

    public static boolean shouldShow() {
        if (WailaTickHandler.instance().rootElement == null) {
            return false;
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (!general.shouldDisplayTooltip()) {
            return false;
        }
        if (general.getDisplayMode() == IWailaConfig.DisplayMode.HOLD_KEY && !JadeClient.showOverlay.method_1434()) {
            return false;
        }
        IWailaConfig.BossBarOverlapMode mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode();
        return mode != IWailaConfig.BossBarOverlapMode.HIDE_TOOLTIP || ClientProxy.getBossBarRect() == null;
    }

    public static boolean shouldShowImmediately(BoxElement box) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return false;
        }
        if (!ClientProxy.shouldShowWithOverlay(mc, mc.field_1755)) {
            return false;
        }
        box.updateExpectedRect(rect);
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof PreviewOptionsScreen) {
            double y;
            PreviewOptionsScreen optionsScreen = (PreviewOptionsScreen)class_4372;
            if (!general.previewOverlay && !optionsScreen.forcePreviewOverlay()) {
                return false;
            }
            class_1041 window = mc.method_22683();
            double x = mc.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
            if (OverlayRenderer.rect.expectedRect.method_3318((int)x, (int)(y = mc.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507()))) {
                return false;
            }
        }
        if (mc.field_1705.method_53531().method_53536() && general.shouldHideFromDebug()) {
            return false;
        }
        if (mc.method_18506() != null || mc.field_1690.field_1842) {
            return false;
        }
        return !mc.field_1705.method_1750().field_2158 || !general.shouldHideFromTabList();
    }

    public static void renderOverlay478757(class_332 guiGraphics) {
        shown = false;
        boolean show = OverlayRenderer.shouldShow();
        BoxElement root = WailaTickHandler.instance().rootElement;
        float delta = class_310.method_1551().method_1534();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (root != null) {
            lingerTooltip = root;
        }
        if (root == null && lingerTooltip != null) {
            if ((disappearTicks += delta) < overlay.getDisappearingDelay()) {
                root = lingerTooltip;
                show = true;
            }
        } else {
            disappearTicks = 0.0f;
        }
        if (overlay.getAnimation() && lingerTooltip != null) {
            root = lingerTooltip;
            float speed = general.isDebug() ? 0.1f : 0.6f;
            alpha += (show ? speed : -speed) * delta;
            alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        } else {
            float f = alpha = show ? 1.0f : 0.0f;
        }
        if (alpha < 0.1f || root == null || !OverlayRenderer.shouldShowImmediately(root)) {
            lingerTooltip = null;
            OverlayRenderer.rect.rect.method_35782(0);
            WailaTickHandler.clearLastNarration();
            return;
        }
        ticks += delta;
        class_310.method_1551().method_16011().method_15396("Jade Overlay");
        OverlayRenderer.renderOverlay(root, guiGraphics);
        class_310.method_1551().method_16011().method_15407();
    }

    public static void renderOverlay(BoxElement root, class_332 guiGraphics) {
        root.updateRect(rect);
        for (JadeBeforeRenderCallback callback2 : WailaClientRegistration.instance().beforeRenderCallback.callbacks()) {
            if (!callback2.beforeRender(root, rect, guiGraphics, ObjectDataCenter.get())) continue;
            return;
        }
        class_4587 matrixStack = guiGraphics.method_51448();
        matrixStack.method_22903();
        float z = class_310.method_1551().field_1755 == null ? 1.0f : 100.0f;
        matrixStack.method_46416((float)OverlayRenderer.rect.rect.method_3321(), (float)OverlayRenderer.rect.rect.method_3322(), z);
        float scale = OverlayRenderer.rect.scale;
        if (scale != 1.0f) {
            matrixStack.method_22905(scale, scale, 1.0f);
        }
        RenderSystem.enableBlend();
        float maxWidth = OverlayRenderer.rect.rect.method_3319();
        float maxHeight = OverlayRenderer.rect.rect.method_3320();
        if (root.getStyle().hasRoundCorner()) {
            maxWidth -= 2.0f;
            maxHeight -= 2.0f;
        }
        root.render(guiGraphics, 0.0f, 0.0f, maxWidth /= scale, maxHeight /= scale);
        WailaClientRegistration.instance().afterRenderCallback.call(callback -> callback.afterRender(root, rect, guiGraphics, ObjectDataCenter.get()));
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        matrixStack.method_22909();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech()) {
            WailaTickHandler.narrate(root.getTooltip(), true);
        }
        shown = true;
    }
}

