/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.class_1041;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Direction2D;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.MessageType;
import snownee.jade.api.ui.TooltipRect;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;

public class BoxElement
extends Element
implements IBoxElement {
    private final Tooltip tooltip;
    private final BoxStyle style;
    private int[] padding;
    private IElement icon;
    private float boxProgress;
    private MessageType boxProgressType;
    private ProgressTracker.TrackInfo track;
    private class_241 contentSize = class_241.field_1340;

    public BoxElement(Tooltip tooltip, BoxStyle style) {
        this.tooltip = Objects.requireNonNull(tooltip);
        this.style = Objects.requireNonNull(style);
    }

    private static void chase(TooltipRect rect, ToIntFunction<class_768> getter, IntConsumer setter) {
        if (Jade.CONFIG.get().getOverlay().getAnimation()) {
            int source = getter.applyAsInt(rect.rect);
            int target = getter.applyAsInt(rect.expectedRect);
            float diff = target - source;
            if (diff == 0.0f) {
                return;
            }
            float delta = class_310.method_1551().method_1534() * 2.0f;
            if (delta < 1.0f) {
                diff *= delta;
            }
            if (class_3532.method_15379((float)diff) < 1.0f) {
                diff = diff > 0.0f ? 1.0f : -1.0f;
            }
            setter.accept((int)((float)source + diff));
        } else {
            setter.accept(getter.applyAsInt(rect.expectedRect));
        }
    }

    private static int calculateMargin(int margin1, int margin2) {
        if (margin1 >= 0 && margin2 >= 0) {
            return Math.max(margin1, margin2);
        }
        if (margin1 < 0 && margin2 < 0) {
            return Math.min(margin1, margin2);
        }
        return margin1 + margin2;
    }

    @Override
    public class_241 getSize() {
        if (this.tooltip.isEmpty()) {
            return class_241.field_1340;
        }
        float width = 0.0f;
        float height = 0.0f;
        int lineCount = this.tooltip.lines.size();
        Tooltip.Line line = this.tooltip.lines.get(0);
        for (int i = 0; i < lineCount; ++i) {
            class_241 size = line.getSize();
            width = Math.max(width, size.field_1343);
            height += size.field_1342;
            if (i >= lineCount - 1) continue;
            int marginBottom = line.marginBottom;
            line = this.tooltip.lines.get(i + 1);
            height += (float)BoxElement.calculateMargin(marginBottom, line.marginTop);
        }
        this.contentSize = new class_241(width, height);
        if (this.icon != null) {
            class_241 size = this.icon.getCachedSize();
            width += size.field_1343 + 3.0f;
            height = Math.max(height, size.field_1342);
        }
        width += (float)(this.padding(Direction2D.LEFT) + this.padding(Direction2D.RIGHT));
        height += (float)(this.padding(Direction2D.UP) + this.padding(Direction2D.DOWN));
        width = Math.max(width, 0.0f);
        height = Math.max(height, 0.0f);
        if (this.icon != null && this.icon.getCachedSize().field_1342 > this.contentSize.field_1342) {
            this.setPadding(Direction2D.UP, this.padding(Direction2D.UP) + (int)(this.icon.getCachedSize().field_1342 - this.contentSize.field_1342) / 2);
        }
        return new class_241(width, height);
    }

    @Override
    public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
        float arrowTop;
        if (this.tooltip.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x, y, 0.0f);
        float alpha = IDisplayHelper.get().opacity();
        if (Identifiers.ROOT.equals((Object)this.getTag())) {
            alpha *= IWailaConfig.get().getOverlay().getAlpha();
        }
        this.style.render(guiGraphics, this, 0.0f, 0.0f, maxX - x, maxY - y, alpha);
        float maxWidth = maxX - x - (float)this.padding(Direction2D.RIGHT);
        if (this.boxProgressType != null) {
            float left = this.style.boxProgressOffset(Direction2D.LEFT);
            float width = maxWidth - left + this.style.boxProgressOffset(Direction2D.RIGHT);
            float top = maxY - y - 1.0f + this.style.boxProgressOffset(Direction2D.UP) + this.style.borderWidth();
            float height = 1.0f + this.style.boxProgressOffset(Direction2D.DOWN);
            float progress = this.boxProgress;
            if (this.track == null && this.tag != null) {
                this.track = WailaTickHandler.instance().progressTracker.createInfo(this.tag, progress, false, 0.0f);
            }
            if (this.track != null) {
                progress = this.track.tick(class_310.method_1551().method_1534());
            }
            ((DisplayHelper)IDisplayHelper.get()).drawGradientProgress(guiGraphics, left, top, width, height, progress, this.style.boxProgressColors.get(this.boxProgressType));
        }
        float contentLeft = this.padding(Direction2D.LEFT);
        float contentTop = this.padding(Direction2D.UP);
        if (this.icon != null) {
            class_241 iconSize = this.icon.getCachedSize();
            class_241 offset = this.icon.getTranslation();
            float offsetY = offset.field_1342;
            float min = contentTop + (float)this.padding(Direction2D.DOWN) + iconSize.field_1342;
            offsetY = IWailaConfig.get().getOverlay().getIconMode() == IWailaConfig.IconMode.TOP && min < this.size.field_1342 ? (offsetY += contentTop) : (offsetY += (this.size.field_1342 - iconSize.field_1342) / 2.0f);
            float offsetX = contentLeft + offset.field_1343;
            Tooltip.drawDebugBorder(guiGraphics, offsetX, offsetY, this.icon);
            this.icon.render(guiGraphics, offsetX, offsetY, offsetX + iconSize.field_1343, offsetY + iconSize.field_1342);
            contentLeft += iconSize.field_1343 + 3.0f;
        }
        float lineTop = contentTop;
        int lineCount = this.tooltip.lines.size();
        Tooltip.Line line = this.tooltip.lines.get(0);
        for (int i = 0; i < lineCount; ++i) {
            class_241 lineSize = line.getSize();
            line.render(guiGraphics, contentLeft, lineTop, maxWidth, lineSize.field_1342);
            if (i >= lineCount - 1) continue;
            int marginBottom = line.marginBottom;
            line = this.tooltip.lines.get(i + 1);
            lineTop += lineSize.field_1342 + (float)BoxElement.calculateMargin(marginBottom, line.marginTop);
        }
        if (this.tooltip.sneakyDetails && (arrowTop = OverlayRenderer.ticks / 5.0f % 8.0f - 2.0f) <= 4.0f && (double)(alpha = 1.0f - Math.abs(arrowTop) / 2.0f) > 0.016) {
            guiGraphics.method_51448().method_22903();
            class_310 mc = class_310.method_1551();
            float arrowLeft = contentLeft + (this.contentSize.field_1343 - (float)mc.field_1772.method_1727("\u25be") + 1.0f) / 2.0f;
            guiGraphics.method_51448().method_46416(arrowLeft, arrowTop += this.size.field_1342 - 6.0f, 0.0f);
            int color = IWailaConfig.IConfigOverlay.applyAlpha(IThemeHelper.get().theme().text.colors().info(), alpha);
            DisplayHelper.INSTANCE.drawText(guiGraphics, "\u25be", 0.0f, 0.0f, color);
            guiGraphics.method_51448().method_22909();
        }
        Tooltip.drawDebugBorder(guiGraphics, 0.0f, 0.0f, this);
        guiGraphics.method_51448().method_22909();
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.tooltip.isEmpty() ? null : this.tooltip.getMessage();
    }

    @Override
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setBoxProgress(MessageType type, float progress) {
        this.boxProgress = progress;
        this.boxProgressType = type;
    }

    @Override
    public float getBoxProgress() {
        return this.boxProgressType == null ? Float.NaN : this.boxProgress;
    }

    @Override
    public void clearBoxProgress() {
        this.boxProgress = 0.0f;
        this.boxProgressType = null;
    }

    @Override
    @Nullable
    public IElement getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(@Nullable IElement icon) {
        this.icon = icon;
    }

    public void updateExpectedRect(TooltipRect rect) {
        class_768 bossBarRect;
        class_1041 window = class_310.method_1551().method_22683();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        class_241 size = this.getCachedSize();
        float x = (float)window.method_4486() * overlay.tryFlip(overlay.getOverlayPosX());
        float y = (float)window.method_4502() * (1.0f - overlay.getOverlayPosY());
        float width = size.field_1343;
        float height = size.field_1342;
        if (this.style.hasRoundCorner()) {
            x += 1.0f;
            y += 1.0f;
            width += 2.0f;
            height += 2.0f;
        }
        rect.scale = overlay.getOverlayScale();
        float thresholdHeight = (float)window.method_4502() * overlay.getAutoScaleThreshold();
        if (size.field_1342 * rect.scale > thresholdHeight) {
            rect.scale = Math.max(rect.scale * 0.5f, thresholdHeight / size.field_1342);
        }
        class_768 expectedRect = rect.expectedRect;
        expectedRect.method_35782((int)(width * rect.scale));
        expectedRect.method_35783((int)(height * rect.scale));
        expectedRect.method_35778((int)(x - (float)expectedRect.method_3319() * overlay.tryFlip(overlay.getAnchorX())));
        expectedRect.method_35781((int)(y - (float)expectedRect.method_3320() * overlay.getAnchorY()));
        IWailaConfig.BossBarOverlapMode mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode();
        if (mode == IWailaConfig.BossBarOverlapMode.PUSH_DOWN && (bossBarRect = ClientProxy.getBossBarRect()) != null) {
            width = expectedRect.method_3319();
            height = expectedRect.method_3320();
            int rw = bossBarRect.method_3319();
            int rh = bossBarRect.method_3320();
            x = expectedRect.method_3321();
            y = expectedRect.method_3322();
            int rx = bossBarRect.method_3321();
            int ry = bossBarRect.method_3322();
            rw += rx;
            rh += ry;
            width += x;
            height += y;
            if ((float)rw > x && (float)rh > y && width > (float)rx && height > (float)ry) {
                expectedRect.method_35781(bossBarRect.method_3320());
            }
        }
    }

    public void updateRect(TooltipRect rect) {
        class_768 src = rect.rect;
        if (src.method_3319() == 0) {
            src.method_35778(rect.expectedRect.method_3321());
            src.method_35781(rect.expectedRect.method_3322());
            src.method_35782(rect.expectedRect.method_3319());
            src.method_35783(rect.expectedRect.method_3320());
        } else {
            BoxElement.chase(rect, class_768::method_3321, arg_0 -> ((class_768)src).method_35778(arg_0));
            BoxElement.chase(rect, class_768::method_3322, arg_0 -> ((class_768)src).method_35781(arg_0));
            BoxElement.chase(rect, class_768::method_3319, arg_0 -> ((class_768)src).method_35782(arg_0));
            BoxElement.chase(rect, class_768::method_3320, arg_0 -> ((class_768)src).method_35783(arg_0));
        }
    }

    @Override
    public int padding(Direction2D direction) {
        if (this.padding != null) {
            return this.padding[direction.ordinal()];
        }
        return this.style.padding(direction);
    }

    @Override
    public void setPadding(Direction2D direction, int value) {
        if (this.padding == null) {
            this.padding = (int[])this.style.padding.clone();
        }
        this.padding[direction.ordinal()] = value;
    }

    @Override
    public BoxStyle getStyle() {
        return this.style;
    }
}

