/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import snownee.jade.Jade;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.ui.Direction2D;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.overlay.DisplayHelper;

public class Tooltip
implements ITooltip {
    public final List<Line> lines = new ArrayList<Line>();
    public boolean sneakyDetails;

    public static void drawDebugBorder(class_332 guiGraphics, float x, float y, IElement element) {
        if (Jade.CONFIG.get().getGeneral().isDebug() && class_437.method_25441()) {
            class_241 translate = element.getTranslation();
            class_241 size = element.getCachedSize();
            DisplayHelper.INSTANCE.drawBorder(guiGraphics, x, y, x + size.field_1343, y + size.field_1342, 1.0f, -1996554240, true);
            if (!class_241.field_1340.method_1016(translate)) {
                DisplayHelper.INSTANCE.drawBorder(guiGraphics, x + translate.field_1343, y + translate.field_1342, x + translate.field_1343 + size.field_1343, y + translate.field_1342 + size.field_1342, 1.0f, -2013265665, true);
            }
        }
    }

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    public void append(int index, IElement element) {
        if (element.getTag() == null) {
            element.tag(ElementHelper.INSTANCE.currentUid());
        }
        if (this.isEmpty() || index == this.size()) {
            this.add(element);
        } else {
            Line lastLine = this.lines.get(index);
            lastLine.getAlignedElements(element.getAlignment()).add(element);
        }
    }

    @Override
    @Deprecated
    public IElementHelper getElementHelper() {
        return IElementHelper.get();
    }

    @Override
    public int size() {
        return this.lines.size();
    }

    @Override
    public void add(int index, IElement element) {
        if (element.getTag() == null) {
            element.tag(ElementHelper.INSTANCE.currentUid());
        }
        Line line = new Line();
        line.getAlignedElements(element.getAlignment()).add(element);
        this.lines.add(index, line);
    }

    @Override
    public List<IElement> get(class_2960 tag) {
        ArrayList elements = Lists.newArrayList();
        for (Line line : this.lines) {
            line.left.stream().filter(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag())).forEach(elements::add);
            line.right.stream().filter(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag())).forEach(elements::add);
        }
        return elements;
    }

    @Override
    public List<IElement> get(int index, IElement.Align align) {
        Line line = this.lines.get(index);
        return line.getAlignedElements(align);
    }

    @Override
    public void remove(class_2960 tag) {
        Iterator<Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Line line = iterator.next();
            line.left.removeIf(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag()));
            line.right.removeIf(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag()));
            if (!line.left.isEmpty() || !line.right.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Override
    public String getMessage() {
        ArrayList msgs = Lists.newArrayList();
        for (Line line : this.lines) {
            msgs.add(Joiner.on((char)' ').join(Stream.concat(line.left.stream(), line.right.stream()).filter(e -> !Identifiers.CORE_MOD_NAME.equals((Object)e.getTag())).map(IElement::getCachedMessage).filter(Objects::nonNull).toList()));
        }
        return Joiner.on((char)'\n').join((Iterable)msgs);
    }

    @Override
    public void setLineMargin(int index, Direction2D side, int margin) {
        if (index < 0) {
            index += this.lines.size();
        }
        Line line = this.lines.get(index);
        switch (side) {
            case UP: {
                line.marginTop = margin;
                break;
            }
            case DOWN: {
                line.marginBottom = margin;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only TOP and BOTTOM are allowed.");
            }
        }
    }

    public static class Line {
        private final List<IElement> left = new ArrayList<IElement>();
        private final List<IElement> right = new ArrayList<IElement>(0);
        public int marginTop = 0;
        public int marginBottom = 2;
        private class_241 size;

        public List<IElement> getAlignedElements(IElement.Align align) {
            return align == IElement.Align.LEFT ? this.left : this.right;
        }

        public class_241 getSize() {
            if (this.size == null) {
                class_241 elementSize;
                float width = 0.0f;
                float height = 0.0f;
                for (IElement element : this.left) {
                    elementSize = element.getCachedSize();
                    width += elementSize.field_1343;
                    height = Math.max(height, elementSize.field_1342);
                }
                for (IElement element : this.right) {
                    elementSize = element.getCachedSize();
                    width += elementSize.field_1343;
                    height = Math.max(height, elementSize.field_1342);
                }
                this.size = new class_241(width, height);
            }
            return this.size;
        }

        public void render(class_332 guiGraphics, float x, float y, float maxWidth, float maxHeight) {
            class_241 size;
            class_241 translate;
            IElement element;
            int i;
            float ox = maxWidth;
            for (i = this.right.size() - 1; i >= 0; --i) {
                element = this.right.get(i);
                translate = element.getTranslation();
                size = element.getCachedSize();
                Tooltip.drawDebugBorder(guiGraphics, ox -= size.field_1343, y, element);
                element.render(guiGraphics, ox + translate.field_1343, y + translate.field_1342, x + size.field_1343 + translate.field_1343, y + maxHeight + translate.field_1342);
            }
            maxWidth = ox;
            ox = x;
            for (i = 0; i < this.left.size(); ++i) {
                element = this.left.get(i);
                translate = element.getTranslation();
                size = element.getCachedSize();
                Tooltip.drawDebugBorder(guiGraphics, ox, y, element);
                element.render(guiGraphics, ox + translate.field_1343, y + translate.field_1342, (i == this.left.size() - 1 ? maxWidth : ox + size.field_1343) + translate.field_1343, y + maxHeight + translate.field_1342);
                ox += size.field_1343;
            }
        }
    }
}

