/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ExplorersCompassConfig;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.PlayerUtils;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3481;
import net.minecraft.server.MinecraftServer;

public class TeleportPacket
extends class_2540 {
    public static final class_2960 ID = new class_2960("explorerscompass", "teleport");

    public TeleportPacket() {
        super(Unpooled.buffer());
    }

    public static void apply(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        server.execute(() -> {
            class_1799 stack = ItemUtils.getHeldItem((class_1657)player, ExplorersCompass.EXPLORERS_COMPASS_ITEM);
            if (!stack.method_7960()) {
                ExplorersCompassItem explorersCompass = (ExplorersCompassItem)stack.method_7909();
                if (ExplorersCompassConfig.allowTeleport && PlayerUtils.canTeleport((class_1657)player)) {
                    if (explorersCompass.getState(stack) == CompassState.FOUND) {
                        int x = explorersCompass.getFoundStructureX(stack);
                        int z = explorersCompass.getFoundStructureZ(stack);
                        int y = TeleportPacket.findValidTeleportHeight(player.method_5770(), x, z);
                        player.method_5848();
                        player.field_13987.method_14360((double)x, (double)y, (double)z, player.method_36454(), player.method_36455(), Collections.emptySet());
                        if (!player.method_6128()) {
                            player.method_18800(player.method_18798().method_10216(), 0.0, player.method_18798().method_10215());
                            player.method_24830(true);
                        }
                    }
                } else {
                    ExplorersCompass.LOGGER.warn("Player " + player.method_5476().getString() + " tried to teleport but does not have permission.");
                }
            }
        });
    }

    private static int findValidTeleportHeight(class_1937 world, int x, int z) {
        int upY = world.method_8615();
        int downY = world.method_8615();
        while (!(world.method_31601(upY) && world.method_31601(downY) || TeleportPacket.isValidTeleportPosition(world, new class_2338(x, upY, z)) || TeleportPacket.isValidTeleportPosition(world, new class_2338(x, downY, z)))) {
            ++upY;
            --downY;
        }
        class_2338 upPos = new class_2338(x, upY, z);
        class_2338 downPos = new class_2338(x, downY, z);
        if (TeleportPacket.isValidTeleportPosition(world, upPos)) {
            return upY;
        }
        if (TeleportPacket.isValidTeleportPosition(world, downPos)) {
            return downY;
        }
        return 256;
    }

    private static boolean isValidTeleportPosition(class_1937 world, class_2338 pos) {
        return TeleportPacket.isFree(world, pos) && TeleportPacket.isFree(world, pos.method_10084()) && !TeleportPacket.isFree(world, pos.method_10074());
    }

    private static boolean isFree(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26215() || world.method_8320(pos).method_26164(class_3481.field_21952) || world.method_8320(pos).method_51176() || world.method_8320(pos).method_45474();
    }
}

