/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.jamalam360.jamlib.JamLib;
import java.awt.Color;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6379;

public abstract class JamLibConfig {
    private static final Map<String, Class<?>> configClass = new HashMap();
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?\\d*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#\\da-fA-F]*)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    private static final Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).setPrettyPrinting().create();
    private static Path path;

    public static void init(String modid, Class<?> config) {
        path = FabricLoader.getInstance().getConfigDir().resolve(modid + ".json");
        configClass.put(modid, config);
        JamLib.LOGGER.info("Registered config for", modid);
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo();
            if (field.isAnnotationPresent(Entry.class) && !field.isAnnotationPresent(Server.class) && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                JamLibConfig.initClient(modid, field, info);
            }
            if (!field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), config);
        }
        catch (Exception e) {
            JamLibConfig.write(modid);
        }
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.value.toString();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void initClient(String modid, Field field, EntryInfo info) {
        Class<?> type = field.getType();
        Entry e = field.getAnnotation(Entry.class);
        info.width = e != null ? e.width() : 0;
        info.field = field;
        info.id = modid;
        if (e != null) {
            if (!e.name().equals("")) {
                info.name = class_2561.method_43471((String)e.name());
            }
            if (type == Integer.TYPE) {
                JamLibConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (type == Float.TYPE) {
                JamLibConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (type == Double.TYPE) {
                JamLibConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (type == String.class || type == List.class) {
                info.max = e.max() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)e.max();
                JamLibConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (type == Boolean.TYPE) {
                Function<Object, class_2561> func = value -> class_2561.method_43470((String)((Boolean)value != false ? "True" : "False")).method_27692((Boolean)value != false ? class_124.field_1060 : class_124.field_1061);
                info.widget = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            } else if (type.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, class_2561> func = value -> {
                    String translationKey = modid + ".jamlibconfig.enum." + type.getSimpleName() + "." + info.value.toString();
                    if (class_1074.method_4663((String)translationKey)) {
                        return class_2561.method_43471((String)translationKey);
                    }
                    return class_2561.method_43470((String)info.value.toString());
                };
                info.widget = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            }
        }
        entries.add(info);
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                value = (Number)f.apply((String)s);
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<class_342, class_5250>((class_342)t, class_2561.method_43470((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))));
            }
            info.tempValue = s;
            t.method_1868(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.field_22763 = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits && info.field.getType() != List.class) {
                info.value = isNumber ? value : s;
            } else if (inLimits) {
                if (((List)info.value).size() == info.index) {
                    ((List)info.value).add("");
                }
                ((List)info.value).set(info.index, Arrays.stream(info.tempValue.replace("[", "").replace("]", "").split(", ")).toList().get(0));
            }
            if (info.field.getAnnotation(Entry.class).isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.colorButton.method_25355((class_2561)class_2561.method_43470((String)"\u2b1b").method_10862(class_2583.field_24360.method_36139(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static void write(String modid) {
        path = FabricLoader.getInstance().getConfigDir().resolve(modid + ".json");
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson(configClass.get(modid).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class_437 getScreen(class_437 parent, String modid) {
        return new MidnightConfigScreen(parent, modid);
    }

    protected static class EntryInfo {
        Field field;
        Object widget;
        int width;
        int max;
        Map.Entry<class_342, class_2561> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;
        String id;
        class_2561 name;
        int index;
        class_339 colorButton;

        protected EntryInfo() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 100;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public boolean isColor() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Environment(value=EnvType.CLIENT)
    private static class MidnightConfigScreen
    extends class_437 {
        private final String translationPrefix;
        private final class_437 parent;
        private final String modid;
        private MidnightConfigListWidget list;
        private boolean reload = false;

        protected MidnightConfigScreen(class_437 parent, String modid) {
            super(MidnightConfigScreen.getConfigScreenTitle(modid));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".jamlibconfig.";
        }

        private static class_2561 getConfigScreenTitle(String modid) {
            if (class_1074.method_4663((String)(modid + ".jamlibconfig.title"))) {
                return class_2561.method_43471((String)(modid + ".jamlibconfig.title"));
            }
            return class_2561.method_43470((String)((ModContainer)FabricLoader.getInstance().getModContainer(modid).get()).getMetadata().getName());
        }

        public void method_25393() {
            super.method_25393();
            for (EntryInfo info : entries) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }

        private void loadValues() {
            try {
                gson.fromJson((Reader)Files.newBufferedReader(path), configClass.get(this.modid));
            }
            catch (Exception e) {
                JamLibConfig.write(this.modid);
            }
            for (EntryInfo info : entries) {
                if (!info.field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.value.toString();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }

        protected void method_25426() {
            super.method_25426();
            if (!this.reload) {
                this.loadValues();
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> {
                this.loadValues();
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }).method_46433(this.field_22789 / 2 - 154, this.field_22790 - 28).method_46437(150, 20).method_46431());
            class_4185 done = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
                for (EntryInfo info : entries) {
                    if (!info.id.equals(this.modid)) continue;
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                JamLibConfig.write(this.modid);
                Objects.requireNonNull(this.field_22787).method_1507(this.parent);
            }).method_46433(this.field_22789 / 2 + 4, this.field_22790 - 28).method_46437(150, 20).method_46431());
            this.list = new MidnightConfigListWidget(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
            if (this.field_22787 != null && this.field_22787.field_1687 != null) {
                this.list.method_31322(false);
            }
            this.method_25429((class_364)this.list);
            for (EntryInfo info : entries) {
                Predicate processor;
                Map.Entry widget;
                if (!info.id.equals(this.modid)) continue;
                class_2561 name = Objects.requireNonNullElseGet(info.name, () -> class_2561.method_43471((String)(this.translationPrefix + info.field.getName())));
                class_4185 resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset").method_27692(class_124.field_1061), button -> {
                    info.value = info.defaultValue;
                    info.tempValue = info.defaultValue.toString();
                    info.index = 0;
                    double scrollAmount = this.list.method_25341();
                    this.reload = true;
                    Objects.requireNonNull(this.field_22787).method_1507((class_437)this);
                    this.list.method_25307(scrollAmount);
                }).method_46437(40, 20).method_46433(this.field_22789 - 205, 0).method_46431();
                if (info.widget instanceof Map.Entry) {
                    widget = (Map.Entry)info.widget;
                    if (info.field.getType().isEnum()) {
                        widget.setValue(value -> class_2561.method_43471((String)(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString())));
                    }
                    this.list.addButton(List.of(class_4185.method_46430((class_2561)((class_2561)((Function)widget.getValue()).apply(info.value)), (class_4185.class_4241)((class_4185.class_4241)widget.getKey())).method_46433(this.field_22789 - 160, 0).method_46437(150, 20).method_46431()), name);
                    continue;
                }
                if (info.field.getType() == List.class) {
                    if (!this.reload) {
                        info.index = 0;
                    }
                    widget = new class_342(this.field_22793, this.field_22789 - 160, 0, 150, 20, null);
                    widget.method_1880(info.width);
                    if (info.index < ((List)info.value).size()) {
                        widget.method_1852(String.valueOf(((List)info.value).get(info.index)));
                    } else {
                        widget.method_1852("");
                    }
                    processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.method_1890(processor);
                    resetButton.method_25358(20);
                    resetButton.method_25355((class_2561)class_2561.method_43470((String)"R").method_27692(class_124.field_1061));
                    class_4185 cycleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(info.index)).method_27692(class_124.field_1065), button -> {
                        ((List)info.value).remove("");
                        double scrollAmount = this.list.method_25341();
                        this.reload = true;
                        ++info.index;
                        if (info.index > ((List)info.value).size()) {
                            info.index = 0;
                        }
                        Objects.requireNonNull(this.field_22787).method_1507((class_437)this);
                        this.list.method_25307(scrollAmount);
                    }).method_46433(this.field_22789 - 185, 0).method_46437(20, 20).method_46431();
                    this.list.addButton(List.of(widget, resetButton, cycleButton), name);
                    continue;
                }
                if (info.widget != null) {
                    widget = new class_342(this.field_22793, this.field_22789 - 160, 0, 150, 20, null);
                    widget.method_1880(info.width);
                    widget.method_1852(info.tempValue);
                    processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.method_1890(processor);
                    if (info.field.getAnnotation(Entry.class).isColor()) {
                        resetButton.method_25358(20);
                        resetButton.method_25355((class_2561)class_2561.method_43470((String)"R").method_27692(class_124.field_1061));
                        class_4185 colorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b1b"), button -> {}).method_46433(this.field_22789 - 185, 0).method_46437(20, 20).method_46431();
                        try {
                            colorButton.method_25355((class_2561)class_2561.method_43470((String)"\u2b1b").method_10862(class_2583.field_24360.method_36139(Color.decode(info.tempValue).getRGB())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        info.colorButton = colorButton;
                        this.list.addButton(List.of(widget, colorButton, resetButton), name);
                        continue;
                    }
                    this.list.addButton(List.of(widget, resetButton), name);
                    continue;
                }
                this.list.addButton(List.of(), name);
            }
        }

        public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
            this.method_25420(ctx, mouseX, mouseY, delta);
            this.list.method_25394(ctx, mouseX, mouseY, delta);
            ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
            for (EntryInfo info : entries) {
                if (!info.id.equals(this.modid) || !this.list.getHoveredButton(mouseX, mouseY).isPresent()) continue;
                class_339 buttonWidget = this.list.getHoveredButton(mouseX, mouseY).get();
                class_2561 text = ButtonEntry.buttonsWithText.get(buttonWidget);
                class_5250 name = class_2561.method_43471((String)(this.translationPrefix + info.field.getName()));
                String key = this.translationPrefix + info.field.getName() + ".tooltip";
                if (info.error != null && text.equals(name)) {
                    ctx.method_51438(class_310.method_1551().field_1772, info.error.getValue(), mouseX, mouseY);
                    continue;
                }
                if (!class_1074.method_4663((String)key) || !text.equals(name)) continue;
                ArrayList<class_5250> list = new ArrayList<class_5250>();
                for (String str : class_1074.method_4662((String)key, (Object[])new Object[0]).split("\n")) {
                    list.add(class_2561.method_43470((String)str));
                }
                ctx.method_51434(class_310.method_1551().field_1772, list, mouseX, mouseY);
            }
            super.method_25394(ctx, mouseX, mouseY, delta);
        }
    }

    private static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        private HiddenAnnotationExclusionStrategy() {
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    private static class ButtonEntry
    extends class_4265.class_4266<ButtonEntry> {
        public static final Map<class_339, class_2561> buttonsWithText = new HashMap<class_339, class_2561>();
        private static final class_327 textRenderer = class_310.method_1551().field_1772;
        public final List<class_339> buttons;
        private final class_2561 text;
        private final List<class_339> children = new ArrayList<class_339>();

        private ButtonEntry(List<class_339> buttons, class_2561 text) {
            if (!buttons.isEmpty()) {
                buttonsWithText.put(buttons.get(0), text);
            }
            this.buttons = buttons;
            this.text = text;
            this.children.addAll(buttons);
        }

        public static ButtonEntry create(List<class_339> buttons, class_2561 text) {
            return new ButtonEntry(buttons, text);
        }

        public void method_25343(class_332 ctx, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.method_46419(y);
                b.method_25394(ctx, mouseX, mouseY, tickDelta);
            });
            if (!(this.text == null || this.text.getString().contains("spacer") && this.buttons.isEmpty())) {
                ctx.method_27535(textRenderer, this.text, 12, y + 5, 0xFFFFFF);
            }
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class MidnightConfigListWidget
    extends class_4265<ButtonEntry> {
        class_327 textRenderer;

        public MidnightConfigListWidget(class_310 minecraftClient, int i, int j, int k, int l, int m) {
            super(minecraftClient, i, j, k, l, m);
            this.field_22744 = false;
            this.textRenderer = minecraftClient.field_1772;
        }

        public int method_25329() {
            return this.field_22742 - 7;
        }

        public void addButton(List<class_339> buttons, class_2561 text) {
            this.method_25321((class_350.class_351)ButtonEntry.create(buttons, text));
        }

        public int method_25322() {
            return 10000;
        }

        public Optional<class_339> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.method_25396()) {
                if (buttonEntry.buttons.isEmpty() || !buttonEntry.buttons.get(0).method_25405(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.buttons.get(0));
            }
            return Optional.empty();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }
}

