/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.UUID;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EditWaystoneMessage {
    private final UUID waystoneUid;
    private final String name;
    private final boolean isGlobal;

    public EditWaystoneMessage(UUID waystoneUid, String name, boolean isGlobal) {
        this.waystoneUid = waystoneUid;
        this.name = name;
        this.isGlobal = isGlobal;
    }

    public static void encode(EditWaystoneMessage message, class_2540 buf) {
        buf.method_10797(message.waystoneUid);
        buf.method_10814(message.name);
        buf.method_52964(message.isGlobal);
    }

    public static EditWaystoneMessage decode(class_2540 buf) {
        UUID waystoneUid = buf.method_10790();
        String name = buf.method_10800(255);
        boolean isGlobal = buf.readBoolean();
        return new EditWaystoneMessage(waystoneUid, name, isGlobal);
    }

    public static void handle(class_3222 player, EditWaystoneMessage message) {
        WaystoneProxy waystone = new WaystoneProxy(player.field_13995, message.waystoneUid);
        WaystoneEditPermissions permissions = PlayerWaystoneManager.mayEditWaystone((class_1657)player, player.method_37908(), waystone);
        if (permissions != WaystoneEditPermissions.ALLOW) {
            return;
        }
        class_2338 pos = waystone.getPos();
        if (player.method_5649((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f)) > 64.0) {
            return;
        }
        Waystone backingWaystone = (Waystone)waystone.getBackingWaystone();
        String legalName = EditWaystoneMessage.makeNameLegal(player.field_13995, message.name);
        backingWaystone.setName(legalName);
        if (PlayerWaystoneManager.mayEditGlobalWaystones((class_1657)player)) {
            if (!backingWaystone.isGlobal() && message.isGlobal) {
                PlayerWaystoneManager.activeWaystoneForEveryone(player.field_13995, backingWaystone);
            }
            backingWaystone.setGlobal(message.isGlobal);
        }
        WaystoneManager.get(player.field_13995).method_80();
        WaystoneSyncManager.sendWaystoneUpdateToAll(player.field_13995, backingWaystone);
        player.method_7346();
    }

    private static String makeNameLegal(MinecraftServer server, String name) {
        String inventoryButtonMode = WaystonesConfig.getActive().inventoryButton.inventoryButton;
        if (inventoryButtonMode.equals(name) && WaystoneManager.get(server).findWaystoneByName(name).isPresent()) {
            return name + "*";
        }
        return name;
    }
}

