/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import com.google.common.base.Preconditions;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.client.registry.display.DisplaysHolder;
import me.shedaniel.rei.impl.client.registry.display.DisplaysHolderImpl;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.registry.RecipeManagerContextImpl;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class DisplayRegistryImpl
extends RecipeManagerContextImpl<REIClientPlugin>
implements DisplayRegistry {
    private final Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> displayGenerators = new ConcurrentHashMap();
    private final List<DynamicDisplayGenerator<?>> globalDisplayGenerators = new ArrayList();
    private final List<DisplayVisibilityPredicate> visibilityPredicates = new ArrayList<DisplayVisibilityPredicate>();
    private final List<DisplayFiller<?>> fillers = new ArrayList();
    private long lastAddWarning = -1L;
    private DisplaysHolder displaysHolder = new DisplaysHolderImpl(false);

    public DisplayRegistryImpl() {
        super(RecipeManagerContextImpl.supplier());
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerDisplays(this);
    }

    @Override
    public int displaySize() {
        return this.displaysHolder.size();
    }

    @Override
    public void add(Display display, @Nullable Object origin) {
        if (!PluginManager.areAnyReloading()) {
            if (this.lastAddWarning < 0L || System.currentTimeMillis() - this.lastAddWarning > 5000L) {
                InternalLogger.getInstance().warn("Detected runtime DisplayRegistry modification, this can be extremely dangerous!");
                InternalLogger.getInstance().debug("Detected runtime DisplayRegistry modification, this can be extremely dangerous!", new Throwable());
            }
            this.lastAddWarning = System.currentTimeMillis();
        }
        this.displaysHolder.add(display, origin);
    }

    @Override
    public Map<CategoryIdentifier<?>, List<Display>> getAll() {
        return this.displaysHolder.get();
    }

    @Override
    public <A extends Display> void registerGlobalDisplayGenerator(DynamicDisplayGenerator<A> generator) {
        this.globalDisplayGenerators.add(generator);
        InternalLogger.getInstance().debug("Added global display generator: %s", generator);
    }

    @Override
    public <A extends Display> void registerDisplayGenerator(CategoryIdentifier<A> categoryId, DynamicDisplayGenerator<A> generator) {
        this.displayGenerators.computeIfAbsent(categoryId, location -> new ArrayList()).add(generator);
        InternalLogger.getInstance().debug("Added display generator for category [%s]: %s", categoryId, generator);
    }

    @Override
    public Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> getCategoryDisplayGenerators() {
        return Collections.unmodifiableMap(this.displayGenerators);
    }

    @Override
    public List<DynamicDisplayGenerator<?>> getGlobalDisplayGenerators() {
        return Collections.unmodifiableList(this.globalDisplayGenerators);
    }

    @Override
    public void registerVisibilityPredicate(DisplayVisibilityPredicate predicate) {
        this.visibilityPredicates.add(predicate);
        this.visibilityPredicates.sort(Comparator.reverseOrder());
        InternalLogger.getInstance().debug("Added display visibility predicate: %s [%.2f priority]", predicate, predicate.getPriority());
    }

    @Override
    public boolean isDisplayVisible(Display display) {
        DisplayCategory<?> category = CategoryRegistry.getInstance().get(display.getCategoryIdentifier()).getCategory();
        Preconditions.checkNotNull(category, (Object)("Failed to resolve category: " + display.getCategoryIdentifier()));
        for (DisplayVisibilityPredicate predicate : this.visibilityPredicates) {
            try {
                EventResult result = predicate.handleDisplay(category, display);
                if (!result.interruptsFurtherEvaluation()) continue;
                return result.isEmpty() || result.isTrue();
            }
            catch (Throwable throwable) {
                InternalLogger.getInstance().error("Failed to check if the display is visible!", throwable);
            }
        }
        return true;
    }

    @Override
    public List<DisplayVisibilityPredicate> getVisibilityPredicates() {
        return Collections.unmodifiableList(this.visibilityPredicates);
    }

    @Override
    public <T, D extends Display> void registerFiller(Class<T> typeClass, Predicate<? extends T> predicate, Function<? extends T, D> filler) {
        this.registerFiller((? o) -> typeClass.isInstance(o) && predicate.test(o), (? o) -> (Display)filler.apply(o));
    }

    @Override
    public <T, D extends Display> void registerFiller(Class<T> typeClass, BiPredicate<? extends T, DisplayAdditionReasons> predicate, Function<? extends T, D> filler) {
        this.fillers.add(new DisplayFiller<D>((o, s) -> typeClass.isInstance(o) && predicate.test((Object)o, (DisplayAdditionReasons)s), filler));
        InternalLogger.getInstance().debug("Added display filter: %s for %s", filler, typeClass.getName());
    }

    @Override
    public <D extends Display> void registerFiller(Predicate<?> predicate, Function<?, D> filler) {
        this.fillers.add(new DisplayFiller<D>((o, s) -> predicate.test(o), filler));
        InternalLogger.getInstance().debug("Added display filter: %s", filler);
    }

    @Override
    public void startReload() {
        super.startReload();
        this.displaysHolder = new DisplaysHolderImpl(true);
        this.displayGenerators.clear();
        this.visibilityPredicates.clear();
        this.fillers.clear();
    }

    @Override
    public void endReload() {
        if (!this.fillers.isEmpty()) {
            List<class_8786<?>> allSortedRecipes = this.getAllSortedRecipes();
            for (int i = allSortedRecipes.size() - 1; i >= 0; --i) {
                class_8786<?> recipe = allSortedRecipes.get(i);
                this.addWithReason(recipe, DisplayAdditionReason.RECIPE_MANAGER);
            }
        }
        for (CategoryIdentifier<?> identifier : this.getAll().keySet()) {
            if (!CategoryRegistry.getInstance().tryGet(identifier).isEmpty()) continue;
            InternalLogger.getInstance().error("Found displays registered for unknown registry", new IllegalStateException(identifier.toString()));
        }
        this.displaysHolder.endReload();
        InternalLogger.getInstance().debug("Registered %d displays", this.displaySize());
    }

    public DisplaysHolder displaysHolder() {
        return this.displaysHolder;
    }

    @Override
    public <T> Collection<Display> tryFillDisplay(T value, DisplayAdditionReason ... reason) {
        if (value instanceof Display) {
            return Collections.singleton((Display)value);
        }
        List<?> displays = null;
        DisplayAdditionReasons.Impl reasons = reason.length == 0 ? DisplayAdditionReasons.Impl.EMPTY : new DisplayAdditionReasons.Impl(reason);
        for (DisplayFiller<?> filler : this.fillers) {
            Object display = this.tryFillDisplayGenerics(filler, value, reasons);
            if (display == null) continue;
            if (displays == null) {
                displays = Collections.singletonList(display);
                continue;
            }
            if (!(displays instanceof ArrayList)) {
                displays = new ArrayList(displays);
            }
            displays.add(display);
        }
        if (displays != null) {
            return displays;
        }
        return Collections.emptyList();
    }

    private <D extends Display> D tryFillDisplayGenerics(DisplayFiller<D> filler, Object value, DisplayAdditionReasons reasons) {
        try {
            if (filler.predicate.test(value, reasons)) {
                return (D)((Display)filler.mappingFunction.apply(value));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to fill displays!", e);
        }
        return null;
    }

    @Override
    @Nullable
    public Object getDisplayOrigin(Display display) {
        return this.displaysHolder.getDisplayOrigin(display);
    }

    private record DisplayFiller<D extends Display>(BiPredicate<Object, DisplayAdditionReasons> predicate, Function<Object, D> mappingFunction) {
    }
}

