/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.model;

import com.supermartijn642.connectedglass.model.CGModelData;
import com.supermartijn642.core.util.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_5819;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7771;
import org.jetbrains.annotations.Nullable;

public class CGBakedModel
extends ForwardingBakedModel {
    private final Map<class_2350, Map<Integer, List<class_777>>> quadCache = new HashMap<class_2350, Map<Integer, List<class_777>>>();
    private final Map<Integer, List<class_777>> directionlessQuadCache = new HashMap<Integer, List<class_777>>();
    private final class_1058 particleSprite;
    private final ThreadLocal<Pair<class_1920, class_2338>> levelCapture = new ThreadLocal();

    public CGBakedModel(class_1087 original) {
        this.wrapped = original;
        for (class_2350 direction : class_2350.values()) {
            this.quadCache.put(direction, new HashMap());
        }
        this.particleSprite = new CroppedTextureAtlasSprite(original.method_4711());
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.levelCapture.set((Pair<class_1920, class_2338>)Pair.of((Object)blockView, (Object)pos));
        context.bakedModelConsumer().accept((class_1087)this, state);
        this.levelCapture.set(null);
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.bakedModelConsumer().accept((class_1087)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 rand) {
        List<class_777> quads;
        Map<Integer, List<class_777>> cache;
        CGModelData data = this.levelCapture.get() == null ? null : this.getModelData((class_1920)this.levelCapture.get().left(), (class_2338)this.levelCapture.get().right(), state);
        int hashCode = data == null ? 0 : data.hashCode();
        Map<Integer, List<class_777>> map = cache = side == null ? this.directionlessQuadCache : this.quadCache.get(side);
        synchronized (map) {
            quads = cache.get(hashCode);
        }
        if (quads == null) {
            quads = this.remapQuads(this.wrapped.method_4707(state, side, rand), data);
            map = cache;
            synchronized (map) {
                if (!cache.containsKey(hashCode)) {
                    cache.put(hashCode, quads);
                } else {
                    quads = cache.get(hashCode);
                }
            }
        }
        if (quads == null) {
            throw new IllegalStateException("Tried returning null list from ConnectingBakedModel#getQuads for side '" + side + "'!");
        }
        return quads;
    }

    private List<class_777> remapQuads(List<class_777> originalQuads, CGModelData modelData) {
        return originalQuads.stream().map(quad -> this.remapQuad((class_777)quad, modelData)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected class_777 remapQuad(class_777 quad, CGModelData modelData) {
        int[] vertexData = quad.method_3357();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        CGBakedModel.adjustVertexDataUV(vertexData, 0, 0, quad.method_35788(), class_290.field_1590);
        return new class_777(vertexData, quad.method_3359(), quad.method_3358(), quad.method_35788(), quad.method_24874());
    }

    public static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, class_1058 sprite, class_293 vertexFormat) {
        int vertexSize = vertexFormat.method_1359();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = CGBakedModel.findUVOffset(vertexFormat) / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.method_4577() - sprite.method_4594();
            float u = ((float)newU + (Float.intBitsToFloat(vertexData[offset]) - sprite.method_4594()) / width) / 8.0f;
            vertexData[offset] = Float.floatToRawIntBits(sprite.method_4580(u));
            float height = sprite.method_4575() - sprite.method_4593();
            float v = ((float)newV + (Float.intBitsToFloat(vertexData[offset + 1]) - sprite.method_4593()) / height) / 8.0f;
            vertexData[offset + 1] = Float.floatToRawIntBits(sprite.method_4570(v));
        }
        return vertexData;
    }

    private static int findUVOffset(class_293 vertexFormat) {
        int index;
        class_296 element = null;
        for (index = 0; index < vertexFormat.method_1357().size(); ++index) {
            class_296 el = (class_296)vertexFormat.method_1357().get(index);
            if (el.method_1382() != class_296.class_298.field_1636) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.method_1357().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a UV attribute");
        }
        if (element.method_1386() != class_296.class_297.field_1623) {
            throw new RuntimeException("Expected UV attribute to have data type FLOAT");
        }
        if (element.method_1387() < 4) {
            throw new RuntimeException("Expected UV attribute to have at least 4 dimensions");
        }
        return vertexFormat.field_1597.getInt(index);
    }

    public CGModelData getModelData(class_1920 level, class_2338 pos, class_2680 state) {
        return null;
    }

    public class_1058 method_4711() {
        return this.particleSprite;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    private static class CroppedTextureAtlasSprite
    extends class_1058 {
        protected CroppedTextureAtlasSprite(class_1058 original) {
            super(original.method_45852(), new class_7764(original.method_45851().method_45816(), new class_7771(original.method_45851().method_45807() / 8, original.method_45851().method_45815() / 8), new class_1011(original.method_45851().method_45807() / 8, original.method_45851().method_45815() / 8, false), class_7368.field_38688), Math.round((float)original.method_35806() / original.method_4594()), Math.round((float)original.method_35807() / original.method_4593()), original.method_35806(), original.method_35807());
        }
    }
}

