/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.utils;

import com.google.common.base.Stopwatch;
import gg.mantle.mod.MantleConstants;
import gg.mantle.mod.client.Mantle;
import gg.mantle.mod.client.MantleClientConstants;
import gg.mantle.mod.utils.TesterEnvironment;
import gg.mantle.mod.utils.UtilsKt;
import java.io.File;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\r\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u000eJ%\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\nJ\u001d\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\u000eJ%\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0011J\u001d\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u001d\u0010\u0018\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0018\u0010\u000eJ%\u0010\u0018\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0011J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u0003J\u001b\u0010\u001c\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001c\u0010 \u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010%\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001c\u0010\f\u001a\n \u001f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010)R!\u0010.\u001a\u00020\"8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010+\u0012\u0004\b-\u0010\u0003\u001a\u0004\b,\u0010$\u00a8\u0006/"}, d2={"Lgg/mantle/mod/utils/TesterEnvironment;", "", "<init>", "()V", "", "cleanTesterLogs", "initialize", "", "message", "print", "(Ljava/lang/String;)V", "Lorg/apache/logging/log4j/Logger;", "logger", "printAndError", "(Lorg/apache/logging/log4j/Logger;Ljava/lang/String;)V", "", "t", "(Lorg/apache/logging/log4j/Logger;Ljava/lang/String;Ljava/lang/Throwable;)V", "printAndInfo", "printAndWarn", "printClean", "printIfTester", "printIfTesterAndError", "printIfTesterAndInfo", "printIfTesterAndWarn", "printTestInfo", "Lkotlin/Function0;", "block", "runIfTester", "(Lkotlin/jvm/functions/Function0;)V", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "Ljava/io/File;", "getDirectory", "()Ljava/io/File;", "directory", "", "initialized", "Z", "Lorg/apache/logging/log4j/Logger;", "testerLogFile$delegate", "Lkotlin/Lazy;", "getTesterLogFile", "getTesterLogFile$annotations", "testerLogFile", "Mantle"})
@SourceDebugExtension(value={"SMAP\nTesterEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TesterEnvironment.kt\ngg/mantle/mod/utils/TesterEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1855#2,2:162\n*S KotlinDebug\n*F\n+ 1 TesterEnvironment.kt\ngg/mantle/mod/utils/TesterEnvironment\n*L\n155#1:162,2\n*E\n"})
public final class TesterEnvironment {
    @NotNull
    public static final TesterEnvironment INSTANCE = new TesterEnvironment();
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss");
    private static final Logger logger = LogManager.getLogger((String)"Mantle Tester Environment");
    private static boolean initialized;
    @NotNull
    private static final Lazy testerLogFile$delegate;

    private TesterEnvironment() {
    }

    private final File getDirectory() {
        File dir = new File(MantleConstants.getModDirectory(), "Logs");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Could not create logs directory!".toString());
        }
        return dir;
    }

    @NotNull
    public static final File getTesterLogFile() {
        Lazy lazy = testerLogFile$delegate;
        return (File)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getTesterLogFile$annotations() {
    }

    public final void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (!MantleConstants.getTesterMode()) {
            logger.info("Tester environment not enabled!");
            return;
        }
        this.cleanTesterLogs();
        this.printTestInfo();
    }

    private final void cleanTesterLogs() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Cleaning tester logs...");
        File[] files = this.getDirectory().listFiles();
        if (files != null) {
            for (File file : files) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (!StringsKt.startsWith$default((String)FilesKt.getNameWithoutExtension((File)file), (String)"mantle-tester-", (boolean)false, (int)2, null) || file.lastModified() >= OffsetDateTime.now().minusDays(3L).toInstant().toEpochMilli()) continue;
                if (file.delete()) {
                    logger.info("Deleted old tester log file: " + file.getName());
                    continue;
                }
                logger.warn("Could not delete old tester log file: " + file.getName());
            }
        }
        Stopwatch stopwatch2 = stopwatch.stop();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch2, (String)"stopwatch.stop()");
        logger.info("Tester logs cleaned in " + gg.mantle.mod.client.utils.UtilsKt.asMillis(stopwatch2) + "ms!");
    }

    public final void runIfTester(@NotNull Function0<Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        if (MantleConstants.getTesterMode()) {
            block2.invoke();
        }
    }

    public final void printClean(@NotNull String message) {
        File file;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        File $this$printClean_u24lambda_u240 = file = TesterEnvironment.getTesterLogFile();
        boolean bl = false;
        if (!$this$printClean_u24lambda_u240.exists()) {
            $this$printClean_u24lambda_u240.createNewFile();
        }
        FilesKt.appendText$default((File)file, (String)(message + "\n"), null, (int)2, null);
    }

    public final void print(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.printClean("[" + OffsetDateTime.now().format(dateTimeFormatter) + "] " + message);
    }

    public final void printIfTester(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.runIfTester((Function0<Unit>)((Function0)new Function0<Unit>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                TesterEnvironment.INSTANCE.print(this.$message);
            }
        }));
    }

    public final void printAndInfo(@NotNull Logger logger, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.print(message);
        logger.info(message);
    }

    public final void printIfTesterAndInfo(@NotNull Logger logger, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.runIfTester((Function0<Unit>)((Function0)new Function0<Unit>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                TesterEnvironment.INSTANCE.print(this.$message);
            }
        }));
        logger.info(message);
    }

    public final void printAndWarn(@NotNull Logger logger, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.print(message);
        logger.warn(message);
    }

    public final void printAndWarn(@NotNull Logger logger, @NotNull String message, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.print(message);
        logger.warn(message, t);
    }

    public final void printIfTesterAndWarn(@NotNull Logger logger, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.runIfTester((Function0<Unit>)((Function0)new Function0<Unit>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                TesterEnvironment.INSTANCE.print(this.$message);
            }
        }));
        logger.warn(message);
    }

    public final void printIfTesterAndWarn(@NotNull Logger logger, @NotNull String message, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.runIfTester((Function0<Unit>)((Function0)new Function0<Unit>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                TesterEnvironment.INSTANCE.print(this.$message);
            }
        }));
        logger.warn(message, t);
    }

    public final void printAndError(@NotNull Logger logger, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.print(message);
        logger.error(message);
    }

    public final void printAndError(@NotNull Logger logger, @NotNull String message, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.print(message);
        logger.error(message, t);
    }

    public final void printIfTesterAndError(@NotNull Logger logger, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.runIfTester((Function0<Unit>)((Function0)new Function0<Unit>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                TesterEnvironment.INSTANCE.print(this.$message);
            }
        }));
        logger.error(message);
    }

    public final void printIfTesterAndError(@NotNull Logger logger, @NotNull String message, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.runIfTester((Function0<Unit>)((Function0)new Function0<Unit>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            public final void invoke() {
                TesterEnvironment.INSTANCE.print(this.$message);
            }
        }));
        logger.error(message, t);
    }

    public final void printTestInfo() {
        Object[] objectArray;
        Object[] $this$printTestInfo_u24lambda_u241 = objectArray = new StringBuilder();
        boolean bl = false;
        if (MantleConstants.getDebugMode()) {
            $this$printTestInfo_u24lambda_u241.append("Debug M");
        }
        if (MantleConstants.getDebugMode() && MantleConstants.getDevMode()) {
            $this$printTestInfo_u24lambda_u241.append(", ");
        }
        if (MantleConstants.getDevMode()) {
            $this$printTestInfo_u24lambda_u241.append("Dev M");
        }
        if (MantleConstants.getDevMode() && MantleConstants.getTesterMode()) {
            $this$printTestInfo_u24lambda_u241.append(", ");
        }
        if (MantleConstants.getTesterMode()) {
            $this$printTestInfo_u24lambda_u241.append("Tester M");
        }
        boolean isDevEnv = UtilsKt.isDevelopmentEnvironment();
        if (MantleConstants.getTesterMode() && isDevEnv) {
            $this$printTestInfo_u24lambda_u241.append(", ");
        }
        if (isDevEnv) {
            $this$printTestInfo_u24lambda_u241.append("Dev E");
        }
        String string = objectArray.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String environmentModeDetails = string;
        objectArray = new String[]{"Mantle (Mantle, mantlegg v0.10.1 - Minecraft " + UtilsKt.getGameVersion() + ") Tester Environment:", "\u251c\u2500 Minecraft Version: " + UtilsKt.getGameVersion(), "\u251c\u2500 Environment Mode: " + environmentModeDetails, "\u251c\u2500 Local Server URI: " + MantleClientConstants.INSTANCE.getLocalServerUri(), "\u251c\u2500 Local Server Port: " + MantleClientConstants.INSTANCE.getLocalServerPort(), "\u251c\u2500 Mod Directory: " + MantleConstants.getModDirectory().getAbsolutePath(), "\u251c\u2500 Modpack ID: " + UtilsKt.readModpackId(), "\u251c\u2500 Tester Log File: " + TesterEnvironment.getTesterLogFile().getAbsolutePath(), "\u2514\u2500 API Base URL: " + MantleConstants.getBaseUrl()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl2 = false;
            Mantle.getLogger().warn(line);
            INSTANCE.printClean(line);
        }
    }

    public static final /* synthetic */ File access$getDirectory(TesterEnvironment $this) {
        return $this.getDirectory();
    }

    public static final /* synthetic */ DateTimeFormatter access$getDateTimeFormatter$p() {
        return dateTimeFormatter;
    }

    static {
        testerLogFile$delegate = LazyKt.lazy((Function0)testerLogFile.2.INSTANCE);
    }
}

