/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.utils;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001c\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0015\u001a\n \u000b*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00178\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lgg/mantle/mod/utils/SslLoader;", "", "<init>", "()V", "", "finish", "", "path", "load", "(Ljava/lang/String;)V", "Ljava/security/cert/CertificateFactory;", "kotlin.jvm.PlatformType", "certFactory", "Ljava/security/cert/CertificateFactory;", "Ljavax/net/ssl/SSLContext;", "<set-?>", "ctx", "Ljavax/net/ssl/SSLContext;", "getCtx", "()Ljavax/net/ssl/SSLContext;", "Ljava/security/KeyStore;", "keyStore", "Ljava/security/KeyStore;", "Ljavax/net/ssl/X509TrustManager;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "getTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "Mantle"})
@SourceDebugExtension(value={"SMAP\nSslLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SslLoader.kt\ngg/mantle/mod/utils/SslLoader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n1109#2,2:61\n*S KotlinDebug\n*F\n+ 1 SslLoader.kt\ngg/mantle/mod/utils/SslLoader\n*L\n55#1:61,2\n*E\n"})
public final class SslLoader {
    @NotNull
    public static final SslLoader INSTANCE = new SslLoader();
    private static SSLContext ctx;
    private static X509TrustManager trustManager;
    private static final CertificateFactory certFactory;
    private static final KeyStore keyStore;

    private SslLoader() {
    }

    @NotNull
    public final SSLContext getCtx() {
        SSLContext sSLContext = ctx;
        if (sSLContext != null) {
            return sSLContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"ctx");
        return null;
    }

    @NotNull
    public final X509TrustManager getTrustManager() {
        X509TrustManager x509TrustManager = trustManager;
        if (x509TrustManager != null) {
            return x509TrustManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"trustManager");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void load(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream resource = this.getClass().getResourceAsStream(path);
        Throwable throwable = null;
        try {
            BufferedInputStream stream = new BufferedInputStream(resource);
            Certificate cert = certFactory.generateCertificate(stream);
            keyStore.setCertificateEntry(path, cert);
        }
        catch (Exception e) {
            try {
                throwable = e;
                throw e;
            }
            catch (Throwable throwable2) {
                try {
                    InputStream inputStream = resource;
                    if (inputStream == null) throw throwable2;
                    inputStream.close();
                    throw throwable2;
                }
                catch (Exception e2) {
                    Throwable throwable3 = throwable;
                    if (throwable3 == null) throw throwable2;
                    ExceptionsKt.addSuppressed((Throwable)throwable3, (Throwable)e2);
                    throw throwable2;
                }
            }
        }
        try {
            InputStream inputStream = resource;
            if (inputStream == null) return;
            inputStream.close();
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    public final void finish() {
        Object element$iv2;
        block3: {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
            Intrinsics.checkNotNullExpressionValue((Object)sslContext, (String)"sslContext");
            ctx = sslContext;
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"trustManagerFactory.trustManagers");
            Object[] $this$first$iv = trustManagerArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                TrustManager it = (TrustManager)element$iv2;
                boolean bl = false;
                if (!(it instanceof X509TrustManager)) {
                    continue;
                }
                break block3;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        Object object = element$iv2;
        X509TrustManager x509TrustManager = object instanceof X509TrustManager ? (X509TrustManager)object : null;
        if (x509TrustManager == null) {
            throw new IllegalStateException("No X509TrustManager found");
        }
        trustManager = x509TrustManager;
    }

    static {
        certFactory = CertificateFactory.getInstance("X.509");
        keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        String[] stringArray = new String[]{"lib", "security", "cacerts"};
        Path keyStorePath = Paths.get(System.getProperty("java.home"), stringArray);
        keyStore.load(Files.newInputStream(keyStorePath, new OpenOption[0]), null);
    }
}

