/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.user;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.mantle.mod.client.Mantle;
import gg.mantle.mod.client.auth.AuthenticationManager;
import gg.mantle.mod.client.events.WalletUpdateEvent;
import gg.mantle.mod.client.sse.ServerSessionManager;
import gg.mantle.mod.client.sse.SessionSubscription;
import gg.mantle.mod.client.user.UserEntity;
import gg.mantle.mod.client.user.WalletEntity;
import gg.mantle.mod.client.user.WalletManager;
import gg.mantle.mod.utils.JsonKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001b\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lgg/mantle/mod/client/user/WalletManager;", "", "<init>", "()V", "Lgg/mantle/mod/client/user/UserEntity;", "user", "", "attemptUpdateFrom", "(Lgg/mantle/mod/client/user/UserEntity;)V", "Lcom/google/gson/JsonObject;", "json", "Lgg/mantle/mod/client/user/WalletEntity;", "createWallet", "(Lcom/google/gson/JsonObject;)Lgg/mantle/mod/client/user/WalletEntity;", "", "rawJson", "(Ljava/lang/String;)Lgg/mantle/mod/client/user/WalletEntity;", "getWallet", "()Lgg/mantle/mod/client/user/WalletEntity;", "initialize", "Ljava/util/UUID;", "uuid", "subscribeToWalletUpdates", "(Ljava/util/UUID;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wallet", "update", "(Lgg/mantle/mod/client/user/WalletEntity;)V", "updateFromServer", "WALLET_UPDATE_EVENT_NAME", "Ljava/lang/String;", "Lgg/mantle/mod/client/user/WalletEntity;", "Mantle"})
public final class WalletManager {
    @NotNull
    public static final WalletManager INSTANCE = new WalletManager();
    @NotNull
    private static final String WALLET_UPDATE_EVENT_NAME = "user_wallet_update";
    @Nullable
    private static WalletEntity wallet;

    private WalletManager() {
    }

    public final void initialize() {
        AuthenticationManager.INSTANCE.ifOrWhenAuthenticated((Function1<? super String, Unit>)((Function1)initialize.1.INSTANCE));
    }

    public final void update(@NotNull WalletEntity wallet) {
        Intrinsics.checkNotNullParameter((Object)wallet, (String)"wallet");
        WalletManager.wallet = wallet;
        Mantle.getEventBus().post((Object)new WalletUpdateEvent(wallet));
    }

    public final void attemptUpdateFrom(@NotNull UserEntity user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        WalletEntity walletEntity = user.getWallet();
        if (walletEntity == null) {
            return;
        }
        WalletEntity userWallet = walletEntity;
        this.update(userWallet);
    }

    public final void updateFromServer(@NotNull WalletEntity wallet) {
        Intrinsics.checkNotNullParameter((Object)wallet, (String)"wallet");
        this.update(wallet);
    }

    @Nullable
    public final WalletEntity createWallet(@NotNull String rawJson) {
        Intrinsics.checkNotNullParameter((Object)rawJson, (String)"rawJson");
        JsonElement jsonElement = JsonKt.parseJson(rawJson);
        if (!jsonElement.isJsonObject()) {
            return null;
        }
        JsonObject json = jsonElement.getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
        return this.createWallet(json);
    }

    @Nullable
    public final WalletEntity createWallet(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Integer n = JsonKt.maybeGetInteger(json, "gems");
        if (n == null) {
            return null;
        }
        int gems = n;
        return new WalletEntity(gems);
    }

    @NotNull
    public final WalletEntity getWallet() {
        WalletEntity walletEntity = wallet;
        if (walletEntity == null) {
            walletEntity = new WalletEntity(-3);
        }
        return walletEntity;
    }

    private final Object subscribeToWalletUpdates(UUID uuid, Continuation<? super Unit> $completion) {
        Object object = ServerSessionManager.INSTANCE.subscribeTo(SetsKt.setOf((Object)new SessionSubscription(WALLET_UPDATE_EVENT_NAME, SetsKt.setOf((Object)uuid.toString()))), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$subscribeToWalletUpdates(WalletManager $this, UUID uuid, Continuation $completion) {
        return $this.subscribeToWalletUpdates(uuid, (Continuation<? super Unit>)$completion);
    }
}

