/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.gui.components;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.ColorConstraint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.state.ExtensionsKt;
import gg.essential.elementa.state.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0017\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lgg/mantle/mod/client/gui/components/TriangleComponent;", "Lgg/essential/elementa/UIComponent;", "Ljava/awt/Color;", "color", "<init>", "(Ljava/awt/Color;)V", "Lgg/essential/elementa/state/State;", "colorState", "(Lgg/essential/elementa/state/State;)V", "Lgg/essential/elementa/constraints/ColorConstraint;", "colorConstraint", "(Lgg/essential/elementa/constraints/ColorConstraint;)V", "Lgg/essential/universal/UMatrixStack;", "stack", "", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "Mantle"})
public final class TriangleComponent
extends UIComponent {
    public TriangleComponent(@NotNull ColorConstraint colorConstraint) {
        Intrinsics.checkNotNullParameter((Object)colorConstraint, (String)"colorConstraint");
        this.setColor(colorConstraint);
    }

    public /* synthetic */ TriangleComponent(ColorConstraint colorConstraint, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
            colorConstraint = (ColorConstraint)UtilitiesKt.toConstraint((Color)color);
        }
        this(colorConstraint);
    }

    public TriangleComponent(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this((ColorConstraint)UtilitiesKt.toConstraint((Color)color));
    }

    public TriangleComponent(@NotNull State<Color> colorState) {
        Intrinsics.checkNotNullParameter(colorState, (String)"colorState");
        this((ColorConstraint)ExtensionsKt.toConstraint(colorState));
    }

    public void draw(@NotNull UMatrixStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.beforeDrawCompat(stack);
        float x = this.getLeft();
        float y = this.getTop();
        float width = this.getWidth();
        float height = this.getHeight();
        Color color = this.getColor();
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        UGraphics buffer = UGraphics.getFromTessellator();
        buffer.beginWithDefaultShader(UGraphics.DrawMode.TRIANGLES, UGraphics.CommonVertexFormats.POSITION_COLOR);
        buffer.pos(stack, (double)x, (double)(y + height), 0.0).color(r, g, b, a).endVertex();
        buffer.pos(stack, (double)(x + width), (double)(y + height), 0.0).color(r, g, b, a).endVertex();
        buffer.pos(stack, (double)(x + width / (float)2), (double)y, 0.0).color(r, g, b, a).endVertex();
        buffer.drawDirect();
        super.draw(stack);
    }

    public TriangleComponent() {
        this(null, 1, null);
    }
}

