/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.gui.components;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\n\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0018R\u0016\u0010\u001c\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0018R\u0016\u0010\u001d\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0018\u00a8\u0006 "}, d2={"Lgg/mantle/mod/client/gui/components/PlayerComponent;", "Lgg/essential/elementa/UIComponent;", "Lnet/minecraft/class_746;", "player", "", "isDraggable", "<init>", "(Lnet/minecraft/class_746;Z)V", "Lgg/essential/universal/UMatrixStack;", "originalStack", "", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "stack", "", "scale", "drawEntity", "(Lgg/essential/universal/UMatrixStack;Lnet/minecraft/class_746;D)V", "setPlayer", "(Lnet/minecraft/class_746;)V", "Z", "isDragging", "", "lastX", "F", "lastY", "Lnet/minecraft/class_746;", "rotationHorizontal", "rotationVerticalFront", "rotationVerticalSide", "Companion", "FakePlayerCamera", "Mantle"})
public final class PlayerComponent
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private class_746 player;
    private final boolean isDraggable;
    private boolean isDragging;
    private float rotationVerticalFront;
    private float rotationVerticalSide;
    private float rotationHorizontal;
    private float lastX;
    private float lastY;
    private static boolean isRenderingPreview;

    public PlayerComponent(@Nullable class_746 player, boolean isDraggable) {
        this.player = player;
        this.isDraggable = isDraggable;
        this.onMouseClick((Function2)new Function2<UIComponent, UIClickEvent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent event) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!isDraggable || event.getMouseButton() != 0) {
                    return;
                }
                isDragging = true;
                lastX = event.getRelativeX();
                lastY = event.getRelativeY();
            }
        }).onMouseRelease((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                isDragging = false;
                lastX = -1.0f;
                lastY = -1.0f;
            }
        }).onMouseDrag((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseDrag, float mouseX, float mouseY, int mouseButton) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                if (!isDraggable || !isDragging) {
                    return;
                }
                float deltaX = (mouseX - lastX) / 1.5f;
                float deltaY = (mouseY - lastY) / 1.5f;
                PlayerComponent playerComponent = this;
                playerComponent.rotationHorizontal = playerComponent.rotationHorizontal + deltaX;
                playerComponent = this;
                playerComponent.rotationVerticalFront = playerComponent.rotationVerticalFront + -RangesKt.coerceIn((float)deltaY, (float)-30.0f, (float)30.0f);
                lastX = mouseX;
                lastY = mouseY;
            }
        });
    }

    public void draw(@NotNull UMatrixStack originalStack) {
        Intrinsics.checkNotNullParameter((Object)originalStack, (String)"originalStack");
        this.beforeDraw(originalStack);
        if (this.player != null) {
            float width = this.getWidth();
            float height = this.getHeight();
            float widthPadding = width * 0.05f;
            float heightPadding = height * 0.05f;
            float x = this.getLeft();
            float y = this.getTop() - heightPadding / 2.0f;
            float boundingHeight = Math.min((width -= widthPadding) * (float)2, height -= heightPadding);
            double scale = (double)boundingHeight * 0.525;
            UMatrixStack stack = originalStack.fork();
            stack.translate(0.0, (double)(-this.getHeight()) / 4.0, 0.0);
            stack.translate(0.0f, 0.0f, 500.0f);
            stack.translate(x + this.getWidth() / (float)2, y + this.getHeight() / (float)2, 0.0f);
            stack.translate(0.0f, this.getHeight() / (float)4, -50.0f);
            UMatrixStack.rotate$default((UMatrixStack)stack, (float)this.rotationVerticalFront, (float)1.0f, (float)0.0f, (float)0.0f, (boolean)false, (int)16, null);
            UMatrixStack.rotate$default((UMatrixStack)stack, (float)this.rotationVerticalSide, (float)0.0f, (float)0.0f, (float)1.0f, (boolean)false, (int)16, null);
            UMatrixStack.rotate$default((UMatrixStack)stack, (float)this.rotationHorizontal, (float)0.0f, (float)1.0f, (float)0.0f, (boolean)false, (int)16, null);
            stack.translate(0.0f, this.getHeight() / (float)2, -50.0f);
            stack.translate(0.0, (double)(-(height - boundingHeight)) / 2.0, 0.0);
            class_746 class_7462 = this.player;
            Intrinsics.checkNotNull((Object)class_7462);
            this.drawEntity(stack, class_7462, scale);
        }
        super.draw(originalStack);
    }

    public final void setPlayer(@NotNull class_746 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
    }

    private final void drawEntity(UMatrixStack stack, class_746 player, double scale) {
        isRenderingPreview = true;
        class_310 client = UMinecraft.getMinecraft();
        client.method_1561().field_4686 = new FakePlayerCamera(player, this.rotationHorizontal, this.rotationVerticalFront);
        UGraphics.directColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        UGraphics.enableDepth();
        stack.runWithGlobalState((Function0)new Function0<Unit>(player, scale){
            final /* synthetic */ class_746 $player;
            final /* synthetic */ double $scale;
            {
                this.$player = $player;
                this.$scale = $scale;
                super(0);
            }

            public final void invoke() {
                float originalPitch = this.$player.method_36455();
                float originalYaw = this.$player.method_36454();
                float originalHeadYaw = this.$player.field_6241;
                float originalPrevHeadYaw = this.$player.field_6259;
                float originalBodyYaw = this.$player.field_6283;
                this.$player.method_36457(0.0f);
                this.$player.method_36456(180.0f);
                this.$player.field_6241 = 180.0f;
                this.$player.field_6259 = 180.0f;
                this.$player.field_6283 = 180.0f;
                class_310 client = UMinecraft.getMinecraft();
                class_332 ctx = new class_332(client, client.method_22940().method_23000());
                Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI);
                class_490.method_48472((class_332)ctx, (float)0.0f, (float)0.0f, (float)((float)this.$scale), (Vector3f)new Vector3f(), (Quaternionf)rotation, (Quaternionf)new Quaternionf(), (class_1309)((class_1309)this.$player));
                this.$player.method_36457(originalPitch);
                this.$player.method_36456(originalYaw);
                this.$player.field_6241 = originalHeadYaw;
                this.$player.field_6259 = originalPrevHeadYaw;
                this.$player.field_6283 = originalBodyYaw;
            }
        });
        UGraphics.depthFunc((int)515);
        UGraphics.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        UGraphics.disableDepth();
        isRenderingPreview = false;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\t"}, d2={"Lgg/mantle/mod/client/gui/components/PlayerComponent$Companion;", "", "<init>", "()V", "", "<set-?>", "isRenderingPreview", "Z", "()Z", "Mantle"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRenderingPreview() {
            return isRenderingPreview;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgg/mantle/mod/client/gui/components/PlayerComponent$FakePlayerCamera;", "Lnet/minecraft/class_4184;", "Lnet/minecraft/class_746;", "player", "", "rotationHorizontal", "rotationVerticalFront", "<init>", "(Lnet/minecraft/class_746;FF)V", "Mantle"})
    private static final class FakePlayerCamera
    extends class_4184 {
        public FakePlayerCamera(@NotNull class_746 player, float rotationHorizontal, float rotationVerticalFront) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.method_19321((class_1922)player.method_37908(), (class_1297)player, true, true, 0.0f);
            this.method_19325(rotationHorizontal, rotationVerticalFront * 0.0f);
            this.method_19324(5.0, 0.0, 0.0);
        }
    }
}

