/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.gui;

import gg.essential.elementa.components.image.ImageProvider;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ[\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00108\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lgg/mantle/mod/client/gui/MantleLoadingImage;", "Lgg/essential/elementa/components/image/ImageProvider;", "<init>", "()V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "x", "y", "width", "height", "Ljava/awt/Color;", "color", "", "drawImage", "(Lgg/essential/universal/UMatrixStack;DDDDLjava/awt/Color;)V", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "texture", "", "textureMinFilter", "textureMagFilter", "drawTexture", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/universal/utils/ReleasedDynamicTexture;Ljava/awt/Color;DDDDII)V", "Ljava/awt/image/BufferedImage;", "loadingImage", "Ljava/awt/image/BufferedImage;", "loadingTexture", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "Mantle"})
public final class MantleLoadingImage
implements ImageProvider {
    @NotNull
    public static final MantleLoadingImage INSTANCE = new MantleLoadingImage();
    @Nullable
    private static BufferedImage loadingImage = ImageIO.read(INSTANCE.getClass().getResourceAsStream("/assets/mantle/loading.png"));
    private static ReleasedDynamicTexture loadingTexture;

    private MantleLoadingImage() {
    }

    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width, double height, @NotNull Color color) {
        ReleasedDynamicTexture releasedDynamicTexture;
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (loadingTexture == null) {
            BufferedImage bufferedImage = loadingImage;
            Intrinsics.checkNotNull((Object)bufferedImage);
            ReleasedDynamicTexture releasedDynamicTexture2 = UGraphics.getTexture((BufferedImage)bufferedImage);
            Intrinsics.checkNotNullExpressionValue((Object)releasedDynamicTexture2, (String)"getTexture(loadingImage!!)");
            loadingTexture = releasedDynamicTexture2;
            loadingImage = null;
        }
        if ((releasedDynamicTexture = loadingTexture) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingTexture");
            releasedDynamicTexture = null;
        }
        this.drawTexture(matrixStack, releasedDynamicTexture, color, x, y, width, height, 9729, 9729);
    }

    private final void drawTexture(UMatrixStack matrixStack, ReleasedDynamicTexture texture, Color color, double x, double y, double width, double height, int textureMinFilter, int textureMagFilter) {
        matrixStack.push();
        UGraphics.enableBlend();
        UGraphics.enableAlpha();
        matrixStack.scale(1.0f, 1.0f, 50.0f);
        int glId = texture.getDynamicGlId();
        UGraphics.bindTexture((int)0, (int)glId);
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        UGraphics.configureTexture((int)glId, () -> MantleLoadingImage.drawTexture$lambda$0(textureMinFilter, textureMagFilter));
        worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        worldRenderer.pos(matrixStack, x, y + height, 0.0).tex(0.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width, y + height, 0.0).tex(1.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width, y, 0.0).tex(1.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x, y, 0.0).tex(0.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.drawDirect();
        matrixStack.pop();
    }

    static /* synthetic */ void drawTexture$default(MantleLoadingImage mantleLoadingImage, UMatrixStack uMatrixStack, ReleasedDynamicTexture releasedDynamicTexture, Color color, double d, double d2, double d3, double d4, int n, int n2, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n = 9728;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 9728;
        }
        mantleLoadingImage.drawTexture(uMatrixStack, releasedDynamicTexture, color, d, d2, d3, d4, n, n2);
    }

    private static final void drawTexture$lambda$0(int $textureMinFilter, int $textureMagFilter) {
        GL11.glTexParameteri((int)3553, (int)10241, (int)$textureMinFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)$textureMagFilter);
    }
}

